/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.internal.utils.AcceleoLogger;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.common.internal.utils.workspace.BundleURLConverter;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;

public final class AcceleoServicesEclipseUtil {
    private static final Set<String> REGISTERED_SERVICES = new CompactLinkedHashSet<String>();
    private static final Map<String, Class<?>> REGISTERED_CLASSES = new HashMap();

    private AcceleoServicesEclipseUtil() {
    }

    public static void clearRegistry() {
        REGISTERED_SERVICES.clear();
    }

    public static Object getServiceInstance(Class<?> serviceClass) {
        return AcceleoWorkspaceUtil.INSTANCE.getServiceInstance(serviceClass);
    }

    public static Class<?> registerService(Bundle bundle, String qualifiedName) {
        Class clazz = REGISTERED_CLASSES.get(qualifiedName);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = bundle.loadClass(qualifiedName);
            if (clazz != null) {
                REGISTERED_SERVICES.add(qualifiedName);
                REGISTERED_CLASSES.put(qualifiedName, clazz);
            }
        }
        catch (ClassNotFoundException e) {
            AcceleoLogger.log(AcceleoCommonMessages.getString("BundleClassLookupFailure", qualifiedName, bundle.getSymbolicName()), e, false);
        }
        return clazz;
    }

    public static Class<?> registerService(IProject project, String qualifiedName) {
        Class<?> clazz = AcceleoWorkspaceUtil.INSTANCE.getClass(project, qualifiedName);
        if (clazz != null) {
            REGISTERED_SERVICES.add(qualifiedName);
        }
        return clazz;
    }

    public static Class<?> registerService(String bundleName, String qualifiedName) {
        Class<?> clazz = REGISTERED_CLASSES.get(qualifiedName);
        if (clazz != null) {
            return clazz;
        }
        IProject project = AcceleoWorkspaceUtil.getProject(bundleName);
        clazz = project != null ? AcceleoServicesEclipseUtil.registerService(project, qualifiedName) : AcceleoServicesEclipseUtil.registerService(Platform.getBundle((String)bundleName), qualifiedName);
        return clazz;
    }

    public static Class<?> registerService(URI uri, String qualifiedName) {
        BundleURLConverter converter;
        Bundle bundle;
        Class<?> clazz = REGISTERED_CLASSES.get(qualifiedName);
        if (clazz != null) {
            return clazz;
        }
        if (uri.isPlatformPlugin()) {
            String bundleName = uri.segment(1);
            bundle = Platform.getBundle((String)bundleName);
            if (bundle != null) {
                clazz = AcceleoServicesEclipseUtil.registerService(bundle, qualifiedName);
            }
        } else {
            IProject project;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            String projectName = null;
            if (uri.isPlatformResource()) {
                projectName = uri.segment(1);
            } else {
                URI workspaceRootURI = URI.createURI((String)URI.decode((String)workspaceRoot.getLocationURI().toString()));
                URI workspaceRelative = uri.deresolve(workspaceRootURI);
                if (!workspaceRelative.equals(uri)) {
                    workspaceRelative = AcceleoServicesEclipseUtil.trimDoubleDot(workspaceRelative);
                    projectName = workspaceRelative.segment(1);
                }
            }
            if (projectName != null && (project = workspaceRoot.getProject(projectName)) != null && project.exists()) {
                clazz = AcceleoServicesEclipseUtil.registerService(project, qualifiedName);
            }
            if (clazz == null) {
                clazz = AcceleoServicesEclipseUtil.workspaceSuffixWorkaround(uri, qualifiedName);
            }
        }
        if (clazz == null && (bundle = (converter = new BundleURLConverter(uri.toString())).resolveInBundle(qualifiedName)) != null) {
            clazz = AcceleoServicesEclipseUtil.registerService(bundle, qualifiedName);
        }
        if (clazz != null) {
            REGISTERED_SERVICES.add(qualifiedName);
        }
        return clazz;
    }

    private static URI trimDoubleDot(URI workspaceRelative) {
        String[] segments;
        int segmentToTrim = 0;
        String[] stringArray = segments = workspaceRelative.segments();
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!"..".equals(segment)) break;
            ++segmentToTrim;
            ++n2;
        }
        if (segmentToTrim != 0 && workspaceRelative.segments().length > segmentToTrim * 2) {
            String[] newSegments = new String[segments.length - segmentToTrim * 2];
            System.arraycopy(segments, segmentToTrim * 2, newSegments, 0, segments.length - segmentToTrim * 2);
            if (newSegments.length > 0) {
                URI uriTmp = URI.createURI((String)newSegments[0]);
                int i = 1;
                while (i < newSegments.length) {
                    uriTmp = uriTmp.appendSegment(newSegments[i]);
                    ++i;
                }
                return uriTmp;
            }
        }
        return workspaceRelative;
    }

    private static Class<?> workspaceSuffixWorkaround(URI uri, String qualifiedName) {
        String bundleName;
        Bundle bundle;
        Class<?> clazz = null;
        String resolvedURI = AcceleoWorkspaceUtil.resolveAsPlatformPlugin(URI.decode((String)uri.toString()));
        URI platformURI = null;
        if (resolvedURI != null) {
            platformURI = URI.createURI((String)resolvedURI);
        }
        if (platformURI != null && (bundle = Platform.getBundle((String)(bundleName = platformURI.segment(1)))) != null) {
            clazz = AcceleoServicesEclipseUtil.registerService(bundle, qualifiedName);
        }
        return clazz;
    }
}

