/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.java;

import com.google.gwtorm.client.Access;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.PrimaryKey;
import com.google.gwtorm.client.Query;
import com.google.gwtorm.client.Relation;
import com.google.gwtorm.client.ResultSet;
import com.google.gwtorm.schema.QueryModel;
import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.java.JavaColumnModel;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;

class JavaRelationModel
extends RelationModel {
    private final Method method;
    private final Class<?> accessType;
    private final Class<?> entityType;

    JavaRelationModel(Method m) throws OrmException {
        this.method = m;
        this.initName(this.method.getName(), m.getAnnotation(Relation.class));
        this.accessType = this.method.getReturnType();
        if (this.accessType.getInterfaces().length != 1 || this.accessType.getInterfaces()[0] != Access.class) {
            throw new OrmException("Method " + this.method.getName() + " in " + this.method.getDeclaringClass().getName() + " must return a direct extension of " + Access.class);
        }
        Type gt = this.accessType.getGenericInterfaces()[0];
        if (!(gt instanceof ParameterizedType)) {
            throw new OrmException(this.accessType.getName() + " must specify entity type parameter for " + Access.class);
        }
        this.entityType = (Class)((ParameterizedType)gt).getActualTypeArguments()[0];
        this.initColumns();
        this.initQueriesAndKeys();
    }

    private void initColumns() throws OrmException {
        ArrayList<JavaColumnModel> col = new ArrayList<JavaColumnModel>();
        for (Class<?> in = this.entityType; in != null; in = in.getSuperclass()) {
            for (Field f : in.getDeclaredFields()) {
                if (f.getAnnotation(Column.class) == null) continue;
                col.add(new JavaColumnModel(f));
            }
        }
        this.initColumns(col);
    }

    private void initQueriesAndKeys() throws OrmException {
        for (Method m : this.accessType.getDeclaredMethods()) {
            if (m.getAnnotation(PrimaryKey.class) != null) {
                if (m.getReturnType() != this.entityType) {
                    throw new OrmException("PrimaryKey " + m.getName() + " must return " + this.entityType.getName());
                }
                this.initPrimaryKey(m.getName(), m.getAnnotation(PrimaryKey.class));
                continue;
            }
            if (m.getAnnotation(Query.class) == null) continue;
            if (!ResultSet.class.isAssignableFrom(m.getReturnType()) || !(m.getGenericReturnType() instanceof ParameterizedType) || ((ParameterizedType)m.getGenericReturnType()).getActualTypeArguments()[0] != this.entityType) {
                throw new OrmException("Query " + m.getName() + " must return" + " ResultSet<" + this.entityType.getName() + ">");
            }
            this.addQuery(new QueryModel(this, m.getName(), m.getAnnotation(Query.class)));
        }
    }

    @Override
    public String getAccessInterfaceName() {
        return this.accessType.getName();
    }

    @Override
    public String getEntityTypeClassName() {
        return this.entityType.getName();
    }
}

