/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.jdbc.gen;

import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.Schema;
import com.google.gwtorm.jdbc.AbstractSchemaFactory;
import com.google.gwtorm.jdbc.Database;
import com.google.gwtorm.jdbc.gen.GeneratedClassLoader;
import com.google.gwtorm.jdbc.gen.SchemaGen;
import com.google.gwtorm.schema.Util;
import java.sql.Connection;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class SchemaFactoryGen<T extends Schema>
implements Opcodes {
    private final GeneratedClassLoader classLoader;
    private final SchemaGen schemaGen;
    private ClassWriter cw;
    private String superTypeName;
    private String implClassName;
    private String implTypeName;

    public SchemaFactoryGen(GeneratedClassLoader loader, SchemaGen gen) {
        this.classLoader = loader;
        this.schemaGen = gen;
    }

    public void defineClass() throws OrmException {
        this.init();
        this.implementEmptyConstructor();
        this.implementCreate();
        this.cw.visitEnd();
        this.classLoader.defineClass(this.implClassName, this.cw.toByteArray());
    }

    public AbstractSchemaFactory<T> create() throws OrmException {
        this.defineClass();
        try {
            return this.cast(Class.forName(this.implClassName, true, this.classLoader).newInstance());
        }
        catch (InstantiationException e) {
            throw new OrmException("Cannot create schema factory", e);
        }
        catch (IllegalAccessException e) {
            throw new OrmException("Cannot create schema factory", e);
        }
        catch (ClassNotFoundException e) {
            throw new OrmException("Cannot create schema factory", e);
        }
    }

    private AbstractSchemaFactory<T> cast(Object newInstance) {
        return (AbstractSchemaFactory)newInstance;
    }

    private void init() {
        this.superTypeName = Type.getInternalName(AbstractSchemaFactory.class);
        this.implClassName = this.schemaGen.getSchemaClassName() + "_Factory_" + Util.createRandomName();
        this.implTypeName = this.implClassName.replace('.', '/');
        this.cw = new ClassWriter(1);
        this.cw.visit(47, 49, this.implTypeName, null, this.superTypeName, null);
    }

    private void implementEmptyConstructor() {
        String consName = "<init>";
        String consDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", consDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, this.superTypeName, "<init>", consDesc);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementCreate() {
        MethodVisitor mv = this.cw.visitMethod(17, "create", Type.getMethodDescriptor((Type)Type.getType(Schema.class), (Type[])new Type[]{Type.getType(Database.class), Type.getType(Connection.class)}), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, this.schemaGen.getImplTypeName());
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, this.schemaGen.getImplTypeName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Database.class), Type.getType(Connection.class)}));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }
}

