/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.client;

import com.google.gwtorm.client.Key;
import com.google.gwtorm.client.KeyUtil;
import java.io.Serializable;

public abstract class CompoundKey<P extends Key<?>>
implements Key<P>,
Serializable {
    public abstract Key<?>[] members();

    @Override
    public P getParentKey() {
        return null;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        if (this.getParentKey() != null) {
            hc = this.getParentKey().hashCode();
        }
        for (Key<?> k : this.members()) {
            hc *= 31;
            hc += ((Object)k).hashCode();
        }
        return hc;
    }

    @Override
    public boolean equals(Object b) {
        Key<?>[] bMembers;
        if (b == null || b.getClass() != this.getClass()) {
            return false;
        }
        CompoundKey q = CompoundKey.cast(b);
        if (this.getParentKey() != null && !this.getParentKey().equals(q.getParentKey())) {
            return false;
        }
        Key<?>[] aMembers = this.members();
        if (aMembers.length != (bMembers = q.members()).length) {
            return false;
        }
        for (int i = 0; i < aMembers.length; ++i) {
            if (((Object)aMembers[i]).equals(bMembers[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer r = new StringBuffer();
        boolean first = true;
        if (this.getParentKey() != null) {
            r.append(KeyUtil.encode(this.getParentKey().toString()));
            first = false;
        }
        for (Key<?> k : this.members()) {
            if (!first) {
                r.append(',');
            }
            r.append(KeyUtil.encode(((Object)k).toString()));
            first = false;
        }
        return r.toString();
    }

    @Override
    public void fromString(String in) {
        String[] parts = in.split(",");
        int p = 0;
        if (this.getParentKey() != null) {
            this.getParentKey().fromString(KeyUtil.decode(parts[p++]));
        }
        for (Key<?> k : this.members()) {
            k.fromString(KeyUtil.decode(parts[p++]));
        }
    }

    private static <A extends Key<?>> CompoundKey<A> cast(Object b) {
        return (CompoundKey)b;
    }
}

