/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.impl;

import ch.ethz.iks.r_osgi.RemoteOSGiException;
import ch.ethz.iks.r_osgi.URI;
import ch.ethz.iks.r_osgi.channels.ChannelEndpoint;
import ch.ethz.iks.r_osgi.channels.ChannelEndpointManager;
import ch.ethz.iks.r_osgi.impl.ChannelEndpointImpl;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiServiceImpl;
import ch.ethz.iks.r_osgi.messages.RemoteOSGiMessage;
import ch.ethz.iks.r_osgi.types.Timestamp;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.osgi.framework.ServiceRegistration;

final class ChannelEndpointMultiplexer
implements ChannelEndpoint,
ChannelEndpointManager {
    ChannelEndpointImpl primary;
    private final HashMap policies = new HashMap(0);
    private ServiceRegistration reg;
    private final Map mappings = new HashMap();

    ChannelEndpointMultiplexer(ChannelEndpointImpl primary) {
        if (primary == null) {
            throw new IllegalArgumentException("Multiplexer must not be constructed from NULL primary endpoint");
        }
        this.primary = primary;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Dictionary getPresentationProperties(String service) {
        return this.primary.getPresentationProperties(service);
    }

    @Override
    public Dictionary getProperties(String service) {
        return this.primary.getProperties(service);
    }

    @Override
    public URI getRemoteAddress() {
        return this.primary.getRemoteAddress();
    }

    @Override
    public Object invokeMethod(String serviceURI, String methodSignature, Object[] args) throws Throwable {
        Mapping mapping = (Mapping)this.mappings.get(serviceURI);
        if (mapping == null) {
            return this.primary.invokeMethod(serviceURI, methodSignature, args);
        }
        Integer p = (Integer)this.policies.get(serviceURI);
        if (p == null) {
            return this.primary.invokeMethod(mapping.getMapped(this.primary), methodSignature, args);
        }
        int policy = p;
        if (policy == 2) {
            ChannelEndpoint endpoint = mapping.getAny();
            try {
                return endpoint.invokeMethod(mapping.getMapped(endpoint), methodSignature, args);
            }
            catch (RemoteOSGiException e) {
                ChannelEndpointImpl next = mapping.getNext();
                if (next != null) {
                    this.primary.untrackRegistration(serviceURI);
                    this.primary = next;
                    this.primary.trackRegistration(serviceURI, this.reg);
                    if (RemoteOSGiServiceImpl.DEBUG) {
                        RemoteOSGiServiceImpl.log.log(3, "DOING FAILOVER TO " + this.primary.getRemoteAddress());
                    }
                    return this.primary.invokeMethod(mapping.getMapped(this.primary), methodSignature, args);
                }
                this.dispose();
                throw e;
            }
        }
        try {
            if (!this.primary.isConnected()) {
                throw new RemoteOSGiException("channel went down");
            }
            return this.primary.invokeMethod(mapping.getMapped(this.primary), methodSignature, args);
        }
        catch (RemoteOSGiException e) {
            ChannelEndpointImpl next;
            if (policy == 1 && (next = mapping.getNext()) != null) {
                this.primary.untrackRegistration(serviceURI);
                this.primary = next;
                this.primary.trackRegistration(serviceURI, this.reg);
                if (RemoteOSGiServiceImpl.DEBUG) {
                    RemoteOSGiServiceImpl.log.log(3, "DOING FAILOVER TO " + this.primary.getRemoteAddress());
                }
                return this.primary.invokeMethod(mapping.getMapped(this.primary), methodSignature, args);
            }
            this.dispose();
            throw e;
        }
    }

    @Override
    public void receivedMessage(RemoteOSGiMessage msg) {
        throw new IllegalArgumentException("Not supported through endpoint multiplexer");
    }

    @Override
    public void trackRegistration(String service, ServiceRegistration sreg) {
        this.reg = sreg;
        this.primary.trackRegistration(service, sreg);
    }

    @Override
    public void untrackRegistration(String service) {
        this.primary.untrackRegistration(service);
    }

    public boolean isConnected() {
        return this.primary.isConnected();
    }

    @Override
    public void addRedundantEndpoint(URI service, URI redundantService) {
        ChannelEndpointImpl redundantEndpoint = RemoteOSGiServiceImpl.getChannel(redundantService);
        this.primary.hasRedundantLinks = true;
        Mapping mapping = (Mapping)this.mappings.get(service);
        if (mapping == null) {
            mapping = new Mapping(service.toString());
            this.mappings.put(service.toString(), mapping);
        }
        mapping.addRedundant(redundantService.toString(), redundantEndpoint);
    }

    @Override
    public URI getLocalAddress() {
        return this.primary.getLocalAddress();
    }

    @Override
    public void removeRedundantEndpoint(URI service, URI redundantService) {
        ChannelEndpointImpl redundantEndpoint = RemoteOSGiServiceImpl.getChannel(redundantService);
        Mapping mapping = (Mapping)this.mappings.get(service.toString());
        mapping.removeRedundant(redundantEndpoint);
        if (mapping.isEmpty()) {
            this.mappings.remove(service);
            this.primary.hasRedundantLinks = false;
        }
    }

    @Override
    public void setEndpointPolicy(URI service, int policy) {
        this.policies.put(service.toString(), policy);
    }

    @Override
    public Timestamp transformTimestamp(Timestamp timestamp) throws RemoteOSGiException {
        return this.primary.getOffset().transform(timestamp);
    }

    private class Mapping {
        private final Random random = new Random(System.currentTimeMillis());
        private final List redundant = new ArrayList(0);
        private final Map uriMapping = new HashMap(0);

        Mapping(String serviceURI) {
            this.uriMapping.put(ChannelEndpointMultiplexer.this.primary, serviceURI);
        }

        void addRedundant(String redundantServiceURI, ChannelEndpoint endpoint) {
            this.redundant.add(endpoint);
            this.uriMapping.put(endpoint, redundantServiceURI);
        }

        void removeRedundant(ChannelEndpoint endpoint) {
            this.redundant.remove(endpoint);
            this.uriMapping.remove(endpoint);
        }

        String getMapped(ChannelEndpoint endpoint) {
            return (String)this.uriMapping.get(endpoint);
        }

        ChannelEndpointImpl getNext() {
            return (ChannelEndpointImpl)this.redundant.remove(0);
        }

        boolean isEmpty() {
            return this.redundant.size() == 0;
        }

        ChannelEndpoint getAny() {
            int ran = this.random.nextInt(this.redundant.size() + 1);
            if (ran == 0) {
                return ChannelEndpointMultiplexer.this.primary;
            }
            return (ChannelEndpoint)this.redundant.get(ran - 1);
        }
    }
}

