/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mat.query.refined.Filter;

public abstract class TextEmitter {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    protected static final String COLUMN_SEPARATOR = "|";
    private Map<Integer, Integer> columnLengths = new HashMap<Integer, Integer>();
    protected int[] order;
    protected int[] align;

    protected abstract void append(String var1);

    protected abstract void done();

    protected abstract Object[] getItems();

    protected abstract Object[] getColumns();

    protected abstract boolean shouldAddNextLine(Object var1);

    protected abstract String getItemValue(Object var1, int var2);

    protected abstract boolean shouldSuppressLineBreak(Object var1);

    protected abstract void findColumnOrderAndAlignment(Object[] var1);

    protected abstract String getColumnName(Object var1);

    protected abstract int getColumnLength(Object[] var1, Object[] var2, int var3);

    protected abstract boolean shouldProcessChild(Object var1);

    protected abstract String getDisplayableRowValue(Object var1);

    protected abstract String getDisplayableColumnValue(Object var1, int var2);

    protected abstract String getDisplayableColumnValueInSimpleStructure(Object var1);

    protected abstract boolean isExpanded(Object var1);

    protected abstract Object[] getChildren(Object var1);

    protected abstract boolean isAlignmentRight(int var1);

    protected abstract boolean isAlignmentCenter(int var1);

    public void doCopy() {
        Object[] items = this.getItems();
        Object[] columns = this.getColumns();
        int numberOfColumns = columns.length;
        if (numberOfColumns == 0) {
            this.copySimpleStructure(items);
        } else {
            this.findColumnOrderAndAlignment(columns);
            int columnIndex = 0;
            while (columnIndex < numberOfColumns) {
                int columnLength = this.getColumnLength(items, columns, columnIndex);
                Integer existingLength = this.columnLengths.get(columnIndex);
                if (existingLength == null || columnLength > existingLength) {
                    this.columnLengths.put(columnIndex, columnLength);
                }
                ++columnIndex;
            }
            int i = 0;
            while (i < this.order.length) {
                int col = this.order[i];
                if (i != 0) {
                    this.append(COLUMN_SEPARATOR);
                }
                this.append(this.align(this.getColumnName(columns[col]), this.align[col], this.columnLengths.get(col), i + 1 == numberOfColumns));
                ++i;
            }
            this.append(LINE_SEPARATOR);
            String dashedLine = this.getDashedLine(numberOfColumns);
            this.append(String.valueOf(dashedLine) + LINE_SEPARATOR);
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                boolean addLineBreak = true;
                int i2 = 0;
                while (i2 < this.order.length) {
                    int columnIndex2 = this.order[i2];
                    if (this.shouldSuppressLineBreak(item)) {
                        addLineBreak = false;
                        break;
                    }
                    String value = this.getItemValue(item, columnIndex2);
                    String[] stringArray = Filter.FILTER_TYPES;
                    int n3 = Filter.FILTER_TYPES.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String filterName = stringArray[n4];
                        if (value.equals(filterName)) {
                            value = "";
                        }
                        ++n4;
                    }
                    if (i2 != 0) {
                        this.append(COLUMN_SEPARATOR);
                    }
                    this.append(this.align(value, this.align[columnIndex2], this.columnLengths.get(columnIndex2), i2 + 1 == numberOfColumns));
                    ++i2;
                }
                if (addLineBreak) {
                    this.append(LINE_SEPARATOR);
                }
                if (this.shouldAddNextLine(item)) {
                    this.addNextLine(new StringBuilder(), item, numberOfColumns, this.columnLengths.get(this.order[0]));
                }
                ++n2;
            }
            this.columnLengths.clear();
            this.append(String.valueOf(dashedLine) + LINE_SEPARATOR);
        }
        this.done();
    }

    protected StringBuilder getLevel(StringBuilder level, int length, int counter) {
        int k = level.indexOf("'-");
        if (k != -1) {
            level.replace(k, k + 2, "  ");
        } else {
            k = level.indexOf("|-");
            if (k != -1) {
                level.replace(k + 1, k + 2, " ");
            }
        }
        if (counter == length - 1) {
            level.append('\'');
        } else {
            level.append('|');
        }
        level.append("- ");
        return level;
    }

    private void addNextLine(StringBuilder level, Object item, int numberOfColumns, int length) {
        Object[] children = this.getChildren(item);
        if (children != null) {
            int j = 0;
            while (j < children.length) {
                level = this.getLevel(level, children.length, j);
                if (this.shouldProcessChild(children[j])) {
                    if (numberOfColumns < 1) {
                        this.append(level.toString());
                        this.append(this.getDisplayableRowValue(children[j]));
                    } else {
                        int col = this.order[0];
                        this.append(level.toString());
                        this.append(this.align(this.getDisplayableColumnValue(children[j], col), this.align[col], length - level.length(), numberOfColumns == 1));
                        int i = 1;
                        while (i < this.order.length) {
                            col = this.order[i];
                            this.append(COLUMN_SEPARATOR);
                            this.append(this.align(this.getDisplayableColumnValue(children[j], col), this.align[col], this.columnLengths.get(col), i + 1 == numberOfColumns));
                            ++i;
                        }
                    }
                    this.append(LINE_SEPARATOR);
                    if (this.isExpanded(children[j])) {
                        this.addNextLine(level, children[j], numberOfColumns, length);
                    }
                    if (level.length() >= 3) {
                        level.delete(level.length() - 3, level.length());
                    }
                }
                ++j;
            }
        }
    }

    protected void copySimpleStructure(Object[] items) {
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            boolean addLineBreak = true;
            if (this.shouldSuppressLineBreak(item)) {
                addLineBreak = false;
            } else {
                String value = this.getDisplayableColumnValueInSimpleStructure(item);
                this.append(value);
                if (addLineBreak) {
                    this.append(LINE_SEPARATOR);
                }
                if (this.shouldAddNextLine(item)) {
                    this.addNextLine(new StringBuilder(), item, 0, this.getDisplayableRowValue(item).length());
                }
            }
            ++n2;
        }
    }

    protected String align(String s, int alignment, int length, boolean last) {
        int right;
        int left;
        StringBuilder buf = new StringBuilder(length);
        if (s == null) {
            s = "";
            if (last) {
                return s;
            }
        }
        if (s.length() > length) {
            if (this.isAlignmentRight(alignment) && s.length() == length + 1) {
                s = String.valueOf(s) + ' ';
            }
            return s;
        }
        int blanks = length - s.length();
        if (this.isAlignmentRight(alignment)) {
            left = blanks + 1;
            right = 1;
        } else if (this.isAlignmentCenter(alignment)) {
            left = blanks / 2;
            right = blanks - left;
        } else {
            left = 0;
            right = blanks;
        }
        int i = 0;
        while (i < left) {
            buf.append(' ');
            ++i;
        }
        buf.append(s);
        if (!last) {
            i = 0;
            while (i < right) {
                buf.append(' ');
                ++i;
            }
        }
        return buf.toString();
    }

    protected String getDashedLine(int numberOfColumns) {
        StringBuilder dashes = new StringBuilder();
        int dashesLength = 0;
        int i = 0;
        while (i < this.order.length) {
            int col = this.order[i];
            if (i != 0) {
                dashesLength += COLUMN_SEPARATOR.length();
            }
            dashesLength += this.align(null, this.align[col], this.columnLengths.get(col), false).length();
            ++i;
        }
        i = 0;
        while (i < dashesLength) {
            dashes.append('-');
            ++i;
        }
        return dashes.toString();
    }
}

