/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.debug.core.PDebugUtils;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.messages.Messages;
import org.eclipse.ptp.internal.debug.core.sourcelookup.IPSourceLocation;
import org.eclipse.ptp.internal.debug.core.sourcelookup.IProjectSourceLocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SourceUtils {
    private static final String NAME_COMMON_SOURCE_LOCATIONS = "commonSourceLocations";
    private static final String NAME_SOURCE_LOCATION = "sourceLocation";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_MEMENTO = "memento";

    public static ISourceContainer[] convertSourceLocations(IPSourceLocation[] locations) {
        ArrayList<ProjectSourceContainer> containers = new ArrayList<ProjectSourceContainer>(locations.length);
        int i = 0;
        while (i < locations.length) {
            if (locations[i] instanceof IProjectSourceLocation) {
                containers.add(new ProjectSourceContainer(((IProjectSourceLocation)locations[i]).getProject(), false));
            }
            ++i;
        }
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    public static IPSourceLocation[] getCommonSourceLocationsFromMemento(String memento) {
        IPSourceLocation[] result = new IPSourceLocation[]{};
        if (!SourceUtils.isEmpty(memento)) {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                StringReader reader = new StringReader(memento);
                InputSource source = new InputSource(reader);
                Element root = parser.parse(source).getDocumentElement();
                if (root.getNodeName().equalsIgnoreCase(NAME_COMMON_SOURCE_LOCATIONS)) {
                    result = SourceUtils.initializeSourceLocations(root);
                }
            }
            catch (ParserConfigurationException e) {
                PTPDebugCorePlugin.log((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 0, Messages.SourceUtils_0, (Throwable)e));
            }
            catch (SAXException e) {
                PTPDebugCorePlugin.log((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 0, Messages.SourceUtils_1, (Throwable)e));
            }
            catch (IOException e) {
                PTPDebugCorePlugin.log((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 0, Messages.SourceUtils_2, (Throwable)e));
            }
        }
        return result;
    }

    public static String getCommonSourceLocationsMemento(IPSourceLocation[] locations) {
        Document document = null;
        Exception ex = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(NAME_COMMON_SOURCE_LOCATIONS);
            document.appendChild(element);
            SourceUtils.saveSourceLocations(document, element, locations);
            return PDebugUtils.serializeDocument(document);
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        catch (TransformerException e) {
            ex = e;
        }
        PTPDebugCorePlugin.log((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 0, Messages.SourceUtils_3, (Throwable)ex));
        return null;
    }

    public static IPSourceLocation[] initializeSourceLocations(Element root) {
        LinkedList<IPSourceLocation> sourceLocations = new LinkedList<IPSourceLocation>();
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            block11: {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(NAME_SOURCE_LOCATION)) {
                    String className = entry.getAttribute(ATTR_CLASS);
                    String data = entry.getAttribute(ATTR_MEMENTO);
                    if (className == null || className.trim().length() == 0) {
                        PTPDebugCorePlugin.log(Messages.SourceUtils_4);
                    } else {
                        Class clazz = null;
                        try {
                            clazz = PTPDebugCorePlugin.getDefault().getBundle().loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            PTPDebugCorePlugin.log(NLS.bind((String)Messages.SourceUtils_5, (Object[])new Object[]{className}));
                            break block11;
                        }
                        IPSourceLocation location = null;
                        try {
                            location = (IPSourceLocation)clazz.newInstance();
                        }
                        catch (IllegalAccessException e) {
                            PTPDebugCorePlugin.log(String.valueOf(Messages.SourceUtils_6) + e.getMessage());
                            break block11;
                        }
                        catch (InstantiationException e) {
                            PTPDebugCorePlugin.log(String.valueOf(Messages.SourceUtils_6) + e.getMessage());
                            break block11;
                        }
                        try {
                            location.initializeFrom(data);
                            sourceLocations.add(location);
                        }
                        catch (CoreException e) {
                            PTPDebugCorePlugin.log(String.valueOf(Messages.SourceUtils_6) + e.getMessage());
                        }
                    }
                }
            }
            ++i;
        }
        return sourceLocations.toArray(new IPSourceLocation[sourceLocations.size()]);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private static void saveSourceLocations(Document doc, Element node, IPSourceLocation[] locations) {
        int i = 0;
        while (i < locations.length) {
            block3: {
                Element child = doc.createElement(NAME_SOURCE_LOCATION);
                child.setAttribute(ATTR_CLASS, locations[i].getClass().getName());
                try {
                    child.setAttribute(ATTR_MEMENTO, locations[i].getMemento());
                }
                catch (CoreException e) {
                    PTPDebugCorePlugin.log(e);
                    break block3;
                }
                node.appendChild(child);
            }
            ++i;
        }
    }
}

