/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.declaration.XtendMemberDeclarationImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public abstract class XtendTypeDeclarationImpl<T extends XtendTypeDeclaration>
extends XtendMemberDeclarationImpl<T>
implements TypeDeclaration {
    public String getPackageName() {
        return ((XtendFile)EcoreUtil2.getContainerOfType((EObject)((EObject)this.getDelegate()), XtendFile.class)).getPackage();
    }

    public String getSimpleName() {
        return ((XtendTypeDeclaration)this.getDelegate()).getName();
    }

    public String getQualifiedName() {
        return this.getQualifiedName((XtendTypeDeclaration)this.getDelegate());
    }

    private String getQualifiedName(XtendTypeDeclaration decl) {
        boolean _isAnonymous = decl.isAnonymous();
        if (_isAnonymous) {
            return null;
        }
        EObject container = decl.eContainer();
        if (container instanceof XtendFile) {
            String package_ = ((XtendFile)container).getPackage();
            if (package_ == null) {
                return decl.getName();
            }
            String _name = decl.getName();
            return String.valueOf(package_) + "." + _name;
        }
        if (container instanceof XtendTypeDeclaration) {
            String containerName = this.getQualifiedName((XtendTypeDeclaration)container);
            if (containerName == null) {
                return null;
            }
            String _name_1 = decl.getName();
            return String.valueOf(containerName) + "." + _name_1;
        }
        return null;
    }

    @Override
    public Visibility getVisibility() {
        return this.getCompilationUnit().toVisibility(((XtendTypeDeclaration)this.getDelegate()).getVisibility());
    }

    public Iterable<? extends MemberDeclaration> getDeclaredMembers() {
        Functions.Function1 _function = it -> this.getCompilationUnit().toXtendMemberDeclaration((XtendMember)it);
        return ListExtensions.map(((XtendTypeDeclaration)this.getDelegate()).getMembers(), (Functions.Function1)_function);
    }

    public boolean isAssignableFrom(Type otherType) {
        if (otherType == null) {
            return false;
        }
        TypeReference thisTypeRef = this.getCompilationUnit().getTypeReferenceProvider().newTypeReference((Type)this, new TypeReference[0]);
        TypeReference thatTypeRef = this.getCompilationUnit().getTypeReferenceProvider().newTypeReference(otherType, new TypeReference[0]);
        return thisTypeRef.isAssignableFrom(thatTypeRef);
    }

    public ConstructorDeclaration findDeclaredConstructor(TypeReference ... parameterTypes) {
        Functions.Function1 _function = constructor -> {
            Functions.Function1 _function_1 = it -> it.getType();
            List _list = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)constructor.getParameters(), (Functions.Function1)_function_1));
            List _list_1 = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)parameterTypes)));
            return Objects.equal((Object)_list, (Object)_list_1);
        };
        return (ConstructorDeclaration)IterableExtensions.findFirst(this.getDeclaredConstructors(), (Functions.Function1)_function);
    }

    public FieldDeclaration findDeclaredField(String name) {
        Functions.Function1 _function = field -> {
            String _simpleName = field.getSimpleName();
            return Objects.equal((Object)_simpleName, (Object)name);
        };
        return (FieldDeclaration)IterableExtensions.findFirst(this.getDeclaredFields(), (Functions.Function1)_function);
    }

    public TypeDeclaration findDeclaredType(String name) {
        Functions.Function1 _function = type -> {
            String _simpleName = type.getSimpleName();
            return Objects.equal((Object)_simpleName, (Object)name);
        };
        return (TypeDeclaration)IterableExtensions.findFirst(this.getDeclaredTypes(), (Functions.Function1)_function);
    }

    public MethodDeclaration findDeclaredMethod(String name, TypeReference ... parameterTypes) {
        Functions.Function1 _function = method -> Objects.equal((Object)method.getSimpleName(), (Object)name) && Objects.equal((Object)IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)method.getParameters(), it -> it.getType())), (Object)IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)parameterTypes))));
        return (MethodDeclaration)IterableExtensions.findFirst(this.getDeclaredMethods(), (Functions.Function1)_function);
    }

    public Iterable<? extends MethodDeclaration> getDeclaredMethods() {
        return Iterables.filter(this.getDeclaredMembers(), MethodDeclaration.class);
    }

    public Iterable<? extends FieldDeclaration> getDeclaredFields() {
        return Iterables.filter(this.getDeclaredMembers(), FieldDeclaration.class);
    }

    public Iterable<? extends ClassDeclaration> getDeclaredClasses() {
        return Iterables.filter(this.getDeclaredMembers(), ClassDeclaration.class);
    }

    public Iterable<? extends ConstructorDeclaration> getDeclaredConstructors() {
        return Iterables.filter(this.getDeclaredMembers(), ConstructorDeclaration.class);
    }

    public Iterable<? extends InterfaceDeclaration> getDeclaredInterfaces() {
        return Iterables.filter(this.getDeclaredMembers(), InterfaceDeclaration.class);
    }

    public Iterable<? extends AnnotationTypeDeclaration> getDeclaredAnnotationTypes() {
        return Iterables.filter(this.getDeclaredMembers(), AnnotationTypeDeclaration.class);
    }

    public Iterable<? extends EnumerationTypeDeclaration> getDeclaredEnumerationTypes() {
        return Iterables.filter(this.getDeclaredMembers(), EnumerationTypeDeclaration.class);
    }

    public Iterable<? extends TypeDeclaration> getDeclaredTypes() {
        return Iterables.filter(this.getDeclaredMembers(), TypeDeclaration.class);
    }
}

