/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.php.composer.api.objects.Person;
import org.eclipse.php.composer.ui.ComposerUIPluginImages;
import org.eclipse.php.composer.ui.dialogs.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PersonDialog
extends Dialog {
    private Person person;
    private Text name;
    private Text email;
    private Text homepage;
    private Text role;

    public PersonDialog(Shell parentShell, Person author) {
        super(parentShell);
        this.person = author;
    }

    public PersonDialog(IShellProvider parentShell, Person author) {
        super(parentShell);
        this.person = author;
    }

    public Person getPerson() {
        return this.person;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.PersonDialog_Title);
        this.getShell().setImage(ComposerUIPluginImages.PERSON.createImage());
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(2, false));
        Label lblName = new Label(contents, 0);
        GridData gd_lblName = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblName.widthHint = 100;
        lblName.setLayoutData((Object)gd_lblName);
        lblName.setText(Messages.PersonDialog_NameLabel);
        this.name = new Text(contents, 2048);
        GridData gd_name = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_name.widthHint = 175;
        this.name.setLayoutData((Object)gd_name);
        if (this.person.getName() != null) {
            this.name.setText(this.person.getName());
        }
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PersonDialog.this.person.setName(PersonDialog.this.name.getText());
            }
        });
        Label lblEmail = new Label(contents, 0);
        lblEmail.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblEmail.setText(Messages.PersonDialog_EmailLabel);
        this.email = new Text(contents, 2048);
        this.email.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.person.getEmail() != null) {
            this.email.setText(this.person.getEmail());
        }
        this.email.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PersonDialog.this.person.setEmail(PersonDialog.this.email.getText());
            }
        });
        Label lblHomepage = new Label(contents, 0);
        lblHomepage.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblHomepage.setText(Messages.PersonDialog_HomepageLabel);
        this.homepage = new Text(contents, 2048);
        this.homepage.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.person.getHomepage() != null) {
            this.homepage.setText(this.person.getHomepage());
        }
        this.homepage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PersonDialog.this.person.setHomepage(PersonDialog.this.homepage.getText());
            }
        });
        Label lblRole = new Label(contents, 0);
        lblRole.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblRole.setText(Messages.PersonDialog_RoleLabel);
        this.role = new Text(contents, 2048);
        this.role.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.person.getRole() != null) {
            this.role.setText(this.person.getRole());
        }
        this.role.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PersonDialog.this.person.setRole(PersonDialog.this.role.getText());
            }
        });
        return contents;
    }
}

