/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.make.internal.core.scannerconfig2.MakeConfigurationDataProviderMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;

public class ScannerConfigInfoFactory2 {
    private static final String SCANNER_CONFIG = "scannerConfiguration";
    private static final String SC_AUTODISCOVERY = "autodiscovery";
    private static final String ENABLED = "enabled";
    private static final String SELECTED_PROFILE_ID = "selectedProfileId";
    private static final String PROBLEM_REPORTING_ENABLED = "problemReportingEnabled";
    private static final String PROFILE = "profile";
    private static final String ID = "id";
    private static final String BUILD_OUTPUT_PROVIDER = "buildOutputProvider";
    private static final String OPEN_ACTION = "openAction";
    private static final String FILE_PATH = "filePath";
    private static final String PARSER = "parser";
    private static final String SCANNER_INFO_PROVIDER = "scannerInfoProvider";
    private static final String RUN_ACTION = "runAction";
    private static final String USE_DEFAULT = "useDefault";
    private static final String COMMAND = "command";
    private static final String ARGUMENTS = "arguments";
    private static final String DOT = ".";
    private static final String SCD = "SCD.";
    private static final String SCANNER_CONFIG_AUTODISCOVERY_ENABLED_SUFFIX = "enabled";
    private static final String SCANNER_CONFIG_SELECTED_PROFILE_ID_SUFFIX = "selectedProfileId";
    private static final String SCANNER_CONFIG_PROBLEM_REPORTING_ENABLED_SUFFIX = "problemReportingEnabled";
    private static final String BUILD_OUTPUT_OPEN_ACTION_ENABLED = ".BOP.open.enabled";
    private static final String BUILD_OUTPUT_OPEN_ACTION_FILE_PATH = ".BOP.open.path";
    private static final String BUILD_OUTPUT_PARSER_ENABLED = ".BOP.parser.enabled";
    private static final String SI_PROVIDER_RUN_ACTION_USE_DEFAULT = ".run.useDefault";
    private static final String SI_PROVIDER_RUN_ACTION_COMMAND = ".run.command";
    private static final String SI_PROVIDER_RUN_ACTION_ARGUMENTS = ".run.arguments";
    private static final String SI_PROVIDER_OPEN_ACTION_FILE_PATH = ".open.path";
    private static final String SI_PROVIDER_PARSER_ENABLED = ".parser.enabled";
    private static final String INFO_INSTANCE_IDS = "SCD.instanceIds";
    private static final String DELIMITER = ";";
    private static final String ELEMENT_CS_INFO = "scannerConfigBuildInfo";
    private static final String ATTRIBUTE_CS_INFO_INSTANCE_ID = "instanceId";

    public static IScannerConfigBuilderInfo2 create(IProject project, String profileId) throws CoreException {
        IScannerConfigBuilderInfo2Set container = ScannerConfigInfoFactory2.createInfoSet(project, profileId);
        return container.getInfo(new InfoContext(project));
    }

    public static IScannerConfigBuilderInfo2 create(Preferences prefs, String profileId, boolean useDefaults) {
        IScannerConfigBuilderInfo2Set container = ScannerConfigInfoFactory2.createInfoSet(prefs, profileId, useDefaults);
        return container.getInfo(new InfoContext(null));
    }

    public static IScannerConfigBuilderInfo2Set createInfoSet(Preferences prefs, String profileId, boolean useDefaults) {
        return new PreferenceSet(prefs, profileId, useDefaults);
    }

    public static IScannerConfigBuilderInfo2Set createInfoSet(IProject project, String profileId) {
        return new ScannerConfigInfoSet(project, profileId);
    }

    private static class BuildProperty
    extends Store {
        private IProject project;
        private InfoContext context;
        private String profileId;
        private ScannerConfigInfoSet container;

        BuildProperty(ScannerConfigInfoSet container, IProject project, InfoContext context, String profileId, ICStorageElement element) {
            this.project = project;
            this.context = context;
            this.profileId = profileId;
            this.container = container;
            this.load(element);
        }

        BuildProperty(ScannerConfigInfoSet container, IProject project, InfoContext context, Store base, String profileId) {
            super(base, profileId);
            this.project = project;
            this.context = context;
            this.container = container;
            if (!profileId.equals("")) {
                this.profileId = profileId;
            } else if (base instanceof BuildProperty) {
                BuildProperty prop = (BuildProperty)base;
                this.profileId = prop.profileId;
            } else {
                Preference pref = (Preference)base;
                this.profileId = pref.profileId;
            }
        }

        protected void load(ICStorageElement element) {
            List<String> profileIds = ScannerConfigProfileManager.getInstance().getProfileIds(this.context);
            for (String profileId : profileIds) {
                this.profileOptionsMap.put(profileId, BuildProperty.getDefaultProfile(profileId));
            }
            boolean performMigration = true;
            ICStorageElement[] iCStorageElementArray = element.getChildren();
            int n = iCStorageElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICStorageElement sc = iCStorageElementArray[n2];
                if (sc.getName().equals(ScannerConfigInfoFactory2.SC_AUTODISCOVERY)) {
                    this.autoDiscoveryEnabled = Boolean.valueOf(sc.getAttribute("enabled"));
                    this.selectedProfile = this.profileId == "" ? sc.getAttribute("selectedProfileId") : this.profileId;
                    this.selectedProfile = SafeStringInterner.safeIntern((String)this.selectedProfile);
                    this.problemReportingEnabled = Boolean.valueOf(sc.getAttribute("problemReportingEnabled"));
                    performMigration = false;
                } else if (sc.getName().equals(ScannerConfigInfoFactory2.PROFILE)) {
                    if (profileIds.contains(sc.getAttribute(ScannerConfigInfoFactory2.ID))) {
                        this.loadProfile(sc);
                    }
                    performMigration = false;
                }
                ++n2;
            }
            if (performMigration && !this.migrateScannerConfigBuildInfo(ScannerConfigProfileManager.PER_PROJECT_PROFILE_ID)) {
                this.autoDiscoveryEnabled = false;
            }
        }

        private boolean migrateScannerConfigBuildInfo(String profileId) {
            boolean rc = true;
            try {
                IScannerConfigBuilderInfo oldInfo = MakeCorePlugin.createScannerConfigBuildInfo(this.project, ScannerConfigBuilder.BUILDER_ID);
                this.autoDiscoveryEnabled = oldInfo.isAutoDiscoveryEnabled();
                this.problemReportingEnabled = oldInfo.isSIProblemGenerationEnabled();
                this.selectedProfile = SafeStringInterner.safeIntern((String)profileId);
                Store.ProfileOptions po = new Store.ProfileOptions();
                po.buildOutputFileActionEnabled = false;
                po.buildOutputParserEnabled = oldInfo.isMakeBuilderConsoleParserEnabled();
                Store.ProfileOptions.ProviderOptions ppo = new Store.ProfileOptions.ProviderOptions();
                ppo.providerKind = "run";
                ppo.providerOutputParserEnabled = oldInfo.isESIProviderCommandEnabled();
                ppo.providerRunUseDefault = oldInfo.isDefaultESIProviderCmd();
                ppo.providerRunCommand = oldInfo.getESIProviderCommand().toString();
                ppo.providerRunArguments = oldInfo.getESIProviderArguments();
                ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(this.selectedProfile);
                String providerId = configuredProfile.getSIProviderIds().get(0);
                po.providerOptionsMap = new LinkedHashMap<String, Store.ProfileOptions.ProviderOptions>(1);
                po.providerOptionsMap.put(providerId, ppo);
                this.profileOptionsMap = new LinkedHashMap(1);
                this.profileOptionsMap.put(profileId, po);
                this.isDirty = true;
                this.save();
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
                rc = false;
            }
            return rc;
        }

        private void loadProfile(ICStorageElement profile) {
            Store.ProfileOptions po = new Store.ProfileOptions();
            String profileId = profile.getAttribute(ScannerConfigInfoFactory2.ID);
            this.profileOptionsMap.put(profileId, po);
            ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
            List<String> providerIds = configuredProfile.getSIProviderIds();
            int providerCounter = 0;
            po.providerOptionsMap = new LinkedHashMap<String, Store.ProfileOptions.ProviderOptions>(providerIds.size());
            ICStorageElement[] iCStorageElementArray = profile.getChildren();
            int n = iCStorageElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICStorageElement child = iCStorageElementArray[n2];
                if (ScannerConfigInfoFactory2.BUILD_OUTPUT_PROVIDER.equals(child.getName())) {
                    ICStorageElement[] iCStorageElementArray2 = child.getChildren();
                    int n3 = iCStorageElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICStorageElement grandchild = iCStorageElementArray2[n4];
                        if (ScannerConfigInfoFactory2.OPEN_ACTION.equals(grandchild.getName())) {
                            po.buildOutputFileActionEnabled = Boolean.valueOf(grandchild.getAttribute("enabled"));
                            po.buildOutputFilePath = grandchild.getAttribute(ScannerConfigInfoFactory2.FILE_PATH);
                        } else if (ScannerConfigInfoFactory2.PARSER.equals(grandchild.getName())) {
                            po.buildOutputParserEnabled = Boolean.valueOf(grandchild.getAttribute("enabled"));
                        }
                        ++n4;
                    }
                } else if (ScannerConfigInfoFactory2.SCANNER_INFO_PROVIDER.equals(child.getName())) {
                    String providerId = child.getAttribute(ScannerConfigInfoFactory2.ID);
                    if (providerIds.get(providerCounter).equals(providerId)) {
                        Store.ProfileOptions.ProviderOptions ppo = new Store.ProfileOptions.ProviderOptions();
                        po.providerOptionsMap.put(providerId, ppo);
                        ppo.providerKind = configuredProfile.getScannerInfoProviderElement(providerId).getProviderKind();
                        ICStorageElement[] iCStorageElementArray3 = child.getChildren();
                        int n5 = iCStorageElementArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ICStorageElement grandchild = iCStorageElementArray3[n6];
                            if (ScannerConfigInfoFactory2.RUN_ACTION.equals(grandchild.getName())) {
                                ppo.providerRunUseDefault = Boolean.valueOf(grandchild.getAttribute(ScannerConfigInfoFactory2.USE_DEFAULT));
                                ppo.providerRunCommand = grandchild.getAttribute(ScannerConfigInfoFactory2.COMMAND);
                                ppo.providerRunArguments = grandchild.getAttribute(ScannerConfigInfoFactory2.ARGUMENTS);
                            } else if (ScannerConfigInfoFactory2.OPEN_ACTION.equals(grandchild.getName())) {
                                ppo.providerOpenFilePath = grandchild.getAttribute(ScannerConfigInfoFactory2.FILE_PATH);
                            } else if (ScannerConfigInfoFactory2.PARSER.equals(grandchild.getName())) {
                                ppo.providerOutputParserEnabled = Boolean.valueOf(grandchild.getAttribute("enabled"));
                            }
                            ++n6;
                        }
                        ++providerCounter;
                    }
                }
                ++n2;
            }
        }

        private void store(ICStorageElement sc) {
            ICStorageElement[] iCStorageElementArray = sc.getChildren();
            int n = iCStorageElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICStorageElement child = iCStorageElementArray[n2];
                sc.removeChild(child);
                ++n2;
            }
            ICStorageElement autod = sc.createChild(ScannerConfigInfoFactory2.SC_AUTODISCOVERY);
            autod.setAttribute("enabled", Boolean.toString(this.autoDiscoveryEnabled));
            autod.setAttribute("selectedProfileId", this.selectedProfile);
            autod.setAttribute("problemReportingEnabled", Boolean.toString(this.problemReportingEnabled));
            for (Map.Entry entry : this.profileOptionsMap.entrySet()) {
                if (((Store.ProfileOptions)entry.getValue()).equals(defaultProfiles.get(entry.getKey()))) continue;
                ICStorageElement profile = sc.createChild(ScannerConfigInfoFactory2.PROFILE);
                profile.setAttribute(ScannerConfigInfoFactory2.ID, (String)entry.getKey());
                this.store(profile, (Store.ProfileOptions)entry.getValue());
            }
            this.isDirty = false;
        }

        private void store(ICStorageElement profile, Store.ProfileOptions po) {
            ICStorageElement child = profile.createChild(ScannerConfigInfoFactory2.BUILD_OUTPUT_PROVIDER);
            ICStorageElement grandchild = child.createChild(ScannerConfigInfoFactory2.OPEN_ACTION);
            grandchild.setAttribute("enabled", Boolean.toString(po.buildOutputFileActionEnabled));
            if (po.buildOutputFilePath != null) {
                grandchild.setAttribute(ScannerConfigInfoFactory2.FILE_PATH, po.buildOutputFilePath);
            }
            grandchild = child.createChild(ScannerConfigInfoFactory2.PARSER);
            grandchild.setAttribute("enabled", Boolean.toString(po.buildOutputParserEnabled));
            ArrayList<String> providerIds = new ArrayList<String>(po.providerOptionsMap.keySet());
            int i = 0;
            while (i < providerIds.size()) {
                String providerId = (String)providerIds.get(i);
                Store.ProfileOptions.ProviderOptions ppo = po.providerOptionsMap.get(providerId);
                if (ppo != null) {
                    child = profile.createChild(ScannerConfigInfoFactory2.SCANNER_INFO_PROVIDER);
                    child.setAttribute(ScannerConfigInfoFactory2.ID, providerId);
                    String providerKind = ppo.providerKind;
                    if (providerKind.equals("run")) {
                        grandchild = child.createChild(ScannerConfigInfoFactory2.RUN_ACTION);
                        grandchild.setAttribute(ScannerConfigInfoFactory2.USE_DEFAULT, Boolean.toString(ppo.providerRunUseDefault));
                        if (ppo.providerRunCommand != null) {
                            grandchild.setAttribute(ScannerConfigInfoFactory2.COMMAND, ppo.providerRunCommand);
                        }
                        if (ppo.providerRunArguments != null) {
                            grandchild.setAttribute(ScannerConfigInfoFactory2.ARGUMENTS, ppo.providerRunArguments);
                        }
                    } else if (providerKind.equals("open")) {
                        grandchild = child.createChild(ScannerConfigInfoFactory2.OPEN_ACTION);
                        if (ppo.providerOpenFilePath != null) {
                            grandchild.setAttribute(ScannerConfigInfoFactory2.FILE_PATH, ppo.providerOpenFilePath);
                        }
                    }
                    grandchild = child.createChild(ScannerConfigInfoFactory2.PARSER);
                    grandchild.setAttribute("enabled", Boolean.toString(ppo.providerOutputParserEnabled));
                }
                ++i;
            }
        }

        @Override
        public synchronized void save() throws CoreException {
            if (this.isDirty) {
                this.container.save(true);
                this.isDirty = false;
            }
        }

        @Override
        public InfoContext getContext() {
            return this.context;
        }
    }

    private static class Preference
    extends Store {
        private Preferences prefs;
        private String profileId;
        private boolean useDefaults;
        private PreferenceSet prefsContainer;
        private InfoContext context;

        public Preference(PreferenceSet container, Preferences prefs, InfoContext context, String profileId, boolean useDefaults) {
            this.prefs = prefs;
            this.profileId = profileId;
            this.useDefaults = useDefaults;
            this.prefsContainer = container;
            this.context = context;
            this.load();
        }

        Preference(PreferenceSet container, Preferences prefs, InfoContext context, Store base, String profileId, boolean useDefaults) {
            super(base, profileId);
            this.prefs = prefs;
            this.prefsContainer = container;
            this.useDefaults = useDefaults;
            this.context = context;
            if (!profileId.equals("")) {
                this.profileId = profileId;
            } else if (base instanceof BuildProperty) {
                BuildProperty prop = (BuildProperty)base;
                this.profileId = prop.profileId;
            } else {
                Preference pref = (Preference)base;
                this.profileId = pref.profileId;
            }
        }

        protected void load() {
            String instanceId = this.context.getInstanceId();
            String prefix = instanceId.length() == 0 ? "" : "instanceId." + instanceId + ScannerConfigInfoFactory2.DOT;
            this.autoDiscoveryEnabled = this.getBoolean(String.valueOf(prefix) + "enabled");
            this.selectedProfile = "".equals(this.profileId) ? this.getString(String.valueOf(prefix) + "selectedProfileId") : this.profileId;
            this.selectedProfile = SafeStringInterner.safeIntern((String)this.selectedProfile);
            this.problemReportingEnabled = this.getBoolean(String.valueOf(prefix) + "problemReportingEnabled");
            if ("".equals(this.selectedProfile) && !this.useDefaults) {
                this.selectedProfile = SafeStringInterner.safeIntern((String)this.prefs.getDefaultString(String.valueOf(prefix) + "selectedProfileId"));
            }
            List<String> profileIds = ScannerConfigProfileManager.getInstance().getProfileIds(this.context);
            this.profileOptionsMap = new LinkedHashMap(profileIds.size());
            for (String profileId : profileIds) {
                Store.ProfileOptions po = new Store.ProfileOptions();
                this.profileOptionsMap.put(profileId, po);
                boolean profileStored = this.getBoolean(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + "enabled");
                if (!profileStored && !this.useDefaults) {
                    this.profileOptionsMap.put(profileId, Preference.getDefaultProfile(profileId));
                    continue;
                }
                po.buildOutputFileActionEnabled = this.getBoolean(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_OPEN_ACTION_ENABLED);
                po.buildOutputFilePath = this.getString(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_OPEN_ACTION_FILE_PATH);
                po.buildOutputParserEnabled = this.getBoolean(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_PARSER_ENABLED);
                ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
                List<String> providerIds = configuredProfile.getSIProviderIds();
                po.providerOptionsMap = new LinkedHashMap<String, Store.ProfileOptions.ProviderOptions>(providerIds.size());
                for (String providerId : providerIds) {
                    Store.ProfileOptions.ProviderOptions ppo = new Store.ProfileOptions.ProviderOptions();
                    po.providerOptionsMap.put(providerId, ppo);
                    ppo.providerKind = configuredProfile.getScannerInfoProviderElement(providerId).getProviderKind();
                    ppo.providerOutputParserEnabled = this.getBoolean(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_PARSER_ENABLED);
                    if (ppo.providerKind.equals("run")) {
                        ppo.providerRunUseDefault = this.getBoolean(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_USE_DEFAULT);
                        ppo.providerRunCommand = this.getString(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_COMMAND);
                        ppo.providerRunArguments = this.getString(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_ARGUMENTS);
                        continue;
                    }
                    if (!ppo.providerKind.equals("open")) continue;
                    ppo.providerOpenFilePath = this.getString(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_OPEN_ACTION_FILE_PATH);
                }
            }
        }

        private void store() {
            String prefix;
            String instanceId = this.context.getInstanceId();
            String string = prefix = instanceId.length() == 0 ? "" : "instanceId." + instanceId + ScannerConfigInfoFactory2.DOT;
            if (this.isDirty) {
                this.set(String.valueOf(prefix) + "enabled", this.autoDiscoveryEnabled);
                this.set(String.valueOf(prefix) + "selectedProfileId", this.selectedProfile);
                this.set(String.valueOf(prefix) + "problemReportingEnabled", this.problemReportingEnabled);
                for (String profileId : this.profileOptionsMap.keySet()) {
                    Store.ProfileOptions po = (Store.ProfileOptions)this.profileOptionsMap.get(profileId);
                    this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + "enabled", !this.useDefaults);
                    this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_OPEN_ACTION_ENABLED, po.buildOutputFileActionEnabled);
                    this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_OPEN_ACTION_FILE_PATH, po.buildOutputFilePath);
                    this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_PARSER_ENABLED, po.buildOutputParserEnabled);
                    ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
                    List<String> providerIds = configuredProfile.getSIProviderIds();
                    for (String providerId : providerIds) {
                        Store.ProfileOptions.ProviderOptions ppo = po.providerOptionsMap.get(providerId);
                        this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_PARSER_ENABLED, ppo.providerOutputParserEnabled);
                        String providerKind = ppo.providerKind;
                        if (providerKind.equals("run")) {
                            this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_USE_DEFAULT, ppo.providerRunUseDefault);
                            this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_COMMAND, ppo.providerRunCommand);
                            this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_ARGUMENTS, ppo.providerRunArguments);
                            continue;
                        }
                        if (!providerKind.equals("open")) continue;
                        this.set(ScannerConfigInfoFactory2.SCD + prefix + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_OPEN_ACTION_FILE_PATH, ppo.providerOpenFilePath);
                    }
                }
                this.isDirty = false;
            }
        }

        private boolean getBoolean(String name) {
            if (this.useDefaults) {
                return this.prefs.getDefaultBoolean(name);
            }
            return this.prefs.getBoolean(name);
        }

        private void set(String name, boolean value) {
            if (this.useDefaults) {
                this.prefs.setDefault(name, value);
            } else {
                this.prefs.setValue(name, value);
            }
        }

        private String getString(String name) {
            if (this.useDefaults) {
                return this.prefs.getDefaultString(name);
            }
            return this.prefs.getString(name);
        }

        private void set(String name, String value) {
            if (this.useDefaults) {
                this.prefs.setDefault(name, value);
            } else {
                this.prefs.setValue(name, value);
            }
        }

        @Override
        public void save() throws CoreException {
            if (this.isDirty) {
                this.prefsContainer.save();
            }
        }

        @Override
        public InfoContext getContext() {
            return this.context;
        }
    }

    private static class PreferenceSet
    extends StoreSet {
        private Preferences prefs;
        private boolean useDefaults;

        PreferenceSet(Preferences prefs, String profileId, boolean loadDefaults) {
            this.prefs = prefs;
            this.useDefaults = loadDefaults;
            this.load(profileId);
        }

        private void load(String profileId) {
            InfoContext defaultContext = new InfoContext(null);
            String instancesStr = this.getString(ScannerConfigInfoFactory2.INFO_INSTANCE_IDS);
            String[] instanceIds = CDataUtil.stringToArray((String)instancesStr, (String)ScannerConfigInfoFactory2.DELIMITER);
            Preference pref = new Preference(this, this.prefs, defaultContext, profileId, this.useDefaults);
            this.fMap.put(defaultContext, pref);
            if (instanceIds != null && instanceIds.length != 0) {
                int i = 0;
                while (i < instanceIds.length) {
                    String id = instanceIds[i];
                    if (id.length() != 0) {
                        InfoContext c = new InfoContext(null, id);
                        Preference p = new Preference(this, this.prefs, c, profileId, this.useDefaults);
                        this.fMap.put(c, p);
                    }
                    ++i;
                }
            }
        }

        @Override
        public void save() throws CoreException {
            if (this.isDirty()) {
                HashSet<String> idSet = new HashSet<String>(this.fMap.size() - 1);
                Preference pref = (Preference)this.fMap.get(new InfoContext(null));
                pref.store();
                for (Map.Entry entry : this.fMap.entrySet()) {
                    Preference p;
                    String instanceId;
                    InfoContext context = (InfoContext)entry.getKey();
                    if (context.isDefaultContext() || (instanceId = context.getInstanceId()).length() == 0 || (p = (Preference)entry.getValue()) == pref) continue;
                    p.store();
                    idSet.add(instanceId);
                }
                if (idSet.size() != 0) {
                    String[] ids = idSet.toArray(new String[idSet.size()]);
                    String idsString = CDataUtil.arrayToString((String[])ids, (String)ScannerConfigInfoFactory2.DELIMITER);
                    this.set(ScannerConfigInfoFactory2.INFO_INSTANCE_IDS, idsString);
                }
                this.fIsDirty = false;
            }
        }

        @Override
        public IProject getProject() {
            return null;
        }

        @Override
        protected Store doCreateStore(InfoContext context, Store base, String profileId) {
            return new Preference(this, this.prefs, context, base, profileId, this.useDefaults);
        }

        private String getString(String name) {
            if (this.useDefaults) {
                return this.prefs.getDefaultString(name);
            }
            return this.prefs.getString(name);
        }

        private void set(String name, String value) {
            if (this.useDefaults) {
                this.prefs.setDefault(name, value);
            } else {
                this.prefs.setValue(name, value);
            }
        }
    }

    private static class ScannerConfigInfoSet
    extends StoreSet {
        private IProject fProject;

        ScannerConfigInfoSet(IProject project, String profileId) {
            this.fProject = project;
            this.load(profileId);
        }

        private void load(String profileId) {
            try {
                ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.fProject, false);
                ICStorageElement rootEl = descriptor != null ? descriptor.getProjectStorageElement(ScannerConfigInfoFactory2.SCANNER_CONFIG) : null;
                InfoContext defaultContext = new InfoContext(this.fProject);
                if (rootEl == null || !rootEl.hasChildren()) {
                    BuildProperty prop = new BuildProperty(this, this.fProject, defaultContext, (Store)ScannerConfigInfoFactory2.create(MakeCorePlugin.getDefault().getPluginPreferences(), profileId, false), profileId);
                    this.fMap.put(defaultContext, prop);
                    prop.isDirty = true;
                } else {
                    BuildProperty prop = new BuildProperty(this, this.fProject, defaultContext, profileId, rootEl);
                    this.fMap.put(defaultContext, prop);
                    ICStorageElement[] iCStorageElementArray = rootEl.getChildren();
                    int n = iCStorageElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String instanceId;
                        ICStorageElement sc = iCStorageElementArray[n2];
                        if (sc.getName().equals(ScannerConfigInfoFactory2.ELEMENT_CS_INFO) && (instanceId = sc.getAttribute(ScannerConfigInfoFactory2.ATTRIBUTE_CS_INFO_INSTANCE_ID)) != null && instanceId.length() > 0) {
                            InfoContext c = new InfoContext(this.fProject, instanceId);
                            BuildProperty p = new BuildProperty(this, this.fProject, c, profileId, sc);
                            this.fMap.put(c, p);
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
            }
        }

        @Override
        public void save() throws CoreException {
            this.save(false);
        }

        public void save(boolean serializeDescriptor) throws CoreException {
            if (this.isDirty()) {
                ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.fProject, true);
                ICStorageElement sc = descriptor.getProjectStorageElement(ScannerConfigInfoFactory2.SCANNER_CONFIG);
                sc.clear();
                BuildProperty prop = (BuildProperty)this.fMap.get(new InfoContext(this.fProject));
                prop.store(sc);
                for (Map.Entry entry : this.fMap.entrySet()) {
                    BuildProperty p;
                    String instanceId;
                    InfoContext context = (InfoContext)entry.getKey();
                    if (context.isDefaultContext() || (instanceId = context.getInstanceId()).length() == 0 || (p = (BuildProperty)entry.getValue()) == prop) continue;
                    ICStorageElement el = sc.createChild(ScannerConfigInfoFactory2.ELEMENT_CS_INFO);
                    el.setAttribute(ScannerConfigInfoFactory2.ATTRIBUTE_CS_INFO_INSTANCE_ID, instanceId);
                    p.store(el);
                }
                if (serializeDescriptor) {
                    descriptor.saveProjectData();
                }
                this.fIsDirty = false;
            }
        }

        @Override
        public IProject getProject() {
            return this.fProject;
        }

        @Override
        protected Store doCreateStore(InfoContext context, Store base, String profileId) {
            return new BuildProperty(this, this.fProject, context, base, profileId);
        }
    }

    private static abstract class Store
    implements IScannerConfigBuilderInfo2 {
        protected static final String EMPTY_STRING = "";
        protected boolean isDirty;
        protected boolean autoDiscoveryEnabled;
        protected boolean problemReportingEnabled;
        protected String selectedProfile = "";
        protected static Map<String, ProfileOptions> defaultProfiles = new ConcurrentHashMap<String, ProfileOptions>();
        protected Map<String, ProfileOptions> profileOptionsMap = new LinkedHashMap<String, ProfileOptions>();

        protected Store() {
        }

        protected Store(Store base, String profileId) {
            this.autoDiscoveryEnabled = base.autoDiscoveryEnabled;
            this.problemReportingEnabled = base.problemReportingEnabled;
            this.selectedProfile = EMPTY_STRING.equals(profileId) ? base.selectedProfile : profileId;
            this.selectedProfile = SafeStringInterner.safeIntern((String)this.selectedProfile);
            this.profileOptionsMap.putAll(base.profileOptionsMap);
            for (Map.Entry<String, ProfileOptions> entry : this.profileOptionsMap.entrySet()) {
                ProfileOptions basePo = entry.getValue();
                entry.setValue(new ProfileOptions(basePo));
            }
            this.isDirty = true;
        }

        @Override
        public boolean isAutoDiscoveryEnabled() {
            return this.autoDiscoveryEnabled;
        }

        @Override
        public void setAutoDiscoveryEnabled(boolean enable) {
            this.autoDiscoveryEnabled = this.setDirty(this.autoDiscoveryEnabled, enable);
        }

        @Override
        public boolean isProblemReportingEnabled() {
            return this.problemReportingEnabled;
        }

        @Override
        public void setProblemReportingEnabled(boolean enable) {
            this.problemReportingEnabled = this.setDirty(this.problemReportingEnabled, enable);
        }

        @Override
        public String getSelectedProfileId() {
            return this.selectedProfile;
        }

        @Override
        public void setSelectedProfileId(String profileId) {
            this.selectedProfile = SafeStringInterner.safeIntern((String)this.setDirty(this.selectedProfile, profileId));
        }

        @Override
        public List<String> getProfileIdList() {
            return new ArrayList<String>(this.profileOptionsMap.keySet());
        }

        @Override
        public boolean isBuildOutputFileActionEnabled() {
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            return po != null ? po.buildOutputFileActionEnabled : false;
        }

        @Override
        public void setBuildOutputFileActionEnabled(boolean enable) {
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                po.buildOutputFileActionEnabled = this.setDirty(po.buildOutputFileActionEnabled, enable);
            }
        }

        @Override
        public String getBuildOutputFilePath() {
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            return po != null ? po.buildOutputFilePath : EMPTY_STRING;
        }

        @Override
        public void setBuildOutputFilePath(String path) {
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                po.buildOutputFilePath = this.setDirty(po.buildOutputFilePath, path);
            }
        }

        @Override
        public boolean isBuildOutputParserEnabled() {
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            return po != null ? po.buildOutputParserEnabled : true;
        }

        @Override
        public void setBuildOutputParserEnabled(boolean enable) {
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                po.buildOutputParserEnabled = this.setDirty(po.buildOutputParserEnabled, enable);
            }
        }

        @Override
        public List<String> getProviderIdList() {
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            return po != null ? new ArrayList<String>(po.providerOptionsMap.keySet()) : new ArrayList(0);
        }

        @Override
        public boolean isProviderOutputParserEnabled(String providerId) {
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = po.providerOptionsMap.get(providerId);
                return ppo == null ? false : ppo.providerOutputParserEnabled;
            }
            return false;
        }

        @Override
        public void setProviderOutputParserEnabled(String providerId, boolean enable) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerOutputParserEnabled = this.setDirty(ppo.providerOutputParserEnabled, enable);
            }
        }

        @Override
        public boolean isUseDefaultProviderCommand(String providerId) {
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = po.providerOptionsMap.get(providerId);
                return ppo == null ? false : ppo.providerRunUseDefault;
            }
            return false;
        }

        @Override
        public void setUseDefaultProviderCommand(String providerId, boolean enable) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerRunUseDefault = this.setDirty(ppo.providerRunUseDefault, enable);
            }
        }

        @Override
        public String getProviderRunCommand(String providerId) {
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = po.providerOptionsMap.get(providerId);
                return ppo == null ? null : ppo.providerRunCommand;
            }
            return null;
        }

        @Override
        public void setProviderRunCommand(String providerId, String command) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerRunCommand = this.setDirty(ppo.providerRunCommand, command);
            }
        }

        @Override
        public String getProviderRunArguments(String providerId) {
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = po.providerOptionsMap.get(providerId);
                return ppo == null ? null : ppo.providerRunArguments;
            }
            return null;
        }

        @Override
        public void setProviderRunArguments(String providerId, String arguments) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerRunArguments = this.setDirty(ppo.providerRunArguments, arguments);
            }
        }

        @Override
        public String getProviderOpenFilePath(String providerId) {
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = po.providerOptionsMap.get(providerId);
                return ppo == null ? null : ppo.providerOpenFilePath;
            }
            return null;
        }

        @Override
        public void setProviderOpenFilePath(String providerId, String filePath) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerOpenFilePath = this.setDirty(ppo.providerOpenFilePath, filePath);
            }
        }

        private boolean setDirty(boolean l, boolean r) {
            this.isDirty = this.isDirty || l != r;
            return r;
        }

        private String setDirty(String l, String r) {
            this.isDirty = this.isDirty || !l.equals(r);
            return r;
        }

        protected static ProfileOptions getDefaultProfile(String profileId) {
            if (defaultProfiles.containsKey(profileId)) {
                return defaultProfiles.get(profileId).clone();
            }
            ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
            ProfileOptions po = new ProfileOptions();
            po.buildOutputParserEnabled = false;
            po.buildOutputFileActionEnabled = false;
            po.buildOutputFilePath = EMPTY_STRING;
            if (configuredProfile.getBuildOutputProviderElement() != null) {
                po.buildOutputParserEnabled = true;
                if (configuredProfile.getBuildOutputProviderElement().getAction() != null) {
                    po.buildOutputFileActionEnabled = true;
                    String buildOutputFilePath = configuredProfile.getBuildOutputProviderElement().getAction().getAttribute("file");
                    po.buildOutputFilePath = buildOutputFilePath != null ? buildOutputFilePath : EMPTY_STRING;
                }
            }
            po.providerOptionsMap = new LinkedHashMap<String, ProfileOptions.ProviderOptions>();
            for (String providerId : configuredProfile.getSIProviderIds()) {
                String attrValue;
                ProfileOptions.ProviderOptions ppo = new ProfileOptions.ProviderOptions();
                ScannerConfigProfile.ScannerInfoProvider configuredProvider = configuredProfile.getScannerInfoProviderElement(providerId);
                ppo.providerOutputParserEnabled = true;
                ppo.providerKind = configuredProvider.getProviderKind();
                if (ppo.providerKind.equals("run")) {
                    ppo.providerRunUseDefault = true;
                    attrValue = configuredProvider.getAction().getAttribute(ScannerConfigInfoFactory2.COMMAND);
                    ppo.providerRunCommand = attrValue != null ? attrValue : EMPTY_STRING;
                    attrValue = configuredProvider.getAction().getAttribute(ScannerConfigInfoFactory2.ARGUMENTS);
                    ppo.providerRunArguments = attrValue != null ? attrValue : EMPTY_STRING;
                } else if (ppo.providerKind.equals("open")) {
                    attrValue = configuredProvider.getAction().getAttribute("file");
                    ppo.providerOpenFilePath = attrValue != null ? attrValue : EMPTY_STRING;
                }
                po.providerOptionsMap.put(providerId, ppo);
            }
            defaultProfiles.put(profileId, po);
            return po.clone();
        }

        static class ProfileOptions
        implements Cloneable {
            protected boolean buildOutputFileActionEnabled;
            protected String buildOutputFilePath = "";
            protected boolean buildOutputParserEnabled;
            protected Map<String, ProviderOptions> providerOptionsMap;

            ProfileOptions() {
            }

            ProfileOptions(ProfileOptions base) {
                this.buildOutputFileActionEnabled = base.buildOutputFileActionEnabled;
                this.buildOutputFilePath = base.buildOutputFilePath;
                this.buildOutputParserEnabled = base.buildOutputParserEnabled;
                this.providerOptionsMap = new LinkedHashMap<String, ProviderOptions>(base.providerOptionsMap);
                for (Map.Entry<String, ProviderOptions> entry : this.providerOptionsMap.entrySet()) {
                    ProviderOptions basePo = entry.getValue();
                    entry.setValue(new ProviderOptions(basePo));
                }
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.buildOutputFileActionEnabled ? 1231 : 1237);
                result = 31 * result + (this.buildOutputFilePath == null ? 0 : this.buildOutputFilePath.hashCode());
                result = 31 * result + (this.buildOutputParserEnabled ? 1231 : 1237);
                result = 31 * result + (this.providerOptionsMap == null ? 0 : this.providerOptionsMap.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ProfileOptions other = (ProfileOptions)obj;
                if (this.buildOutputFileActionEnabled != other.buildOutputFileActionEnabled) {
                    return false;
                }
                if (this.buildOutputFilePath == null ? other.buildOutputFilePath != null : !this.buildOutputFilePath.equals(other.buildOutputFilePath)) {
                    return false;
                }
                if (this.buildOutputParserEnabled != other.buildOutputParserEnabled) {
                    return false;
                }
                return !(this.providerOptionsMap == null ? other.providerOptionsMap != null : !this.providerOptionsMap.equals(other.providerOptionsMap));
            }

            public ProfileOptions clone() {
                try {
                    ProfileOptions newProfOpts = (ProfileOptions)super.clone();
                    if (this.providerOptionsMap != null) {
                        newProfOpts.providerOptionsMap = new LinkedHashMap<String, ProviderOptions>();
                        for (Map.Entry<String, ProviderOptions> e : this.providerOptionsMap.entrySet()) {
                            newProfOpts.providerOptionsMap.put(e.getKey(), e.getValue().clone());
                        }
                    }
                    return newProfOpts;
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }

            static class ProviderOptions
            implements Cloneable {
                protected String providerKind;
                protected boolean providerOutputParserEnabled;
                protected boolean providerRunUseDefault;
                protected String providerRunCommand = "";
                protected String providerRunArguments = "";
                protected String providerOpenFilePath = "";

                ProviderOptions() {
                }

                ProviderOptions(ProviderOptions base) {
                    this.providerKind = base.providerKind;
                    this.providerOutputParserEnabled = base.providerOutputParserEnabled;
                    this.providerRunUseDefault = base.providerRunUseDefault;
                    this.providerRunCommand = base.providerRunCommand;
                    this.providerRunArguments = base.providerRunArguments;
                    this.providerOpenFilePath = base.providerOpenFilePath;
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.providerKind == null ? 0 : this.providerKind.hashCode());
                    result = 31 * result + (this.providerOpenFilePath == null ? 0 : this.providerOpenFilePath.hashCode());
                    result = 31 * result + (this.providerOutputParserEnabled ? 1231 : 1237);
                    result = 31 * result + (this.providerRunArguments == null ? 0 : this.providerRunArguments.hashCode());
                    result = 31 * result + (this.providerRunCommand == null ? 0 : this.providerRunCommand.hashCode());
                    result = 31 * result + (this.providerRunUseDefault ? 1231 : 1237);
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    ProviderOptions other = (ProviderOptions)obj;
                    if (this.providerKind == null ? other.providerKind != null : !this.providerKind.equals(other.providerKind)) {
                        return false;
                    }
                    if (this.providerOpenFilePath == null ? other.providerOpenFilePath != null : !this.providerOpenFilePath.equals(other.providerOpenFilePath)) {
                        return false;
                    }
                    if (this.providerOutputParserEnabled != other.providerOutputParserEnabled) {
                        return false;
                    }
                    if (this.providerRunArguments == null ? other.providerRunArguments != null : !this.providerRunArguments.equals(other.providerRunArguments)) {
                        return false;
                    }
                    if (this.providerRunCommand == null ? other.providerRunCommand != null : !this.providerRunCommand.equals(other.providerRunCommand)) {
                        return false;
                    }
                    return this.providerRunUseDefault == other.providerRunUseDefault;
                }

                protected ProviderOptions clone() throws CloneNotSupportedException {
                    return (ProviderOptions)super.clone();
                }
            }
        }
    }

    private static abstract class StoreSet
    implements IScannerConfigBuilderInfo2Set {
        protected HashMap<InfoContext, IScannerConfigBuilderInfo2> fMap = new HashMap();
        protected boolean fIsDirty;

        StoreSet() {
        }

        @Override
        public IScannerConfigBuilderInfo2 createInfo(InfoContext context, IScannerConfigBuilderInfo2 base, String profileId) {
            this.fIsDirty = true;
            Store store = this.doCreateStore(context, (Store)base, profileId);
            this.fMap.put(context, store);
            return store;
        }

        protected abstract Store doCreateStore(InfoContext var1, Store var2, String var3);

        @Override
        public IScannerConfigBuilderInfo2 createInfo(InfoContext context, IScannerConfigBuilderInfo2 base) {
            this.fIsDirty = true;
            return this.createInfo(context, base, "");
        }

        @Override
        public InfoContext[] getContexts() {
            return this.fMap.keySet().toArray(new InfoContext[this.fMap.size()]);
        }

        @Override
        public IScannerConfigBuilderInfo2 getInfo(InfoContext context) {
            return this.fMap.get(context);
        }

        @Override
        public Map<InfoContext, IScannerConfigBuilderInfo2> getInfoMap() {
            return Collections.unmodifiableMap(this.fMap);
        }

        @Override
        public IScannerConfigBuilderInfo2 removeInfo(InfoContext context) throws CoreException {
            this.checkRemoveInfo(context);
            this.fIsDirty = true;
            return this.fMap.remove(context);
        }

        private void checkRemoveInfo(InfoContext context) throws CoreException {
            if (context.isDefaultContext()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.make.core", MakeConfigurationDataProviderMessages.getString("ScannerConfigInfoFactory2.0")));
            }
        }

        public boolean isDirty() {
            if (this.fIsDirty) {
                return true;
            }
            for (IScannerConfigBuilderInfo2 prop : this.fMap.values()) {
                if (!((Store)prop).isDirty) continue;
                return true;
            }
            return false;
        }

        @Override
        public IScannerConfigBuilderInfo2 createInfo(InfoContext context) {
            this.fIsDirty = true;
            return this.createInfo(context, "");
        }

        @Override
        public IScannerConfigBuilderInfo2 createInfo(InfoContext context, String profileId) {
            this.fIsDirty = true;
            IScannerConfigBuilderInfo2 base = this.getInfo(new InfoContext(this.getProject()));
            return this.createInfo(context, base, profileId);
        }
    }
}

