/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.tree.TreeEditPart;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.draw2d.IRootFigure;
import org.eclipse.wb.internal.gef.core.AbstractEditPartViewer;
import org.eclipse.wb.internal.gef.core.EditDomain;
import org.eclipse.wb.internal.gef.tree.RootEditPart;
import org.eclipse.wb.internal.gef.tree.TreeEventManager;

public class TreeViewer
extends AbstractEditPartViewer {
    private final Tree m_tree;
    private final RootEditPart m_rootEditPart;
    private final TreeEventManager m_eventManager;

    public TreeViewer(Composite parent, int style) {
        this(new Tree(parent, style));
    }

    public TreeViewer(Tree tree) {
        this.m_tree = tree;
        this.m_eventManager = new TreeEventManager(this.m_tree, this);
        this.m_rootEditPart = new RootEditPart(this);
        this.m_rootEditPart.activate();
        this.setRootEditPart(this.m_rootEditPart);
        this.synchronizeSelection();
    }

    public Tree getTree() {
        return this.m_tree;
    }

    @Override
    public Control getControl() {
        return this.m_tree;
    }

    @Override
    public int getHOffset() {
        return 0;
    }

    @Override
    public int getVOffset() {
        return 0;
    }

    @Override
    public EditPart getRootEditPart() {
        return this.m_rootEditPart;
    }

    @Override
    public IRootFigure getRootFigure() {
        return null;
    }

    @Override
    public Layer getLayer(String name) {
        return null;
    }

    @Override
    public void setEditDomain(EditDomain domain) {
        super.setEditDomain(domain);
        this.m_eventManager.setDomain(domain);
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.m_tree.setCursor(cursor);
    }

    public void collapseAll() {
        UiUtils.collapseAll(this.m_tree);
    }

    public void expandAll() {
        UiUtils.expandAll(this.m_tree);
    }

    private void synchronizeSelection() {
        final boolean[] inTreeSelectionListener = new boolean[1];
        this.m_tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = TreeViewer.this.m_tree.getSelection();
                Object[] selection = new EditPart[items.length];
                int i = 0;
                while (i < selection.length) {
                    selection[i] = (EditPart)items[i].getData();
                    ++i;
                }
                try {
                    inTreeSelectionListener[0] = true;
                    TreeViewer.this.setSelection((ISelection)new StructuredSelection(selection));
                }
                finally {
                    inTreeSelectionListener[0] = false;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!inTreeSelectionListener[0]) {
                    TreeViewer.this.setSelectionToTreeWidget();
                }
            }
        });
    }

    public void setSelectionToTreeWidget() {
        ArrayList treeItems = Lists.newArrayList();
        for (EditPart editPart : this.getSelectedEditParts()) {
            TreeEditPart treeEditPart = (TreeEditPart)editPart;
            treeItems.add(treeEditPart.getWidget());
        }
        this.m_tree.setSelection(treeItems.toArray(new TreeItem[treeItems.size()]));
    }

    @Override
    public EditPart findTargetEditPart(int x, int y, Collection<EditPart> exclude, IEditPartViewer.IConditional conditional) {
        Rectangle clientArea = this.m_tree.getClientArea();
        if (x < 0 || y < 0 || x > clientArea.width || y > clientArea.height) {
            return null;
        }
        EditPart result = null;
        TreeItem item = this.m_tree.getItem(new org.eclipse.swt.graphics.Point(x, y));
        result = item == null ? this.m_rootEditPart : (EditPart)item.getData();
        while (result != null) {
            if (!exclude.contains(result) && (conditional == null || conditional.evaluate(result))) {
                return result;
            }
            result = result.getParent();
        }
        return null;
    }

    @Override
    public EditPart findTargetEditPart(int x, int y, Collection<EditPart> exclude, IEditPartViewer.IConditional conditional, String layer) {
        return null;
    }

    @Override
    public Handle findTargetHandle(Point location) {
        return null;
    }

    @Override
    public Handle findTargetHandle(int x, int y) {
        return null;
    }
}

