/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors.report2;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.wb.internal.core.editor.errors.report2.IReportEntry;

public abstract class FileListReportEntry
implements IReportEntry {
    protected abstract List<File> getFiles();

    protected abstract String getPrefix();

    @Override
    public void write(ZipOutputStream zipStream) throws Exception {
        List<File> files = this.getFiles();
        for (File file : files) {
            FileInputStream fileStream = new FileInputStream(file);
            String filePath = String.valueOf(this.getPrefix()) + FilenameUtils.getName((String)file.getAbsolutePath());
            zipStream.putNextEntry(new ZipEntry(filePath));
            try {
                IOUtils.copy((InputStream)fileStream, (OutputStream)zipStream);
            }
            finally {
                zipStream.closeEntry();
                IOUtils.closeQuietly((InputStream)fileStream);
            }
        }
    }
}

