/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.synchronizer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.sirius.synchronizer.Mapping;
import org.eclipse.sirius.synchronizer.MappingHiearchy;

public class MappingHiearchyTable {
    private Multimap<Mapping, MappingHiearchy> hiearchies = HashMultimap.create();

    public Collection<MappingHiearchy> getHierarchy(Mapping from) {
        return this.hiearchies.get((Object)from);
    }

    public void compute(Collection<? extends Mapping> mappings) {
        Collection<? extends Mapping> leaves = this.getLeaves(mappings);
        for (Mapping mapping : leaves) {
            MappingHiearchy newHierarchy = new MappingHiearchy(mapping);
            this.hiearchies.put((Object)mapping, (Object)newHierarchy);
            Iterator<Mapping> it = newHierarchy.fromMostSpecificToMostGeneral();
            while (it.hasNext()) {
                Mapping superMapping = it.next();
                this.hiearchies.put((Object)superMapping, (Object)newHierarchy);
            }
        }
    }

    private Collection<? extends Mapping> getLeaves(Collection<? extends Mapping> mappings) {
        LinkedHashSet<Mapping> hasChildren = new LinkedHashSet<Mapping>();
        for (Mapping mapping : mappings) {
            if (!mapping.getSuper().some()) continue;
            hasChildren.add((Mapping)mapping.getSuper().get());
        }
        return Sets.difference((Set)Sets.newLinkedHashSet(mappings), hasChildren);
    }
}

