/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.ui.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.onefile.internal.ui.Activator;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.model.PapyrusModelHelper;
import org.eclipse.papyrus.infra.onefile.utils.OneFileUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.navigator.CommonViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusContentProvider
extends WorkbenchContentProvider {
    private CommonViewer common;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (viewer instanceof CommonViewer) {
            this.common = (CommonViewer)viewer;
        }
    }

    public boolean isFiltered() {
        return this.common != null && this.common.getNavigatorContentService() != null && this.common.getNavigatorContentService().getFilterService() != null && this.common.getNavigatorContentService().getFilterService().isActive("org.eclipse.papyrus.infra.onefile.onlyDiFilter");
    }

    public void dispose() {
        super.dispose();
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            return null;
        }
        LinkedList<Object> result = new LinkedList<Object>();
        try {
            if (this.isFiltered()) {
                if (inputElement instanceof IPapyrusFile) {
                    IPapyrusFile file = (IPapyrusFile)inputElement;
                    IResource[] iResourceArray = file.getAssociatedResources();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource r = iResourceArray[n2];
                        result.add(PapyrusModelHelper.getPapyrusModelFactory().createISubResourceFile(file, (IFile)r));
                        ++n2;
                    }
                } else {
                    IResource[] members = null;
                    IContainer container = null;
                    if (inputElement instanceof IContainer) {
                        container = (IContainer)inputElement;
                    } else if (inputElement instanceof IAdaptable) {
                        container = (IContainer)((IAdaptable)inputElement).getAdapter(IContainer.class);
                    }
                    if (container != null && container.isAccessible()) {
                        members = container.members();
                    }
                    if (members != null) {
                        IResource[] iResourceArray = members;
                        int n = members.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IResource r = iResourceArray[n3];
                            if (r instanceof IFile && OneFileUtils.isDi((IResource)r)) {
                                IPapyrusFile createIPapyrusFile = PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile((IFile)r);
                                result.add(createIPapyrusFile);
                            }
                            ++n3;
                        }
                    }
                }
            }
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return result.isEmpty() ? null : result.toArray();
    }

    public Object[] getChildren(Object inputElement) {
        return this.getElements(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof IPapyrusFile) {
            IPapyrusFile papyFile = (IPapyrusFile)element;
            return papyFile.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return OneFileUtils.hasChildren((Object)element);
    }

    protected void processDelta(IResourceDelta delta) {
        super.processDelta(delta);
        if (!this.isFiltered()) {
            return;
        }
        Control ctrl = this.common.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        final ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        this.processPapyrusDelta(delta, runnables);
        if (runnables.isEmpty()) {
            return;
        }
        ctrl.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Control ctrl = PapyrusContentProvider.this.common.getControl();
                if (ctrl == null || ctrl.isDisposed()) {
                    return;
                }
                PapyrusContentProvider.this.runUpdates(runnables);
            }
        });
    }

    private void runUpdates(Collection<?> runnables) {
        Iterator<?> runnableIterator = runnables.iterator();
        while (runnableIterator.hasNext()) {
            ((Runnable)runnableIterator.next()).run();
        }
    }

    protected void processPapyrusDelta(IResourceDelta delta, Collection<Runnable> runnables) {
        int i;
        Object[] addedObjects;
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        int i2 = 0;
        while (i2 < affectedChildren.length) {
            this.processPapyrusDelta(affectedChildren[i2], runnables);
            ++i2;
        }
        IResourceDelta[] addedChildren = delta.getAffectedChildren(1);
        IResourceDelta[] removedChildren = delta.getAffectedChildren(2);
        if (addedChildren.length > 0) {
            addedObjects = new Object[addedChildren.length];
            i = 0;
            while (i < addedChildren.length) {
                addedObjects[i] = addedChildren[i].getResource();
                ++i;
            }
        } else {
            addedObjects = new Object[]{};
        }
        final Object[] removedObjects = new Object[removedChildren.length];
        i = 0;
        IResourceDelta[] iResourceDeltaArray = removedChildren;
        int n = removedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta removeDelta = iResourceDeltaArray[n2];
            removedObjects[i++] = removeDelta.getResource();
            ++n2;
        }
        Runnable addAndRemove = new Runnable(){

            public void run() {
                if (PapyrusContentProvider.this.common instanceof AbstractTreeViewer && PapyrusContentProvider.this.common.getControl() != null && !PapyrusContentProvider.this.common.getControl().isDisposed()) {
                    IPapyrusFile oneFile;
                    IResource current;
                    int n;
                    Object[] objectArray;
                    HashSet<Object> toRefresh;
                    if (addedObjects.length > 0) {
                        toRefresh = new HashSet<Object>();
                        HashSet<IPapyrusFile> toAdd = new HashSet<IPapyrusFile>(addedObjects.length);
                        objectArray = addedObjects;
                        n = addedObjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            if (object instanceof IResource) {
                                current = (IResource)object;
                                if (OneFileUtils.diExists((String)current.getName(), (IContainer)current.getParent())) {
                                    oneFile = PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile(OneFileUtils.getDi((String)current.getName(), (IContainer)current.getParent()));
                                    toRefresh.add(oneFile);
                                    toRefresh.add(oneFile.getParent());
                                }
                                if (OneFileUtils.isDi((IResource)current)) {
                                    toAdd.add(PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile((IFile)current));
                                }
                            }
                            ++n2;
                        }
                        for (IPapyrusFile iPapyrusFile : toAdd) {
                            PapyrusContentProvider.this.common.add((Object)iPapyrusFile.getParent(), (Object)iPapyrusFile);
                        }
                        for (Object e : toRefresh) {
                            PapyrusContentProvider.this.common.refresh(e);
                        }
                    }
                    if (removedObjects.length > 0) {
                        toRefresh = new HashSet();
                        HashSet<Object> toRemove = new HashSet<Object>();
                        objectArray = removedObjects;
                        n = removedObjects.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Object object = objectArray[n3];
                            if (object instanceof IFile) {
                                current = (IFile)object;
                                if (OneFileUtils.isDi((IResource)current)) {
                                    toRemove.add(PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile((IFile)current));
                                    toRefresh.add(current.getParent());
                                } else if (OneFileUtils.diExists((String)current.getName(), (IContainer)current.getParent())) {
                                    oneFile = PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile(OneFileUtils.getDi((String)current.getName(), (IContainer)current.getParent()));
                                    toRefresh.add(oneFile);
                                    toRemove.add(PapyrusModelHelper.getPapyrusModelFactory().createISubResourceFile(oneFile, (IFile)current));
                                }
                            }
                            ++n3;
                        }
                        PapyrusContentProvider.this.common.remove(toRemove.toArray());
                        for (Object e : toRefresh) {
                            PapyrusContentProvider.this.common.refresh(e);
                        }
                    }
                }
            }
        };
        runnables.add(addAndRemove);
    }
}

