/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal.eclipsecopy;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IMultiPageEditorPart;
import org.eclipse.ui.IEditorPart;

public class MultiPageSelectionProvider
implements IPostSelectionProvider {
    private ListenerList listeners = new ListenerList();
    private ListenerList postListeners = new ListenerList();
    private IMultiPageEditorPart multiPageEditor;

    public MultiPageSelectionProvider(IMultiPageEditorPart multiPageEditor) {
        Assert.isNotNull((Object)multiPageEditor);
        this.multiPageEditor = multiPageEditor;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.add((Object)listener);
    }

    public void fireSelectionChanged(SelectionChangedEvent event) {
        Object[] listeners = this.listeners.getListeners();
        this.fireEventChange(event, listeners);
    }

    public void firePostSelectionChanged(SelectionChangedEvent event) {
        Object[] listeners = this.postListeners.getListeners();
        this.fireEventChange(event, listeners);
    }

    private void fireEventChange(final SelectionChangedEvent event, Object[] listeners) {
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public ISelection getSelection() {
        ISelectionProvider selectionProvider;
        IEditorPart activeEditor = this.multiPageEditor.getActiveEditor();
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        ISelectionProvider selectionProvider;
        IEditorPart activeEditor = this.multiPageEditor.getActiveEditor();
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider.setSelection(selection);
        }
    }
}

