/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.monitor.ui.AbstractUserInteractionMonitor;
import org.eclipse.ui.IWorkbenchPart;

public class JavaEditingMonitor
extends AbstractUserInteractionMonitor {
    protected IJavaElement lastSelectedElement = null;
    protected IJavaElement lastResolvedElement = null;
    protected JavaEditor currentEditor;
    protected StructuredSelection currentSelection = null;

    public void handleWorkbenchPartSelection(IWorkbenchPart part, ISelection selection, boolean contributeToContext) {
        try {
            IJavaElement selectedElement = null;
            if (selection instanceof StructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                if (structuredSelection.equals((Object)this.currentSelection)) {
                    return;
                }
                this.currentSelection = structuredSelection;
                for (Object selectedObject : structuredSelection) {
                    if (selectedObject instanceof IJavaElement) {
                        IJavaElement checkedElement = this.checkIfAcceptedAndPromoteIfNecessary((IJavaElement)selectedObject);
                        if (checkedElement == null) {
                            return;
                        }
                        selectedElement = checkedElement;
                    }
                    if (selectedElement == null) continue;
                    super.handleElementSelection(part, (Object)selectedElement, contributeToContext);
                }
            } else if (selection instanceof TextSelection && part instanceof JavaEditor) {
                IJavaElement checkedElement;
                this.currentEditor = (JavaEditor)part;
                TextSelection textSelection = (TextSelection)selection;
                selectedElement = SelectionConverter.resolveEnclosingElement((JavaEditor)this.currentEditor, (ITextSelection)textSelection);
                if (selectedElement instanceof IPackageDeclaration) {
                    return;
                }
                IJavaElement[] resolved = SelectionConverter.codeResolve((JavaEditor)this.currentEditor);
                if (resolved != null && resolved.length == 1 && !resolved[0].equals(selectedElement)) {
                    this.lastResolvedElement = resolved[0];
                }
                boolean selectionResolved = false;
                if (selectedElement instanceof IMethod && this.lastSelectedElement instanceof IMethod) {
                    if (this.lastResolvedElement != null && this.lastSelectedElement != null && this.lastResolvedElement.equals(selectedElement) && !this.lastSelectedElement.equals(this.lastResolvedElement)) {
                        super.handleNavigation(part, (Object)selectedElement, "org.eclipse.mylyn.java.relation.references", contributeToContext);
                        selectionResolved = true;
                    } else if (this.lastSelectedElement != null && this.lastSelectedElement.equals(this.lastResolvedElement) && !this.lastSelectedElement.equals(selectedElement)) {
                        super.handleNavigation(part, (Object)selectedElement, "org.eclipse.mylyn.java.relation.references", contributeToContext);
                        selectionResolved = true;
                    }
                } else if (selectedElement != null && this.lastSelectedElement != null && !this.lastSelectedElement.equals(selectedElement) && this.lastSelectedElement.getElementName().equals(selectedElement.getElementName())) {
                    if (selectedElement instanceof IMethod && this.lastSelectedElement instanceof IMethod) {
                        super.handleNavigation(part, (Object)selectedElement, "org.eclipse.mylyn.java.relation.implementors", contributeToContext);
                        selectionResolved = true;
                    } else if (selectedElement instanceof IType && this.lastSelectedElement instanceof IType) {
                        super.handleNavigation(part, (Object)selectedElement, "org.eclipse.mylyn.java.relation.implementors", contributeToContext);
                        selectionResolved = true;
                    }
                }
                if (selectedElement != null) {
                    if (!selectionResolved && selectedElement.equals(this.lastSelectedElement)) {
                        super.handleElementEdit(part, (Object)selectedElement, contributeToContext);
                    } else if (!selectedElement.equals(this.lastSelectedElement)) {
                        super.handleElementSelection(part, (Object)selectedElement, contributeToContext);
                    }
                }
                if ((checkedElement = this.checkIfAcceptedAndPromoteIfNecessary(selectedElement)) == null) {
                    return;
                }
                selectedElement = checkedElement;
            }
            if (selectedElement != null) {
                this.lastSelectedElement = selectedElement;
            }
        }
        catch (JavaModelException selectedElement) {
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Failed to update model based on selection", t));
        }
    }

    protected IJavaElement checkIfAcceptedAndPromoteIfNecessary(IJavaElement element) {
        if (element instanceof IImportContainer) {
            return element.getParent();
        }
        if (element instanceof IImportDeclaration) {
            return element.getParent().getParent();
        }
        return element;
    }

    public void resetLastSelectedElement() {
        this.lastSelectedElement = null;
    }
}

