/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.utils.IExecutableOperation;
import org.eclipse.dltk.utils.IExecutionContextManager;

public class ExecutionContexts {
    private static IExecutionContextManager fManager;
    private static IExecutionContextManager fDefaultManager;

    static {
        fDefaultManager = new IExecutionContextManager(){

            @Override
            public void executeInBackground(IExecutableOperation operation) {
                operation.execute((IProgressMonitor)new NullProgressMonitor());
            }

            @Override
            public boolean isRunningInUIThread() {
                return false;
            }
        };
    }

    public static IExecutionContextManager getManager() {
        if (fManager != null) {
            return fManager;
        }
        return fDefaultManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setManager(IExecutionContextManager manager) {
        IExecutionContextManager iExecutionContextManager = fDefaultManager;
        synchronized (iExecutionContextManager) {
            fManager = manager;
        }
    }
}

