/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.util;

public class MementoTokenizer {
    private static final String COUNT = Character.toString('!');
    private static final String SCRIPTPROJECT = Character.toString('=');
    private static final String PROJECTFRAGMENT = Character.toString('/');
    private static final String SCRIPTFOLDER = Character.toString('<');
    private static final String FIELD = Character.toString('^');
    private static final String METHOD = Character.toString('~');
    private static final String SOURCEMODULE = Character.toString('{');
    private static final String TYPE = Character.toString('[');
    private static final String IMPORTDECLARATION = Character.toString('&');
    private static final String LOCALVARIABLE = Character.toString('@');
    private static final String TYPE_PARAMETER = Character.toString(']');
    private static final String USER_ELEMENT = Character.toString('}');
    private final char[] memento;
    private final int length;
    private int index = 0;

    public MementoTokenizer(String memento) {
        this.memento = memento.toCharArray();
        this.length = this.memento.length;
    }

    public boolean hasMoreTokens() {
        return this.index < this.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String nextToken() {
        int start = this.index;
        StringBuilder buffer = null;
        switch (this.memento[this.index++]) {
            case '\\': {
                buffer = new StringBuilder();
                buffer.append(this.memento[this.index]);
                start = ++this.index;
                break;
            }
            case '!': {
                return COUNT;
            }
            case '=': {
                return SCRIPTPROJECT;
            }
            case '/': {
                return PROJECTFRAGMENT;
            }
            case '<': {
                return SCRIPTFOLDER;
            }
            case '^': {
                return FIELD;
            }
            case '~': {
                return METHOD;
            }
            case '{': {
                return SOURCEMODULE;
            }
            case '[': {
                return TYPE;
            }
            case '&': {
                return IMPORTDECLARATION;
            }
            case '@': {
                return LOCALVARIABLE;
            }
            case ']': {
                return TYPE_PARAMETER;
            }
            case '}': {
                return USER_ELEMENT;
            }
        }
        block19: while (this.index < this.length) {
            switch (this.memento[this.index]) {
                case '\\': {
                    if (buffer == null) {
                        buffer = new StringBuilder();
                    }
                    buffer.append(this.memento, start, this.index - start);
                    start = ++this.index;
                    break;
                }
                case '!': 
                case '&': 
                case '/': 
                case '<': 
                case '=': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '}': 
                case '~': {
                    break block19;
                }
            }
            ++this.index;
        }
        if (buffer != null) {
            buffer.append(this.memento, start, this.index - start);
            return buffer.toString();
        }
        return new String(this.memento, start, this.index - start);
    }
}

