/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemLocationFactory;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.core.resources.IResource;

public class CopyrightChecker
extends AbstractIndexAstChecker {
    public static final String ERR_ID = "org.eclipse.cdt.codan.internal.checkers.CopyrightProblem";
    public static final String PARAM_REGEX = "regex";
    private static final String DEF_REGEX = ".*Copyright.*";
    private Pattern fPattern;
    private StringBuilder builder = new StringBuilder();
    private int lastOffset;
    private boolean multiLine = false;

    public boolean runInEditor() {
        return false;
    }

    public void processAst(IASTTranslationUnit ast) {
        this.multiLine = false;
        this.lastOffset = 0;
        this.builder.setLength(0);
        String regex = this.getRegex();
        if (regex == null || regex.isEmpty()) {
            regex = DEF_REGEX;
        }
        try {
            this.fPattern = Pattern.compile(regex, 40);
        }
        catch (PatternSyntaxException e) {
            CodanCheckersActivator.log(e);
            return;
        }
        IASTComment[] comments = ast.getComments();
        if (comments == null) {
            this.setProblem();
            return;
        }
        Result found = Result.NOT_FOUND;
        IASTComment[] iASTCommentArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            IASTComment comment = iASTCommentArray[n2];
            found = this.processComment(comment);
            if (found == Result.FOUND || found == Result.FOUND_MATCH) break;
            ++n2;
        }
        if (found == Result.NOT_FOUND && this.multiLine) {
            String c = this.builder.toString();
            if (!this.fPattern.matcher(c).matches()) {
                this.setProblem();
            }
        } else if (found != Result.FOUND_MATCH) {
            this.setProblem();
        }
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_REGEX, CheckersMessages.Copyright_regex, DEF_REGEX);
    }

    public String getRegex() {
        IProblem pt = this.getProblemById(ERR_ID, (IResource)this.getFile());
        return (String)this.getPreference(pt, PARAM_REGEX);
    }

    protected Result processComment(IASTComment comment) {
        if (comment.isPartOfTranslationUnitFile()) {
            IASTFileLocation nodeLocation = comment.getFileLocation();
            if (nodeLocation == null) {
                return Result.NOT_FOUND;
            }
            String c = comment.getRawSignature();
            int currentOffset = nodeLocation.getNodeOffset();
            if (!comment.isBlockComment() && c.startsWith("//") && (currentOffset == this.lastOffset + 1 || !this.multiLine && currentOffset == 0)) {
                this.builder.append(c);
                this.builder.append("\n");
                this.lastOffset = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                this.multiLine = true;
                return Result.NOT_FOUND;
            }
            if (this.multiLine) {
                c = this.builder.toString();
            } else if (nodeLocation.getNodeOffset() != 0) {
                return Result.NOT_FOUND;
            }
            if (this.fPattern.matcher(c).matches()) {
                return Result.FOUND_MATCH;
            }
            return Result.FOUND;
        }
        return Result.NOT_FOUND;
    }

    private void setProblem() {
        IProblemLocationFactory locFactory = this.getRuntime().getProblemLocationFactory();
        IProblemLocation p = locFactory.createProblemLocation(this.getFile(), 1);
        this.reportProblem(ERR_ID, p, new Object[0]);
    }

    private static enum Result {
        NOT_FOUND,
        FOUND,
        FOUND_MATCH;

    }
}

