/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.GuardPredicateDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;

public class RoleTypeDeclaration
extends TypeDeclaration {
    public static final ChildPropertyDescriptor JAVADOC_PROPERTY = RoleTypeDeclaration.internalJavadocPropertyFactory(RoleTypeDeclaration.class);
    public static final SimplePropertyDescriptor MODIFIERS_PROPERTY = RoleTypeDeclaration.internalModifiersPropertyFactory(RoleTypeDeclaration.class);
    public static final ChildListPropertyDescriptor MODIFIERS2_PROPERTY = RoleTypeDeclaration.internalModifiers2PropertyFactory(RoleTypeDeclaration.class);
    public static final SimplePropertyDescriptor INTERFACE_PROPERTY = new SimplePropertyDescriptor(RoleTypeDeclaration.class, "interface", Boolean.TYPE, true);
    public static final SimplePropertyDescriptor TEAM_PROPERTY = new SimplePropertyDescriptor(RoleTypeDeclaration.class, "team", Boolean.TYPE, true);
    public static final SimplePropertyDescriptor ROLE_PROPERTY = new SimplePropertyDescriptor(RoleTypeDeclaration.class, "role", Boolean.TYPE, true);
    public static final SimplePropertyDescriptor ROLE_FILE_PROPERTY = new SimplePropertyDescriptor(RoleTypeDeclaration.class, "rolefile", Boolean.TYPE, true);
    public static final ChildPropertyDescriptor BASECLASS_PROPERTY = new ChildPropertyDescriptor(RoleTypeDeclaration.class, "baseClass", Name.class, false, false);
    public static final ChildPropertyDescriptor BASECLASS_TYPE_PROPERTY = new ChildPropertyDescriptor(RoleTypeDeclaration.class, "baseClassType", Type.class, false, false);
    public static final ChildPropertyDescriptor TEAMCLASS_PROPERTY = new ChildPropertyDescriptor(RoleTypeDeclaration.class, "teamClass", Name.class, false, false);
    public static final ChildPropertyDescriptor TEAMCLASS_TYPE_PROPERTY = new ChildPropertyDescriptor(RoleTypeDeclaration.class, "teamClassType", Type.class, false, false);
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(RoleTypeDeclaration.class, "name", SimpleName.class, true, false);
    public static final ChildPropertyDescriptor SUPERCLASS_PROPERTY = new ChildPropertyDescriptor(RoleTypeDeclaration.class, "superclass", Name.class, false, false);
    public static final ChildListPropertyDescriptor SUPER_INTERFACES_PROPERTY = new ChildListPropertyDescriptor(RoleTypeDeclaration.class, "superInterfaces", Name.class, false);
    public static final ChildPropertyDescriptor SUPERCLASS_TYPE_PROPERTY = new ChildPropertyDescriptor(RoleTypeDeclaration.class, "superclassType", Type.class, false, false);
    public static final ChildListPropertyDescriptor SUPER_INTERFACE_TYPES_PROPERTY = new ChildListPropertyDescriptor(RoleTypeDeclaration.class, "superInterfaceTypes", Type.class, false);
    public static final ChildListPropertyDescriptor TYPE_PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(RoleTypeDeclaration.class, "typeParameters", TypeParameter.class, false);
    public static final ChildPropertyDescriptor GUARD_PROPERTY = new ChildPropertyDescriptor(RoleTypeDeclaration.class, "guardPredicate", GuardPredicateDeclaration.class, false, false);
    public static final ChildListPropertyDescriptor BODY_DECLARATIONS_PROPERTY = RoleTypeDeclaration.internalBodyDeclarationPropertyFactory(RoleTypeDeclaration.class);
    public static final ChildListPropertyDescriptor PRECEDENCE_PROPERTY = new ChildListPropertyDescriptor(RoleTypeDeclaration.class, "precedence", Name.class, false);
    private static final List PROPERTY_DESCRIPTORS_2_0;
    private static final List PROPERTY_DESCRIPTORS_3_0;
    private Name optionalBaseClassName = null;
    private Type optionalBaseClassType = null;
    private Name teamClassName = null;
    private Type teamClassType = null;
    private boolean isRoleFile = false;

    static {
        ArrayList propertyList = new ArrayList(14);
        RoleTypeDeclaration.createPropertyList(RoleTypeDeclaration.class, propertyList);
        RoleTypeDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(MODIFIERS_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(INTERFACE_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(TEAM_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(ROLE_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(BASECLASS_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(TEAMCLASS_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(NAME_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(SUPERCLASS_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(SUPER_INTERFACES_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(GUARD_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(BODY_DECLARATIONS_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(PRECEDENCE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_2_0 = RoleTypeDeclaration.reapPropertyList(propertyList);
        propertyList = new ArrayList(16);
        RoleTypeDeclaration.createPropertyList(RoleTypeDeclaration.class, propertyList);
        RoleTypeDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(MODIFIERS2_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(INTERFACE_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(TEAM_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(ROLE_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(ROLE_FILE_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(BASECLASS_TYPE_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(TEAMCLASS_TYPE_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(NAME_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(TYPE_PARAMETERS_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(SUPERCLASS_TYPE_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(SUPER_INTERFACE_TYPES_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(GUARD_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(BODY_DECLARATIONS_PROPERTY, propertyList);
        RoleTypeDeclaration.addProperty(PRECEDENCE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_3_0 = RoleTypeDeclaration.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel == 2) {
            return PROPERTY_DESCRIPTORS_2_0;
        }
        return PROPERTY_DESCRIPTORS_3_0;
    }

    RoleTypeDeclaration(AST ast) {
        super(ast);
        if (ast.apiLevel == 2) {
            this.superInterfaceNames = new ASTNode.NodeList(SUPER_INTERFACES_PROPERTY);
        } else {
            this.typeParameters = new ASTNode.NodeList(TYPE_PARAMETERS_PROPERTY);
            this.superInterfaceTypes = new ASTNode.NodeList(SUPER_INTERFACE_TYPES_PROPERTY);
        }
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return RoleTypeDeclaration.propertyDescriptors(apiLevel);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == MODIFIERS_PROPERTY) {
            if (get) {
                return this.getModifiers();
            }
            this.internalSetModifiers(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == INTERFACE_PROPERTY) {
            if (get) {
                return this.isInterface();
            }
            this.setInterface(value);
            return false;
        }
        if (property == TEAM_PROPERTY) {
            if (get) {
                return this.isTeam();
            }
            this.setTeam(value);
            return false;
        }
        if (property == ROLE_PROPERTY) {
            if (get) {
                return this.isRole();
            }
            this.setRole(value);
            return false;
        }
        if (property == ROLE_FILE_PROPERTY) {
            if (get) {
                return this.isRoleFile();
            }
            this.setRoleFile(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == JAVADOC_PROPERTY) {
            if (get) {
                return this.getJavadoc();
            }
            this.setJavadoc((Javadoc)child);
            return null;
        }
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((SimpleName)child);
            return null;
        }
        if (property == SUPERCLASS_PROPERTY) {
            if (get) {
                return this.getSuperclass();
            }
            this.setSuperclass((Name)child);
            return null;
        }
        if (property == SUPERCLASS_TYPE_PROPERTY) {
            if (get) {
                return this.getSuperclassType();
            }
            this.setSuperclassType((Type)child);
            return null;
        }
        if (property == BASECLASS_PROPERTY) {
            if (get) {
                return this.getBaseClass();
            }
            this.setBaseClass((Name)child);
            return null;
        }
        if (property == BASECLASS_TYPE_PROPERTY) {
            if (get) {
                return this.getBaseClassType();
            }
            this.setBaseClassType((Type)child);
            return null;
        }
        if (property == TEAMCLASS_PROPERTY) {
            if (get) {
                return this.getTeamClass();
            }
            this.setTeamClass((Name)child);
            return null;
        }
        if (property == TEAMCLASS_TYPE_PROPERTY) {
            if (get) {
                return this.getTeamClassType();
            }
            this.setTeamClassType((Type)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == MODIFIERS2_PROPERTY) {
            return this.modifiers();
        }
        if (property == TYPE_PARAMETERS_PROPERTY) {
            return this.typeParameters();
        }
        if (property == SUPER_INTERFACES_PROPERTY) {
            return this.internalSuperInterfaces();
        }
        if (property == SUPER_INTERFACE_TYPES_PROPERTY) {
            return this.superInterfaceTypes();
        }
        if (property == BODY_DECLARATIONS_PROPERTY) {
            return this.bodyDeclarations();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ChildPropertyDescriptor internalJavadocProperty() {
        return JAVADOC_PROPERTY;
    }

    @Override
    final ChildListPropertyDescriptor internalModifiers2Property() {
        return MODIFIERS2_PROPERTY;
    }

    @Override
    final SimplePropertyDescriptor internalModifiersProperty() {
        return MODIFIERS_PROPERTY;
    }

    @Override
    final ChildPropertyDescriptor internalNameProperty() {
        return NAME_PROPERTY;
    }

    @Override
    final ChildListPropertyDescriptor internalBodyDeclarationsProperty() {
        return BODY_DECLARATIONS_PROPERTY;
    }

    @Override
    ChildPropertyDescriptor internalGuardPredicateProperty() {
        return GUARD_PROPERTY;
    }

    @Override
    ChildListPropertyDescriptor internalPrecedenceProperty() {
        return PRECEDENCE_PROPERTY;
    }

    @Override
    final int getNodeType0() {
        return 113;
    }

    @Override
    ASTNode clone0(AST target) {
        RoleTypeDeclaration result = new RoleTypeDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setJavadoc((Javadoc)ASTNode.copySubtree(target, this.getJavadoc()));
        if (this.ast.apiLevel == 2) {
            result.internalSetModifiers(this.getModifiers());
            result.internalSetSuperclass((Name)ASTNode.copySubtree(target, this.internalGetSuperclass()));
            result.internalSuperInterfaces().addAll(ASTNode.copySubtrees(target, this.internalSuperInterfaces()));
            result.setBaseClass((Name)ASTNode.copySubtree(target, this.getBaseClass()));
            result.setTeamClass((Name)ASTNode.copySubtree(target, this.getTeamClass()));
        }
        result.setTeam(this.isTeam());
        result.setRole(this.isRole());
        result.setRoleFile(this.isRoleFile());
        result.setName((SimpleName)this.getName().clone(target));
        if (this.ast.apiLevel >= 3) {
            result.modifiers().addAll(ASTNode.copySubtrees(target, this.modifiers()));
            result.typeParameters().addAll(ASTNode.copySubtrees(target, this.typeParameters()));
            result.setSuperclassType((Type)ASTNode.copySubtree(target, this.getSuperclassType()));
            result.superInterfaceTypes().addAll(ASTNode.copySubtrees(target, this.superInterfaceTypes()));
            result.setBaseClassType((Type)ASTNode.copySubtree(target, this.getBaseClassType()));
            result.setTeamClassType((Type)ASTNode.copySubtree(target, this.getTeamClassType()));
        }
        result.setGuardPredicate((GuardPredicateDeclaration)ASTNode.copySubtree(target, this.getGuardPredicate()));
        result.bodyDeclarations().addAll(ASTNode.copySubtrees(target, this.bodyDeclarations()));
        result.precedences().addAll(ASTNode.copySubtrees(target, this.precedences()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.ast.apiLevel == 2) {
                this.acceptChild(visitor, this.getJavadoc());
                this.acceptChild(visitor, this.getName());
                this.acceptChild(visitor, this.getSuperclass());
                this.acceptChild(visitor, this.getBaseClass());
                this.acceptChildren(visitor, this.superInterfaceNames);
                this.acceptChildren(visitor, this.bodyDeclarations);
            } else {
                this.acceptChild(visitor, this.getJavadoc());
                this.acceptChildren(visitor, this.modifiers);
                this.acceptChild(visitor, this.getName());
                this.acceptChildren(visitor, this.typeParameters);
                this.acceptChild(visitor, this.getSuperclassType());
                this.acceptChild(visitor, this.getBaseClassType());
                this.acceptChildren(visitor, this.superInterfaceTypes);
                this.acceptChild(visitor, this.getGuardPredicate());
                this.acceptChildren(visitor, this.bodyDeclarations);
                this.acceptChildren(visitor, this._precedences);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public void setTeam(boolean isTeam) {
        this.preValueChange(TEAM_PROPERTY);
        this._isTeam = isTeam;
        this.postValueChange(TEAM_PROPERTY);
    }

    @Override
    public void setRole(boolean isRole) {
        this.preValueChange(ROLE_PROPERTY);
        this.isRole = isRole;
        this.postValueChange(ROLE_PROPERTY);
    }

    public void setRoleFile(boolean isRoleFile) {
        this.preValueChange(ROLE_FILE_PROPERTY);
        this.isRoleFile = isRoleFile;
        this.postValueChange(ROLE_FILE_PROPERTY);
    }

    public boolean isRoleFile() {
        return this.isRoleFile;
    }

    public Name getBaseClass() {
        this.supportedOnlyIn2();
        return this.optionalBaseClassName;
    }

    final Name internalGetBaseClass() {
        this.supportedOnlyIn2();
        return this.optionalBaseClassName;
    }

    public Type getBaseClassType() {
        this.unsupportedIn2();
        return this.optionalBaseClassType;
    }

    public Name getTeamClass() {
        this.supportedOnlyIn2();
        return this.teamClassName;
    }

    final Name internalGetTeamClass() {
        this.supportedOnlyIn2();
        return this.teamClassName;
    }

    public Type getTeamClassType() {
        this.unsupportedIn2();
        return this.teamClassType;
    }

    public void setBaseClass(Name baseClassName) {
        this.internalSetBaseClass(baseClassName);
    }

    final void internalSetBaseClass(Name baseClassName) {
        this.supportedOnlyIn2();
        Name oldChild = this.optionalBaseClassName;
        this.preReplaceChild(oldChild, baseClassName, BASECLASS_PROPERTY);
        this.optionalBaseClassName = baseClassName;
        this.postReplaceChild(oldChild, baseClassName, BASECLASS_PROPERTY);
    }

    public void setBaseClassType(Type baseClassType) {
        this.unsupportedIn2();
        Type oldChild = this.optionalBaseClassType;
        this.preReplaceChild(oldChild, baseClassType, BASECLASS_TYPE_PROPERTY);
        this.optionalBaseClassType = baseClassType;
        this.postReplaceChild(oldChild, baseClassType, BASECLASS_TYPE_PROPERTY);
    }

    public void setTeamClass(Name teamclassName) {
        this.supportedOnlyIn2();
        Name oldChild = this.teamClassName;
        this.preReplaceChild(oldChild, this.teamClassName, TEAMCLASS_PROPERTY);
        this.teamClassName = teamclassName;
        this.postReplaceChild(oldChild, this.teamClassName, TEAMCLASS_PROPERTY);
    }

    void internalSetTeamClass(Name teamclassName) {
        this.supportedOnlyIn2();
        Name oldChild = this.teamClassName;
        this.preReplaceChild(oldChild, this.teamClassName, TEAMCLASS_PROPERTY);
        this.teamClassName = teamclassName;
        this.postReplaceChild(oldChild, this.teamClassName, TEAMCLASS_PROPERTY);
    }

    public void setTeamClassType(Type teamClassType) {
        this.unsupportedIn2();
        Type oldChild = this.teamClassType;
        this.preReplaceChild(oldChild, teamClassType, TEAMCLASS_TYPE_PROPERTY);
        this.teamClassType = teamClassType;
        this.postReplaceChild(oldChild, teamClassType, TEAMCLASS_TYPE_PROPERTY);
    }

    @Override
    public Name getSuperclass() {
        this.supportedOnlyIn2();
        return this.optionalSuperclassName;
    }

    @Override
    public Type getSuperclassType() {
        this.unsupportedIn2();
        return this.optionalSuperclassType;
    }

    @Override
    public void setSuperclass(Name superclassName) {
        this.supportedOnlyIn2();
        Name oldChild = this.optionalSuperclassName;
        this.preReplaceChild(oldChild, superclassName, SUPERCLASS_PROPERTY);
        this.optionalSuperclassName = superclassName;
        this.postReplaceChild(oldChild, superclassName, SUPERCLASS_PROPERTY);
    }

    @Override
    public void setSuperclassType(Type superclassType) {
        this.unsupportedIn2();
        Type oldChild = this.optionalSuperclassType;
        this.preReplaceChild(oldChild, superclassType, SUPERCLASS_TYPE_PROPERTY);
        this.optionalSuperclassType = superclassType;
        this.postReplaceChild(oldChild, superclassType, SUPERCLASS_TYPE_PROPERTY);
    }

    public CalloutMappingDeclaration[] getCallOuts() {
        List bd = this.bodyDeclarations();
        int callOutCount = 0;
        ListIterator it = bd.listIterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof CalloutMappingDeclaration)) continue;
            ++callOutCount;
        }
        CalloutMappingDeclaration[] callOuts = new CalloutMappingDeclaration[callOutCount];
        int next = 0;
        ListIterator it2 = bd.listIterator();
        while (it2.hasNext()) {
            Object decl = it2.next();
            if (!(decl instanceof CalloutMappingDeclaration)) continue;
            callOuts[next++] = (CalloutMappingDeclaration)decl;
        }
        return callOuts;
    }

    public CallinMappingDeclaration[] getCallIns() {
        List bd = this.bodyDeclarations();
        int callInCount = 0;
        ListIterator it = bd.listIterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof CallinMappingDeclaration)) continue;
            ++callInCount;
        }
        CallinMappingDeclaration[] callIns = new CallinMappingDeclaration[callInCount];
        int next = 0;
        ListIterator it2 = bd.listIterator();
        while (it2.hasNext()) {
            Object decl = it2.next();
            if (!(decl instanceof CallinMappingDeclaration)) continue;
            callIns[next++] = (CallinMappingDeclaration)decl;
        }
        return callIns;
    }

    @Override
    void appendDebugString(StringBuffer buffer) {
        buffer.append("RoleTypeDeclaration[\n");
        buffer.append("class ");
        buffer.append(this.getName().getIdentifier());
        buffer.append("\n");
        if (this.optionalGuardPredicate != null) {
            this.getGuardPredicate().appendDebugString(buffer);
            buffer.append("\n");
        }
        Iterator it = this.bodyDeclarations().iterator();
        while (it.hasNext()) {
            BodyDeclaration d = (BodyDeclaration)it.next();
            d.appendDebugString(buffer);
            if (!it.hasNext()) continue;
            buffer.append(";\n");
        }
        buffer.append("]");
    }

    @Override
    int memSize() {
        return super.memSize() + 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.optionalDocComment == null ? 0 : this.getJavadoc().treeSize()) + (this.modifiers == null ? 0 : this.modifiers.listSize()) + (this.typeName == null ? 0 : this.getName().treeSize()) + (this.typeParameters == null ? 0 : this.typeParameters.listSize()) + (this.optionalSuperclassName == null ? 0 : this.getSuperclass().treeSize()) + (this.optionalSuperclassType == null ? 0 : this.getSuperclassType().treeSize()) + (this.superInterfaceNames == null ? 0 : this.superInterfaceNames.listSize()) + (this.superInterfaceTypes == null ? 0 : this.superInterfaceTypes.listSize()) + this.bodyDeclarations.listSize() + this._precedences.listSize() + (this.optionalBaseClassName == null ? 0 : this.optionalBaseClassName.treeSize()) + (this.optionalBaseClassType == null ? 0 : this.optionalBaseClassType.treeSize()) + (this.teamClassName == null ? 0 : this.teamClassName.treeSize()) + (this.teamClassType == null ? 0 : this.teamClassType.treeSize()) + (this.optionalGuardPredicate == null ? 0 : this.optionalGuardPredicate.treeSize());
    }
}

