/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.connection.xmlrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.xmlrpc.webserver.WebServer;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.EMFStoreController;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.connection.ServerKeyStoreManager;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.Messages;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.ServerKeyStoreException;

public class EMFStoreWebServer
extends WebServer {
    private final String[] validCiphers = ServerConfiguration.getSplittedProperty("emfstore.ssl.ciphers");

    public EMFStoreWebServer(int port) {
        super(port);
    }

    protected boolean allowConnection(Socket socket) {
        String[] validCiphers = ServerConfiguration.getSplittedProperty("emfstore.ssl.ciphers");
        if (SSLSocket.class.isInstance(socket) && validCiphers != null) {
            SSLSocket ss = (SSLSocket)socket;
            ss.setEnabledCipherSuites(validCiphers);
        }
        return super.allowConnection(socket);
    }

    protected ServerSocket createServerSocket(int pPort, int backlog, InetAddress addr) throws IOException {
        ServerSocketFactory serverSocketFactory = null;
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(ServerKeyStoreManager.getInstance().getKeyManagerFactory().getKeyManagers(), null, null);
            serverSocketFactory = context.getServerSocketFactory();
        }
        catch (NoSuchAlgorithmException exception) {
            this.shutdown((SSLServerSocketFactory)serverSocketFactory, exception);
        }
        catch (KeyManagementException exception) {
            this.shutdown((SSLServerSocketFactory)serverSocketFactory, exception);
        }
        catch (ServerKeyStoreException exception) {
            this.shutdown((SSLServerSocketFactory)serverSocketFactory, exception);
        }
        return serverSocketFactory.createServerSocket(pPort, backlog, addr);
    }

    private void shutdown(SSLServerSocketFactory serverSocketFactory, Exception e) {
        if (serverSocketFactory == null) {
            ModelUtil.logException((String)Messages.XmlRpcBuiltinWebServer_ServerSocketInitFailed, (Throwable)e);
            EMFStoreController.getInstance().shutdown(new FatalESException());
        }
    }
}

