/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.callstack;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.profiling.core.Activator;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class CallStackStateProvider
extends AbstractTmfStateProvider {
    public static final String PROCESSES = "Processes";
    @Deprecated
    public static final String CALL_STACK = "CallStack";
    public static final int UNKNOWN_PID = -1;
    public static final String UNKNOWN = "UNKNOWN";
    private static final String ID = "org.eclipse.linuxtools.tmf.callstack";
    private long fMissMatched = 0L;

    public CallStackStateProvider(ITmfTrace trace) {
        super(trace, ID);
    }

    protected void eventHandle(ITmfEvent event) {
        if (!this.considerEvent(event)) {
            return;
        }
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        ITmfStateValue functionEntryName = this.functionEntry(event);
        if (functionEntryName != null) {
            long timestamp = event.getTimestamp().toNanos();
            String processName = this.getProcessName(event);
            int processId = this.getProcessId(event);
            if (processName == null) {
                processName = processId == -1 ? UNKNOWN : Integer.toString(processId);
            }
            int processQuark = ss.getQuarkAbsoluteAndAdd(new String[]{PROCESSES, processName});
            ss.updateOngoingState((ITmfStateValue)TmfStateValue.newValueInt((int)processId), processQuark);
            String threadName = this.getThreadName(event);
            long threadId = this.getThreadId(event);
            if (threadName == null) {
                threadName = Long.toString(threadId);
            }
            int threadQuark = ss.getQuarkRelativeAndAdd(processQuark, new String[]{threadName});
            ss.updateOngoingState((ITmfStateValue)TmfStateValue.newValueLong((long)threadId), threadQuark);
            int callStackQuark = ss.getQuarkRelativeAndAdd(threadQuark, new String[]{CALL_STACK});
            ss.pushAttribute(timestamp, functionEntryName.unboxValue(), callStackQuark);
            return;
        }
        ITmfStateValue functionExitState = this.functionExit(event);
        if (functionExitState != null) {
            String threadName;
            long timestamp = event.getTimestamp().toNanos();
            String processName = this.getProcessName(event);
            if (processName == null) {
                int processId = this.getProcessId(event);
                String string = processName = processId == -1 ? UNKNOWN : Integer.toString(processId);
            }
            if ((threadName = this.getThreadName(event)) == null) {
                threadName = Long.toString(this.getThreadId(event));
            }
            int quark = ss.getQuarkAbsoluteAndAdd(new String[]{PROCESSES, processName, threadName, CALL_STACK});
            ITmfStateValue poppedValue = ss.popAttribute(timestamp, quark);
            if (!functionExitState.isNull() && !functionExitState.equals(poppedValue)) {
                if (this.fMissMatched == 0L) {
                    Activator.getInstance().logWarning(NLS.bind((String)Messages.CallStackStateProvider_UnmatchedPoppedValue, (Object)functionExitState, (Object)poppedValue));
                }
                ++this.fMissMatched;
            }
        }
    }

    public void done() {
        if (this.fMissMatched > 0L) {
            Activator.getInstance().logWarning(NLS.bind((String)Messages.CallStackStateProvider_IncoherentCallstack, (Object)this.fMissMatched));
        }
        super.done();
    }

    public abstract CallStackStateProvider getNewInstance();

    protected abstract boolean considerEvent(ITmfEvent var1);

    protected abstract @Nullable ITmfStateValue functionEntry(ITmfEvent var1);

    protected abstract @Nullable ITmfStateValue functionExit(ITmfEvent var1);

    protected abstract int getProcessId(ITmfEvent var1);

    protected @Nullable String getProcessName(ITmfEvent event) {
        return null;
    }

    protected abstract long getThreadId(ITmfEvent var1);

    protected @Nullable String getThreadName(ITmfEvent event) {
        return null;
    }
}

