/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.actions;

import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDESessionSettings;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.BrowserViewAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.ProbeNodeData;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.ProbevarNodeData;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.ProbeAliasBrowserView;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.ui.IWorkbenchWindow;

public class ProbeAliasAction
extends BrowserViewAction {
    private static final String ID = "org.eclipse.linuxtools.systemtap.ui.ide.ProbeAliasAction";

    public ProbeAliasAction(IWorkbenchWindow window, ProbeAliasBrowserView view) {
        super(window, view);
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setText(Localization.getString("ProbeAliasAction.Insert"));
        this.setToolTipText(Localization.getString("ProbeAliasAction.InsertSelectedProbe"));
    }

    public void run() {
        Object o = this.getSelectedElement();
        if (o instanceof TreeNode) {
            TreeNode t = (TreeNode)o;
            if (t.isClickable()) {
                STPEditor stpeditor = IDESessionSettings.getOrAskForActiveSTPEditor(true);
                if (stpeditor != null) {
                    stpeditor.insertText(this.buildString((TreeNode)o));
                }
            } else {
                this.runExpandAction();
            }
        }
    }

    private String buildString(TreeNode t) {
        StringBuilder s = new StringBuilder("\nprobe " + t.toString());
        if (t.getChildCount() > 0 && t.getChildAt(0).getData() instanceof ProbeNodeData) {
            s.append(".*");
        }
        s.append("\n{\n");
        if (t.getChildCount() > 0 && t.getChildAt(0).getData() instanceof ProbevarNodeData) {
            s.append("\t/*\n\t * " + Localization.getString("ProbeAliasAction.AvailableVariables") + "\n\t * ");
            boolean first = true;
            int i = 0;
            while (i < t.getChildCount()) {
                if (first) {
                    first = false;
                } else {
                    s.append(", ");
                }
                s.append(t.getChildAt(i).toString());
                ++i;
            }
            s.append("\n\t */\n");
        }
        s.append("\n}\n");
        return s.toString();
    }
}

