import { TextEdit, Position, Range, FormattingOptions } from 'vscode-languageserver-types';
export declare class DockerFormatter {
    private getIndentation(formattingOptions?);
    /**
     * Creates a TextEdit for formatting the given document.
     *
     * @param document the document being formatted
     * @param start the start offset of the document's content to be replaced
     * @param end the end offset of the document's content to be replaced
     * @param indent true if this block should be replaced with an indentation, false otherwise
     * @param indentation the string to use for an indentation
     */
    private createFormattingEdit(document, start, end, indent, indentation);
    formatOnType(content: string, position: Position, ch: string, options: FormattingOptions): TextEdit[];
    formatRange(content: string, range: Range, options?: FormattingOptions): TextEdit[];
    /**
     * Formats the specified lines of the given document based on the
     * provided formatting options.
     *
     * @param document the text document to format
     * @param lines the lines to format
     * @param options the formatting options to use to perform the format
     * @return the text edits to apply to format the lines of the document
     */
    private format(content, lines, options?);
    private formatLines(document, content, lines, indentedLines, options?);
}
