/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.epp.internal.logging.aeri.ide.IIdeFactory;
import org.eclipse.epp.internal.logging.aeri.ide.IIdePackage;
import org.eclipse.epp.internal.logging.aeri.ide.IInternalInput;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;

import org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper;

import org.eclipse.epp.logging.aeri.core.IModelPackage;

import org.eclipse.jface.dialogs.Dialog;

import org.eclipse.swt.graphics.Image;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class IdePackageImpl extends EPackageImpl implements IIdePackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass logEventsQueueEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass logEventGroupEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass logEventEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass internalInputEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass serverDescriptorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processorDescriptorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType imageEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType dialogEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType reportProcessorSafeWrapperEDataType = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private IdePackageImpl() {
		super(eNS_URI, IIdeFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link IIdePackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static IIdePackage init() {
		if (isInited) return (IIdePackage)EPackage.Registry.INSTANCE.getEPackage(IIdePackage.eNS_URI);

		// Obtain or create and register package
		IdePackageImpl theIdePackage = (IdePackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof IdePackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new IdePackageImpl());

		isInited = true;

		// Initialize simple dependencies
		IModelPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theIdePackage.createPackageContents();

		// Initialize created meta-data
		theIdePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theIdePackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(IIdePackage.eNS_URI, theIdePackage);
		return theIdePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLogEventsQueue() {
		return logEventsQueueEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLogEventsQueue_Groups() {
		return (EReference)logEventsQueueEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EOperation getLogEventsQueue__AddGroup__EList() {
		return logEventsQueueEClass.getEOperations().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLogEventGroup() {
		return logEventGroupEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getLogEventGroup_Status() {
		return (EAttribute)logEventGroupEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLogEventGroup_Events() {
		return (EReference)logEventGroupEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getLogEventGroup_Timestamp() {
		return (EAttribute)logEventGroupEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLogEvent() {
		return logEventEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getLogEvent_Status() {
		return (EAttribute)logEventEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getLogEvent_Label() {
		return (EAttribute)logEventEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLogEvent_Server() {
		return (EReference)logEventEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLogEvent_Group() {
		return (EReference)logEventEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLogEvent_Interest() {
		return (EReference)logEventEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLogEvent_Options() {
		return (EReference)logEventEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLogEvent_Response() {
		return (EReference)logEventEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getLogEvent_Context() {
		return (EAttribute)logEventEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getInternalInput() {
		return internalInputEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getInternalInput_Input() {
		return (EReference)internalInputEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getServerDescriptor() {
		return serverDescriptorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServerDescriptor_Id() {
		return (EAttribute)serverDescriptorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServerDescriptor_Name() {
		return (EAttribute)serverDescriptorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServerDescriptor_Description() {
		return (EAttribute)serverDescriptorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServerDescriptor_Contributor() {
		return (EAttribute)serverDescriptorEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServerDescriptor_Clazz() {
		return (EAttribute)serverDescriptorEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServerDescriptor_Icon16() {
		return (EAttribute)serverDescriptorEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServerDescriptor_Icon32() {
		return (EAttribute)serverDescriptorEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServerDescriptor_Connection() {
		return (EAttribute)serverDescriptorEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServerDescriptor_Configured() {
		return (EAttribute)serverDescriptorEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServerDescriptor_Enabled() {
		return (EAttribute)serverDescriptorEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getServerDescriptor_ConfigurationElement() {
		return (EAttribute)serverDescriptorEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EOperation getServerDescriptor__GetImage16() {
		return serverDescriptorEClass.getEOperations().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EOperation getServerDescriptor__GetImage32() {
		return serverDescriptorEClass.getEOperations().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EOperation getServerDescriptor__IsActive() {
		return serverDescriptorEClass.getEOperations().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessorDescriptor() {
		return processorDescriptorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessorDescriptor_Processor() {
		return (EAttribute)processorDescriptorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessorDescriptor_ConfigurationElement() {
		return (EAttribute)processorDescriptorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessorDescriptor_Description() {
		return (EAttribute)processorDescriptorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessorDescriptor_Icon16() {
		return (EAttribute)processorDescriptorEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessorDescriptor_Contributor() {
		return (EAttribute)processorDescriptorEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessorDescriptor_Directive() {
		return (EAttribute)processorDescriptorEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessorDescriptor_Name() {
		return (EAttribute)processorDescriptorEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessorDescriptor_Automatic() {
		return (EAttribute)processorDescriptorEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EOperation getProcessorDescriptor__GetImage16() {
		return processorDescriptorEClass.getEOperations().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getImage() {
		return imageEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getDialog() {
		return dialogEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getReportProcessorSafeWrapper() {
		return reportProcessorSafeWrapperEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IIdeFactory getIdeFactory() {
		return (IIdeFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		logEventsQueueEClass = createEClass(LOG_EVENTS_QUEUE);
		createEReference(logEventsQueueEClass, LOG_EVENTS_QUEUE__GROUPS);
		createEOperation(logEventsQueueEClass, LOG_EVENTS_QUEUE___ADD_GROUP__ELIST);

		logEventGroupEClass = createEClass(LOG_EVENT_GROUP);
		createEAttribute(logEventGroupEClass, LOG_EVENT_GROUP__STATUS);
		createEReference(logEventGroupEClass, LOG_EVENT_GROUP__EVENTS);
		createEAttribute(logEventGroupEClass, LOG_EVENT_GROUP__TIMESTAMP);

		logEventEClass = createEClass(LOG_EVENT);
		createEAttribute(logEventEClass, LOG_EVENT__STATUS);
		createEAttribute(logEventEClass, LOG_EVENT__LABEL);
		createEReference(logEventEClass, LOG_EVENT__SERVER);
		createEReference(logEventEClass, LOG_EVENT__GROUP);
		createEReference(logEventEClass, LOG_EVENT__INTEREST);
		createEReference(logEventEClass, LOG_EVENT__OPTIONS);
		createEReference(logEventEClass, LOG_EVENT__RESPONSE);
		createEAttribute(logEventEClass, LOG_EVENT__CONTEXT);

		internalInputEClass = createEClass(INTERNAL_INPUT);
		createEReference(internalInputEClass, INTERNAL_INPUT__INPUT);

		serverDescriptorEClass = createEClass(SERVER_DESCRIPTOR);
		createEAttribute(serverDescriptorEClass, SERVER_DESCRIPTOR__ID);
		createEAttribute(serverDescriptorEClass, SERVER_DESCRIPTOR__NAME);
		createEAttribute(serverDescriptorEClass, SERVER_DESCRIPTOR__DESCRIPTION);
		createEAttribute(serverDescriptorEClass, SERVER_DESCRIPTOR__CONTRIBUTOR);
		createEAttribute(serverDescriptorEClass, SERVER_DESCRIPTOR__CLAZZ);
		createEAttribute(serverDescriptorEClass, SERVER_DESCRIPTOR__ICON16);
		createEAttribute(serverDescriptorEClass, SERVER_DESCRIPTOR__ICON32);
		createEAttribute(serverDescriptorEClass, SERVER_DESCRIPTOR__CONNECTION);
		createEAttribute(serverDescriptorEClass, SERVER_DESCRIPTOR__CONFIGURED);
		createEAttribute(serverDescriptorEClass, SERVER_DESCRIPTOR__ENABLED);
		createEAttribute(serverDescriptorEClass, SERVER_DESCRIPTOR__CONFIGURATION_ELEMENT);
		createEOperation(serverDescriptorEClass, SERVER_DESCRIPTOR___GET_IMAGE16);
		createEOperation(serverDescriptorEClass, SERVER_DESCRIPTOR___GET_IMAGE32);
		createEOperation(serverDescriptorEClass, SERVER_DESCRIPTOR___IS_ACTIVE);

		processorDescriptorEClass = createEClass(PROCESSOR_DESCRIPTOR);
		createEAttribute(processorDescriptorEClass, PROCESSOR_DESCRIPTOR__PROCESSOR);
		createEAttribute(processorDescriptorEClass, PROCESSOR_DESCRIPTOR__CONFIGURATION_ELEMENT);
		createEAttribute(processorDescriptorEClass, PROCESSOR_DESCRIPTOR__DESCRIPTION);
		createEAttribute(processorDescriptorEClass, PROCESSOR_DESCRIPTOR__ICON16);
		createEAttribute(processorDescriptorEClass, PROCESSOR_DESCRIPTOR__CONTRIBUTOR);
		createEAttribute(processorDescriptorEClass, PROCESSOR_DESCRIPTOR__DIRECTIVE);
		createEAttribute(processorDescriptorEClass, PROCESSOR_DESCRIPTOR__NAME);
		createEAttribute(processorDescriptorEClass, PROCESSOR_DESCRIPTOR__AUTOMATIC);
		createEOperation(processorDescriptorEClass, PROCESSOR_DESCRIPTOR___GET_IMAGE16);

		// Create data types
		imageEDataType = createEDataType(IMAGE);
		dialogEDataType = createEDataType(DIALOG);
		reportProcessorSafeWrapperEDataType = createEDataType(REPORT_PROCESSOR_SAFE_WRAPPER);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		IModelPackage theModelPackage = (IModelPackage)EPackage.Registry.INSTANCE.getEPackage(IModelPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		serverDescriptorEClass.getESuperTypes().add(theModelPackage.getLinkable());
		serverDescriptorEClass.getESuperTypes().add(theModelPackage.getUserSettings());

		// Initialize classes, features, and operations; add parameters
		initEClass(logEventsQueueEClass, ILogEventsQueue.class, "LogEventsQueue", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getLogEventsQueue_Groups(), this.getLogEventGroup(), null, "groups", null, 0, -1, ILogEventsQueue.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		EOperation op = initEOperation(getLogEventsQueue__AddGroup__EList(), this.getLogEventGroup(), "addGroup", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getLogEvent(), "events", 0, -1, IS_UNIQUE, IS_ORDERED);

		initEClass(logEventGroupEClass, ILogEventGroup.class, "LogEventGroup", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLogEventGroup_Status(), theModelPackage.getIStatus(), "status", null, 0, 1, ILogEventGroup.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getLogEventGroup_Events(), this.getLogEvent(), this.getLogEvent_Group(), "events", null, 0, -1, ILogEventGroup.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLogEventGroup_Timestamp(), ecorePackage.getELong(), "timestamp", null, 0, 1, ILogEventGroup.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(logEventEClass, ILogEvent.class, "LogEvent", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLogEvent_Status(), theModelPackage.getIStatus(), "status", null, 1, 1, ILogEvent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLogEvent_Label(), ecorePackage.getEString(), "label", null, 0, 1, ILogEvent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getLogEvent_Server(), this.getServerDescriptor(), null, "server", null, 1, 1, ILogEvent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getLogEvent_Group(), this.getLogEventGroup(), this.getLogEventGroup_Events(), "group", null, 0, 1, ILogEvent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getLogEvent_Interest(), theModelPackage.getProblemState(), null, "interest", null, 0, 1, ILogEvent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getLogEvent_Options(), theModelPackage.getSendOptions(), null, "options", null, 0, 1, ILogEvent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getLogEvent_Response(), theModelPackage.getProblemState(), null, "response", null, 0, 1, ILogEvent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLogEvent_Context(), theModelPackage.getIEclipseContext(), "context", null, 1, 1, ILogEvent.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(internalInputEClass, IInternalInput.class, "InternalInput", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getInternalInput_Input(), this.getLogEvent(), null, "input", null, 0, -1, IInternalInput.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(serverDescriptorEClass, IServerDescriptor.class, "ServerDescriptor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getServerDescriptor_Id(), ecorePackage.getEString(), "id", null, 1, 1, IServerDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServerDescriptor_Name(), ecorePackage.getEString(), "name", null, 0, 1, IServerDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServerDescriptor_Description(), ecorePackage.getEString(), "description", null, 0, 1, IServerDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServerDescriptor_Contributor(), ecorePackage.getEString(), "contributor", null, 0, 1, IServerDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServerDescriptor_Clazz(), ecorePackage.getEString(), "clazz", null, 0, 1, IServerDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServerDescriptor_Icon16(), ecorePackage.getEString(), "icon16", null, 0, 1, IServerDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServerDescriptor_Icon32(), ecorePackage.getEString(), "icon32", null, 0, 1, IServerDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServerDescriptor_Connection(), theModelPackage.getIServerConnection(), "connection", null, 0, 1, IServerDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServerDescriptor_Configured(), ecorePackage.getEBoolean(), "configured", null, 0, 1, IServerDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServerDescriptor_Enabled(), ecorePackage.getEBoolean(), "enabled", "true", 0, 1, IServerDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getServerDescriptor_ConfigurationElement(), theModelPackage.getIConfigurationElement(), "configurationElement", null, 0, 1, IServerDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEOperation(getServerDescriptor__GetImage16(), this.getImage(), "getImage16", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEOperation(getServerDescriptor__GetImage32(), this.getImage(), "getImage32", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEOperation(getServerDescriptor__IsActive(), ecorePackage.getEBoolean(), "isActive", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(processorDescriptorEClass, IProcessorDescriptor.class, "ProcessorDescriptor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getProcessorDescriptor_Processor(), this.getReportProcessorSafeWrapper(), "processor", null, 0, 1, IProcessorDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProcessorDescriptor_ConfigurationElement(), theModelPackage.getIConfigurationElement(), "configurationElement", null, 0, 1, IProcessorDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProcessorDescriptor_Description(), ecorePackage.getEString(), "description", null, 0, 1, IProcessorDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProcessorDescriptor_Icon16(), ecorePackage.getEString(), "icon16", null, 0, 1, IProcessorDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProcessorDescriptor_Contributor(), ecorePackage.getEString(), "contributor", null, 0, 1, IProcessorDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProcessorDescriptor_Directive(), ecorePackage.getEString(), "directive", null, 0, 1, IProcessorDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProcessorDescriptor_Name(), ecorePackage.getEString(), "name", null, 0, 1, IProcessorDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProcessorDescriptor_Automatic(), ecorePackage.getEBoolean(), "automatic", null, 0, 1, IProcessorDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEOperation(getProcessorDescriptor__GetImage16(), this.getImage(), "getImage16", 0, 1, IS_UNIQUE, IS_ORDERED);

		// Initialize data types
		initEDataType(imageEDataType, Image.class, "Image", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(dialogEDataType, Dialog.class, "Dialog", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(reportProcessorSafeWrapperEDataType, ReportProcessorSafeWrapper.class, "ReportProcessorSafeWrapper", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);
	}

} //IdePackageImpl
