/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.RetargetAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class RetargetRunToLineAction
extends RetargetAction {
    private DebugContextListener fContextListener = new DebugContextListener();
    private ISuspendResume fTargetElement = null;

    @Override
    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.fWindow).removeDebugContextListener(this.fContextListener);
        super.dispose();
    }

    @Override
    public void init(IWorkbenchWindow window) {
        super.init(window);
        IDebugContextService service = DebugUITools.getDebugContextManager().getContextService(window);
        service.addDebugContextListener(this.fContextListener);
        ISelection activeContext = service.getActiveContext();
        this.fContextListener.contextActivated(activeContext);
    }

    @Override
    public void init(IAction action) {
        super.init(action);
        action.setActionDefinitionId("org.eclipse.debug.ui.commands.RunToLine");
    }

    @Override
    protected boolean canPerformAction(Object target, ISelection selection, IWorkbenchPart part) {
        return this.fTargetElement != null && ((IRunToLineTarget)target).canRunToLine(part, selection, this.fTargetElement);
    }

    protected Class<IRunToLineTarget> getAdapterClass() {
        return IRunToLineTarget.class;
    }

    @Override
    protected void performAction(Object target, ISelection selection, IWorkbenchPart part) throws CoreException {
        ((IRunToLineTarget)target).runToLine(part, selection, this.fTargetElement);
    }

    @Override
    protected String getOperationUnavailableMessage() {
        return ActionMessages.RetargetRunToLineAction_0;
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fTargetElement == null) {
            action.setEnabled(false);
        } else {
            super.selectionChanged(action, selection);
        }
    }

    class DebugContextListener
    implements IDebugContextListener {
        DebugContextListener() {
        }

        protected void contextActivated(ISelection selection) {
            IAction action;
            IStructuredSelection ss;
            RetargetRunToLineAction.this.fTargetElement = null;
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                RetargetRunToLineAction.this.fTargetElement = (ISuspendResume)DebugPlugin.getAdapter((Object)ss.getFirstElement(), ISuspendResume.class);
            }
            if ((action = RetargetRunToLineAction.this.getAction()) != null) {
                action.setEnabled(RetargetRunToLineAction.this.fTargetElement != null && RetargetRunToLineAction.this.isTargetEnabled());
            }
        }

        @Override
        public void debugContextChanged(DebugContextEvent event) {
            this.contextActivated(event.getContext());
        }
    }
}

