/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tcf.internal.cdt.ui.Activator;
import org.eclipse.tcf.internal.cdt.ui.ImageCache;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.Messages;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFBreakpointScopeExtension;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class BreakpointScopeCategory
extends PlatformObject
implements IWorkbenchAdapter {
    private static Object[] EMPTY_CHILDREN_ARRAY = new Object[0];
    private final String fFilter;
    private final String fContextIds;

    public BreakpointScopeCategory(String filter, String contextIds) {
        this.fFilter = filter != null ? filter : "";
        this.fContextIds = contextIds != null ? contextIds : "";
    }

    public String getFilter() {
        return this.fFilter;
    }

    public String getContextIds() {
        return this.fContextIds;
    }

    void setFilter(final String filter, final String contextIds) {
        final List<ICBreakpoint> bps = this.findCategoryBreakpoints();
        if (bps.isEmpty()) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    for (ICBreakpoint bp : bps) {
                        BreakpointScopeCategory.this.getScopeExtension(bp).setPropertiesFilter(filter);
                        BreakpointScopeCategory.this.getScopeExtension(bp).setRawContextIds(contextIds);
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    public String getLabel(Object o) {
        if (this.getFilter().length() != 0 && this.getContextIds().length() != 0) {
            return MessageFormat.format(Messages.BreakpointScopeCategory_filter_and_contexts_label, this.getFilter(), this.getContextIds());
        }
        if (this.getFilter().length() != 0) {
            return MessageFormat.format(Messages.BreakpointScopeCategory_filter_label, this.getFilter());
        }
        if (this.getContextIds().length() != 0) {
            return MessageFormat.format(Messages.BreakpointScopeCategory_contexts_label, this.getContextIds());
        }
        return Messages.BreakpointScopeCategory_global_label;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return ImageCache.getImageDescriptor("icons/obj16/bp_scope.gif");
    }

    public Object[] getChildren(Object o) {
        return EMPTY_CHILDREN_ARRAY;
    }

    public Object getParent(Object o) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BreakpointScopeCategory) {
            BreakpointScopeCategory other = (BreakpointScopeCategory)((Object)obj);
            return this.getFilter().equals(other.getFilter()) && this.getContextIds().equals(other.getContextIds());
        }
        return false;
    }

    public int hashCode() {
        return this.getFilter().hashCode() + this.getContextIds().hashCode();
    }

    private List<ICBreakpoint> findCategoryBreakpoints() {
        IBreakpoint[] breakpoints;
        LinkedList<ICBreakpoint> categoryBreakpoints = new LinkedList<ICBreakpoint>();
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            IMarker bpMarker = bp.getMarker();
            if (bp instanceof ICBreakpoint && bpMarker != null) {
                String filter = bpMarker.getAttribute("org.eclipse.tcf.debug.ContextQuery", "");
                String contextIds = bpMarker.getAttribute("org.eclipse.tcf.debug.ContextIds", "");
                if (this.getFilter() != null && this.getFilter().equals(filter) && this.getContextIds().equals(contextIds)) {
                    categoryBreakpoints.add((ICBreakpoint)bp);
                }
            }
            ++n2;
        }
        return categoryBreakpoints;
    }

    private TCFBreakpointScopeExtension getScopeExtension(ICBreakpoint bp) throws CoreException {
        return (TCFBreakpointScopeExtension)bp.getExtension("org.eclipse.tcf.debug", TCFBreakpointScopeExtension.class);
    }
}

