/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Comparator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.emfstore.common.ESResourceSetProvider;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESPriorityComparator;
import org.eclipse.emf.emfstore.internal.common.CommonUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

public final class ESServerURIUtil {
    public static final String SCHEME = "emfstore";
    public static final String SERVER_SEGMENT = "serverspaces";
    public static final String PROJECTS_SEGMENT = "projects";
    public static final String VERSIONS_SEGMENT = "versions";
    public static final String CHANGEPACKAGES_SEGMENT = "changepackages";
    public static final String PROJECTSTATES_SEGMENT = "projectstates";
    public static final String SERVERSPACE_SEGMENT = "serverspace";
    public static final String PROJECTHISTORY_SEGMENT = "projecthistory";
    public static final String DYNAMIC_MODELS_SEGMENT = "dynamic-models";
    private static URIConverter uriConverter;

    private ESServerURIUtil() {
    }

    public static URI createServerSpaceURI() {
        return URI.createURI((String)(String.valueOf(ESServerURIUtil.getServerPrefix()) + SERVERSPACE_SEGMENT));
    }

    public static URI createDynamicModelsURI(EPackage ePackage) throws ESException {
        String uriFileName = null;
        try {
            uriFileName = URLEncoder.encode(ePackage.getNsURI(), CommonUtil.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ESException("Registration failed: Could not convert NsUri to filename!");
        }
        return URI.createURI((String)(String.valueOf(ESServerURIUtil.getServerPrefix()) + DYNAMIC_MODELS_SEGMENT + "/" + uriFileName + (uriFileName.endsWith(".ecore") ? "" : ".ecore")));
    }

    public static URI createProjectHistoryURI(ProjectId projectId) {
        return URI.createURI((String)(String.valueOf(ESServerURIUtil.getProjectsPrefix(projectId)) + PROJECTHISTORY_SEGMENT));
    }

    public static URI createVersionURI(ProjectId projectId, PrimaryVersionSpec versionId) {
        return URI.createURI((String)(String.valueOf(ESServerURIUtil.getProjectsPrefix(projectId)) + VERSIONS_SEGMENT + "/" + versionId.getIdentifier()));
    }

    public static URI createChangePackageURI(ProjectId projectId, PrimaryVersionSpec versionId) {
        return URI.createURI((String)(String.valueOf(ESServerURIUtil.getProjectsPrefix(projectId)) + CHANGEPACKAGES_SEGMENT + "/" + versionId.getIdentifier()));
    }

    public static URI createChangePackageURI(URI versionURI) {
        return versionURI.trimSegments(2).appendSegment(CHANGEPACKAGES_SEGMENT).appendSegment(versionURI.segment(versionURI.segmentCount() - 1));
    }

    public static URI createProjectStateURI(ProjectId projectId, PrimaryVersionSpec versionId) {
        return URI.createURI((String)(String.valueOf(ESServerURIUtil.getProjectsPrefix(projectId)) + PROJECTSTATES_SEGMENT + "/" + versionId.getIdentifier()));
    }

    public static URI createProjectStateURI(URI versionURI) {
        return versionURI.trimSegments(2).appendSegment(PROJECTSTATES_SEGMENT).appendSegment(versionURI.segment(versionURI.segmentCount() - 1));
    }

    public static String getProfile() {
        String parameter = ServerConfiguration.getStartArgument("-profile");
        if (parameter == null) {
            parameter = "default";
            if (ServerConfiguration.isTesting()) {
                parameter = String.valueOf(parameter) + "_test";
            } else if (!ServerConfiguration.isReleaseVersion()) {
                parameter = ServerConfiguration.isInternalReleaseVersion() ? String.valueOf(parameter) + "_internal" : String.valueOf(parameter) + "_dev";
            }
        }
        return parameter;
    }

    private static String getServerPrefix() {
        return "emfstore://serverspaces/" + ESServerURIUtil.getProfile() + "/";
    }

    private static String getProjectsPrefix(ProjectId projectId) {
        return String.valueOf(ESServerURIUtil.getServerPrefix()) + PROJECTS_SEGMENT + "/" + projectId.getId() + "/";
    }

    public static boolean exists(URI uri) {
        return ESServerURIUtil.getURIConverter().exists(uri, null);
    }

    private static URIConverter getURIConverter() {
        if (uriConverter == null) {
            ESExtensionPoint extensionPoint = new ESExtensionPoint("org.eclipse.emf.emfstore.server.resourceSetProvider", true, (Comparator)new ESPriorityComparator("priority", true));
            ESResourceSetProvider resourceSetProvider = (ESResourceSetProvider)extensionPoint.getElementWithHighestPriority().getClass("class", ESResourceSetProvider.class);
            uriConverter = resourceSetProvider.getResourceSet().getURIConverter();
        }
        return uriConverter;
    }
}

