/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.ws.commons.util.Base64;
import org.apache.xmlrpc.serializer.TypeSerializerImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.common.CommonUtil;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.util.Messages;
import org.eclipse.emf.emfstore.internal.server.exceptions.SerializationException;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EObjectSerializer
extends TypeSerializerImpl {
    private static final String SELF_CONTAINMENT_CHECK_OPTION = "SelfContainmentCheck";
    private static final String SERIALIZATION_OPTIONS_EXT = "org.eclipse.emf.emfstore.common.model.serializationOptions";
    public static final String EOBJECT_TAG = "EObject";
    private static final String EX_EOBJECT_TAG = "ex:EObject";
    private static boolean containmentCheckEnabled;
    private static boolean serializationOptionsInitialized;

    public void write(ContentHandler pHandler, Object pObject) throws SAXException {
        block17: {
            EObjectSerializer.initSerializationOptions();
            this.startElements(pHandler);
            char[] buffer = new char[1024];
            Base64.SAXEncoder encoder = new Base64.SAXEncoder(buffer, 0, null, pHandler);
            try {
                URIConverter.WriteableOutputStream uws = null;
                Base64.EncoderOutputStream ostream = new Base64.EncoderOutputStream((Base64.Encoder)encoder);
                BufferedOutputStream bos = new BufferedOutputStream((OutputStream)ostream);
                try {
                    try {
                        EObject copy;
                        EObject eObject = (EObject)pObject;
                        XMIResource resource = (XMIResource)eObject.eResource();
                        if (eObject instanceof FileBasedChangePackage) {
                            ChangePackage changePackage = ((FileBasedChangePackage)FileBasedChangePackage.class.cast(eObject)).toInMemoryChangePackage();
                            eObject = changePackage;
                        }
                        if (eObject instanceof IdEObjectCollection && resource != null) {
                            OutputStreamWriter writer = null;
                            try {
                                writer = new OutputStreamWriter((OutputStream)bos, CommonUtil.getEncoding());
                                uws = new URIConverter.WriteableOutputStream((Writer)writer, CommonUtil.getEncoding());
                                Resource res = eObject.eResource();
                                this.checkResource(res);
                                res.save((OutputStream)uws, ModelUtil.getResourceSaveOptions());
                                break block17;
                            }
                            finally {
                                if (writer != null) {
                                    writer.close();
                                }
                            }
                        }
                        resource = EObjectSerializer.createXmiResource();
                        if (eObject instanceof IdEObjectCollection) {
                            copy = ModelUtil.copyIdEObjectCollection((IdEObjectCollection)((IdEObjectCollection)eObject), (XMIResource)resource);
                            this.setResourceIds(eObject, resource);
                        } else {
                            copy = ModelUtil.clone((EObject)eObject);
                        }
                        resource.getContents().add((Object)copy);
                        this.checkResource((Resource)resource);
                        resource.save((OutputStream)bos, ModelUtil.getResourceSaveOptions());
                    }
                    catch (SerializationException e) {
                        throw new SAXException(e);
                    }
                }
                finally {
                    bos.close();
                    if (uws != null) {
                        uws.close();
                    }
                }
            }
            catch (Base64.SAXIOException e) {
                throw e.getSAXException();
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        this.endElements(pHandler);
    }

    private static XMIResource createXmiResource() {
        XMIResource resource = (XMIResource)new ResourceSetImpl().createResource(ModelUtil.VIRTUAL_URI);
        ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(new HashMap());
        return resource;
    }

    private void setResourceIds(EObject eObject, XMIResource resource) {
        IdEObjectCollection collection = (IdEObjectCollection)eObject;
        for (EObject element : collection.getAllModelElements()) {
            ModelElementId elementId = collection.getModelElementId(element);
            if (elementId == null) continue;
            resource.setID(element, elementId.getId());
        }
    }

    private void endElements(ContentHandler pHandler) throws SAXException {
        pHandler.endElement("", EOBJECT_TAG, EX_EOBJECT_TAG);
        pHandler.endElement("", "value", "value");
    }

    private void startElements(ContentHandler pHandler) throws SAXException {
        pHandler.startElement("", "value", "value", ZERO_ATTRIBUTES);
        pHandler.startElement("", EOBJECT_TAG, EX_EOBJECT_TAG, ZERO_ATTRIBUTES);
    }

    private void checkResource(Resource resource) throws SerializationException {
        if (!containmentCheckEnabled) {
            return;
        }
        if (resource.getContents().size() != 1) {
            throw new SerializationException(Messages.EObjectSerializer_UnexpectedNumberOfEObjects);
        }
        EObject root = (EObject)resource.getContents().get(0);
        Set allChildEObjects = CommonUtil.getNonTransientContents((EObject)root);
        LinkedHashSet<EObject> allEObjects = new LinkedHashSet<EObject>(allChildEObjects);
        allEObjects.add(root);
        for (EObject eObject : allEObjects) {
            if (resource != eObject.eResource()) {
                throw new SerializationException(Messages.EObjectSerializer_NonSelfContainedResource);
            }
            if (!eObject.eIsProxy()) continue;
            throw new SerializationException(Messages.EObjectSerializer_UnresolvedProxy);
        }
    }

    private static void initSerializationOptions() {
        if (serializationOptionsInitialized) {
            return;
        }
        ESExtensionElement element = new ESExtensionPoint(SERIALIZATION_OPTIONS_EXT).getFirst();
        if (element != null) {
            containmentCheckEnabled = element.getBoolean(SELF_CONTAINMENT_CHECK_OPTION);
        }
        serializationOptionsInitialized = true;
    }
}

