/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.index.export;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.ResourceContainerRelativeLocationConverter;
import org.eclipse.cdt.core.index.export.AbstractExportProjectProvider;
import org.eclipse.cdt.core.index.export.ExportIndexFileInfoMatcher;
import org.eclipse.cdt.core.index.export.Messages;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultConfigurationData;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ExternalExportProjectProvider
extends AbstractExportProjectProvider {
    private static final String PREBUILT_PROJECT_OWNER = "org.eclipse.cdt.core.index.export.prebuiltOwner";
    private static final String ORG_ECLIPSE_CDT_CORE_INDEX_EXPORT_DATESTAMP = "org.eclipse.cdt.core.index.export.datestamp";
    private static final String CONTENT = "content";
    public static final String OPT_SOURCE = "-source";
    public static final String OPT_INCLUDE = "-include";
    public static final String OPT_EXCLUDE = "-exclude";
    public static final String OPT_FRAGMENT_ID = "-id";
    private IFolder content;
    private String fragmentId;

    @Override
    public ICProject createProject() throws CoreException {
        File source = new File(this.getSingleString(OPT_SOURCE));
        if (!source.exists()) {
            this.fail(MessageFormat.format((String)Messages.ExternalContentPEM_LocationToIndexNonExistent, (Object[])new Object[]{source}));
        }
        ArrayList<String> includeFiles = new ArrayList<String>();
        if (this.isPresent(OPT_INCLUDE)) {
            includeFiles.addAll(this.getParameters(OPT_INCLUDE));
        }
        ArrayList<String> excludeFiles = new ArrayList<String>();
        if (this.isPresent(OPT_EXCLUDE)) {
            excludeFiles.addAll(this.getParameters(OPT_EXCLUDE));
        }
        this.fragmentId = this.getSingleString(OPT_FRAGMENT_ID);
        return this.createCCProject("__" + System.currentTimeMillis(), source, includeFiles, excludeFiles);
    }

    protected IFolder getContentFolder() {
        return this.content;
    }

    private ICProject createCCProject(String projectName, final File location, final List<String> includeFiles, final List<String> excludeFiles) throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        final ICProject[] newProject = new ICProject[1];
        ws.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject project = workspace.getRoot().getProject("__prebuilt_index_temp__" + System.currentTimeMillis());
                IProjectDescription description = workspace.newProjectDescription(project.getName());
                CCorePlugin.getDefault().createCProject(description, project, NPM, ExternalExportProjectProvider.PREBUILT_PROJECT_OWNER);
                CCorePlugin.getDefault().convertProjectFromCtoCC(project, NPM);
                ICProjectDescription pd = CCorePlugin.getDefault().getProjectDescription(project, true);
                ExternalExportProjectProvider.this.newCfg(pd, project.getName(), "config");
                CoreModel.getDefault().setProjectDescription(project, pd, true, (IProgressMonitor)new NullProgressMonitor());
                for (String excludeFile : excludeFiles) {
                    FileInfoMatcherDescription matcherDescription = ExportIndexFileInfoMatcher.getDescription(excludeFile);
                    project.createFilter(26, matcherDescription, 0, NPM);
                }
                ICProject cproject = CCorePlugin.getDefault().getCoreModel().create(project);
                ExternalExportProjectProvider.this.content = project.getFolder(ExternalExportProjectProvider.CONTENT);
                ExternalExportProjectProvider.this.content.createLink((IPath)new Path(location.getAbsolutePath()), 0, null);
                ArrayList<IPathEntry> entries = new ArrayList<IPathEntry>(Arrays.asList(CoreModel.getRawPathEntries(cproject)));
                for (String path : includeFiles) {
                    entries.add(CoreModel.newIncludeFileEntry(project.getFullPath(), (IPath)new Path(path)));
                }
                entries.add(CoreModel.newSourceEntry(ExternalExportProjectProvider.this.content.getProjectRelativePath()));
                entries.addAll(ExternalExportProjectProvider.this.getAdditionalRawEntries());
                cproject.setRawPathEntries(entries.toArray(new IPathEntry[entries.size()]), (IProgressMonitor)new NullProgressMonitor());
                newProject[0] = cproject;
                IndexerPreferences.set(newProject[0].getProject(), "indexerId", "org.eclipse.cdt.core.nullindexer");
                IndexerPreferences.set(newProject[0].getProject(), "indexAllFiles", Boolean.TRUE.toString());
                IndexerPreferences.set(newProject[0].getProject(), "indexUnusedHeadersWithDefaultLang", Boolean.TRUE.toString());
            }
        }, null);
        return newProject[0];
    }

    protected List<IPathEntry> getAdditionalRawEntries() {
        ArrayList<IPathEntry> entries = new ArrayList<IPathEntry>();
        entries.add(CoreModel.newIncludeEntry(this.content.getProjectRelativePath(), null, this.content.getLocation(), true));
        return entries;
    }

    private ICConfigurationDescription newCfg(ICProjectDescription des, String project, String config) throws CoreException {
        CDefaultConfigurationData data = new CDefaultConfigurationData(String.valueOf(project) + "." + config, String.valueOf(project) + " " + config + " name", null);
        data.initEmptyData();
        return des.createConfiguration("org.eclipse.cdt.core.defaultConfigDataProvider", data);
    }

    @Override
    public IIndexLocationConverter getLocationConverter(ICProject cproject) {
        return new ResourceContainerRelativeLocationConverter((IContainer)this.content);
    }

    @Override
    public Map<String, String> getExportProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        Date now = Calendar.getInstance().getTime();
        properties.put(ORG_ECLIPSE_CDT_CORE_INDEX_EXPORT_DATESTAMP, String.valueOf(DateFormat.getDateInstance().format(now)) + " " + DateFormat.getTimeInstance().format(now));
        properties.put("org.eclipse.cdt.internal.core.index.fragment.id", this.fragmentId);
        return properties;
    }
}

