/**
 * Copyright (c) 2004-2014 Gabor Bergmann and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.runtime.rete.recipes;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Constant Recipe</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Simple node that stores constant values.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.viatra.query.runtime.rete.recipes.ConstantRecipe#getConstantValues <em>Constant Values</em>}</li>
 * </ul>
 *
 * @see org.eclipse.viatra.query.runtime.rete.recipes.RecipesPackage#getConstantRecipe()
 * @model
 * @generated
 */
public interface ConstantRecipe extends ReteNodeRecipe {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "Copyright (c) 2004-2014 Gabor Bergmann and Daniel Varro\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License v. 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-v20.html.\n\nSPDX-License-Identifier: EPL-2.0"; //$NON-NLS-1$

	/**
	 * Returns the value of the '<em><b>Constant Values</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.Object}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Stores constant values. May be empty.
	 * 
	 * TODO store constants as strings instead? (for easier serialization)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Constant Values</em>' attribute list.
	 * @see org.eclipse.viatra.query.runtime.rete.recipes.RecipesPackage#getConstantRecipe_ConstantValues()
	 * @model unique="false"
	 * @generated
	 */
	EList<Object> getConstantValues();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation" unique="false"
	 *        annotation="http://www.eclipse.org/emf/2002/GenModel body='return this.getConstantValues().size();'"
	 * @generated
	 */
	int getArity();

} // ConstantRecipe
