/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event.aspect;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.Messages;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfEventFieldAspect;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;

public final class TmfBaseAspects {
    private static final ITmfEventAspect<ITmfTimestamp> TIMESTAMP_ASPECT = new ITmfEventAspect<ITmfTimestamp>(){

        @Override
        public String getName() {
            return Messages.getMessage(Messages.AspectName_Timestamp);
        }

        @Override
        public String getHelpText() {
            return "";
        }

        @Override
        public @Nullable ITmfTimestamp resolve(ITmfEvent event) {
            return event.getTimestamp();
        }
    };
    private static final ITmfEventAspect<String> EVENT_TYPE_ASPECT = new ITmfEventAspect<String>(){

        @Override
        public String getName() {
            return Messages.getMessage(Messages.AspectName_EventType);
        }

        @Override
        public String getHelpText() {
            return Messages.getMessage(Messages.AspectHelpText_EventType);
        }

        @Override
        public @Nullable String resolve(ITmfEvent event) {
            ITmfEventType type = event.getType();
            if (type == null) {
                return null;
            }
            return type.getName();
        }
    };
    private static final TmfEventFieldAspect CONTENTS_ASPECT = new TmfEventFieldAspect(Messages.getMessage(Messages.AspectName_Contents), null, event -> event.getContent()){

        @Override
        public String getHelpText() {
            return Messages.getMessage(Messages.AspectHelpText_Contents);
        }
    };
    private static final ITmfEventAspect<String> TRACE_NAME_ASPECT = new ITmfEventAspect<String>(){

        @Override
        public String getName() {
            return Messages.getMessage(Messages.AspectName_TraceName);
        }

        @Override
        public String getHelpText() {
            return Messages.getMessage(Messages.AspectHelpText_TraceName);
        }

        @Override
        public @Nullable String resolve(ITmfEvent event) {
            return event.getTrace().getName();
        }
    };
    private static final List<ITmfEventAspect<?>> BASE_ASPECTS = ImmutableList.of(TmfBaseAspects.getTimestampAspect(), TmfBaseAspects.getEventTypeAspect(), (Object)TmfBaseAspects.getContentsAspect(), TmfBaseAspects.getTraceNameAspect());

    private TmfBaseAspects() {
    }

    public static ITmfEventAspect<ITmfTimestamp> getTimestampAspect() {
        return TIMESTAMP_ASPECT;
    }

    public static ITmfEventAspect<String> getEventTypeAspect() {
        return EVENT_TYPE_ASPECT;
    }

    public static TmfEventFieldAspect getContentsAspect() {
        return CONTENTS_ASPECT;
    }

    public static ITmfEventAspect<String> getTraceNameAspect() {
        return TRACE_NAME_ASPECT;
    }

    public static List<ITmfEventAspect<?>> getBaseAspects() {
        return BASE_ASPECTS;
    }
}

