/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.phar.wizard;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.phar.PharEntry;
import org.eclipse.php.internal.core.phar.PharFile;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;

public class PharLeveledStructureProvider
implements ILeveledImportStructureProvider {
    private PharFile tarFile;
    private PharEntry root = new PharEntry();
    private Map<PharEntry, List<PharEntry>> children;
    private Map<IPath, PharEntry> directoryEntryCache = new HashMap<IPath, PharEntry>();
    private int stripLevel;

    public PharLeveledStructureProvider(PharFile sourceFile) {
        this.tarFile = sourceFile;
        this.root.setName("/");
    }

    protected PharEntry createContainer(IPath pathname) {
        PharEntry existingEntry = this.directoryEntryCache.get(pathname);
        if (existingEntry != null) {
            return existingEntry;
        }
        PharEntry parent = pathname.segmentCount() == 1 ? this.root : this.createContainer(pathname.removeLastSegments(1));
        PharEntry newEntry = new PharEntry();
        newEntry.setName(pathname.toString());
        this.directoryEntryCache.put(pathname, newEntry);
        ArrayList childList = new ArrayList();
        this.children.put(newEntry, childList);
        List<PharEntry> parentChildList = this.children.get(parent);
        parentChildList.add(newEntry);
        return newEntry;
    }

    protected void createFile(PharEntry entry) {
        Path pathname = new Path(entry.getName());
        PharEntry parent = pathname.segmentCount() == 1 ? this.root : this.directoryEntryCache.get(pathname.removeLastSegments(1));
        List<PharEntry> childList = this.children.get(parent);
        childList.add(entry);
    }

    public List<?> getChildren(Object element) {
        if (this.children == null) {
            this.initialize();
        }
        return this.children.get(element);
    }

    public InputStream getContents(Object element) {
        try {
            return this.tarFile.getInputStream((PharEntry)element);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public String getFullPath(Object element) {
        return this.stripPath(((PharEntry)element).getName());
    }

    public String getLabel(Object element) {
        if (element.equals(this.root)) {
            return ((PharEntry)element).getName();
        }
        return this.stripPath(new Path(((PharEntry)element).getName()).lastSegment());
    }

    public Object getRoot() {
        return this.root;
    }

    public PharFile getPharFile() {
        return this.tarFile;
    }

    public boolean closeArchive() {
        try {
            this.getPharFile().close();
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)(String.valueOf(DataTransferMessages.ZipImport_couldNotClose) + this.getPharFile().getName()), (Throwable)e);
            return false;
        }
        return true;
    }

    protected void initialize() {
        this.children = new HashMap<PharEntry, List<PharEntry>>(1000);
        this.children.put(this.root, new ArrayList());
        for (PharEntry entry : this.tarFile.getPharEntryMap().values()) {
            IPath path = new Path(entry.getName()).addTrailingSeparator();
            if (entry.isDirectory()) {
                this.createContainer(path);
                continue;
            }
            int pathSegmentCount = path.segmentCount();
            if (pathSegmentCount > 1) {
                this.createContainer(path.uptoSegment(pathSegmentCount - 1));
            }
            this.createFile(entry);
        }
    }

    public boolean isFolder(Object element) {
        return ((PharEntry)element).isDirectory();
    }

    private String stripPath(String path) {
        String pathOrig = path;
        int i = 0;
        while (i < this.stripLevel) {
            int firstSep = path.indexOf(47);
            if (firstSep == 0) {
                path = path.substring(1);
                firstSep = path.indexOf(47);
            }
            if (firstSep == -1) {
                return pathOrig;
            }
            path = path.substring(firstSep);
            ++i;
        }
        return path;
    }

    public void setStrip(int level) {
        this.stripLevel = level;
    }

    public int getStrip() {
        return this.stripLevel;
    }
}

