/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.consoles.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersView;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveContainerLogCommandHandler
extends AbstractHandler {
    private IDockerConnection connection;
    private IDockerContainer container;

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        List<IDockerContainer> selectedContainers = CommandUtils.getSelectedContainers(activePart);
        if (activePart instanceof DockerContainersView) {
            this.connection = ((DockerContainersView)activePart).getConnection();
        }
        if (selectedContainers.size() != 1 || this.connection == null) {
            return null;
        }
        this.container = selectedContainers.get(0);
        IDockerContainerInfo info = this.connection.getContainerInfo(this.container.id());
        if (info.config().tty()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("delegateId", "org.eclipse.tm.terminal.connector.streams.launcher.streams");
            properties.put("tm.terminal.connector.id", "org.eclipse.tm.terminal.connector.streams.StreamsConnector");
            properties.put("title", info.name());
            ITerminalService service = TerminalServiceFactory.getService();
            service.closeConsole(properties, null);
            return null;
        }
        RunConsole rc = RunConsole.findConsole(this.container);
        if (rc != null) {
            RunConsole.removeConsole(rc);
        }
        return null;
    }
}

