/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.launchbar.core.DefaultLaunchDescriptor;
import org.eclipse.launchbar.core.ILaunchBarListener;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchConfigurationProvider;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.ILaunchDescriptorType;
import org.eclipse.launchbar.core.ILaunchObjectProvider;
import org.eclipse.launchbar.core.internal.Activator;
import org.eclipse.launchbar.core.internal.LaunchConfigProviderInfo;
import org.eclipse.launchbar.core.internal.LaunchDescriptorTypeInfo;
import org.eclipse.launchbar.core.internal.Messages;
import org.eclipse.launchbar.core.internal.Pair;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetListener;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.launch.ITargetedLaunch;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class LaunchBarManager
implements ILaunchBarManager,
ILaunchTargetListener {
    private final List<ILaunchBarListener> listeners = new LinkedList<ILaunchBarListener>();
    private final List<ILaunchObjectProvider> objectProviders = new ArrayList<ILaunchObjectProvider>();
    private final Map<String, LaunchDescriptorTypeInfo> descriptorTypes = new HashMap<String, LaunchDescriptorTypeInfo>();
    private List<LaunchDescriptorTypeInfo> orderedDescriptorTypes;
    private final Map<ILaunchDescriptorType, LaunchDescriptorTypeInfo> descriptorTypeInfo = new HashMap<ILaunchDescriptorType, LaunchDescriptorTypeInfo>();
    private final Map<String, List<LaunchConfigProviderInfo>> configProviders = new HashMap<String, List<LaunchConfigProviderInfo>>();
    private final Map<Pair<String, String>, ILaunchDescriptor> descriptors = new LinkedHashMap<Pair<String, String>, ILaunchDescriptor>();
    private final Map<Object, ILaunchDescriptor> objectDescriptorMap = new HashMap<Object, ILaunchDescriptor>();
    private ILaunchTargetManager launchTargetManager = this.getLaunchTargetManager();
    private ILaunchDescriptor activeLaunchDesc;
    private ILaunchMode activeLaunchMode;
    private ILaunchTarget activeLaunchTarget;
    private static final String PREF_ACTIVE_LAUNCH_MODE = "activeLaunchMode";
    private static final String PREF_ACTIVE_LAUNCH_TARGET = "activeLaunchTarget";
    private static final String PREF_CONFIG_DESC_ORDER = "configDescList";
    private static final String PREF_TRACK_LAUNCHES = "trackLaunches";
    boolean initialized = false;

    public LaunchBarManager() {
        this(true);
    }

    LaunchBarManager(boolean doInit) {
        this.launchTargetManager.addListener(this);
        if (doInit) {
            new Job(Messages.LaunchBarManager_0){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        LaunchBarManager.this.init();
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            }.schedule();
        }
    }

    IExtensionPoint getExtensionPoint() throws CoreException {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.launchbar.core", "launchBarContributions");
    }

    ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    ILaunchTargetManager getLaunchTargetManager() {
        return Activator.getService(ILaunchTargetManager.class);
    }

    void init() throws CoreException {
        try {
            IEclipsePreferences store = this.getPreferenceStore();
            String configDescIds = store.get(PREF_CONFIG_DESC_ORDER, "");
            this.loadExtensions();
            ILaunchManager launchManager = this.getLaunchManager();
            ILaunchConfiguration[] iLaunchConfigurationArray = launchManager.getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                this.launchConfigurationAdded(configuration);
                ++n2;
            }
            launchManager.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
            if (!configDescIds.isEmpty()) {
                String[] split = configDescIds.split(",");
                ILaunchDescriptor last = null;
                String[] stringArray = split;
                int n3 = split.length;
                int n4 = 0;
                while (n4 < n3) {
                    String id = stringArray[n4];
                    Pair<String, String> key = this.toId(id);
                    ILaunchDescriptor desc = this.descriptors.get(key);
                    if (desc != null) {
                        this.descriptors.remove(key);
                        this.descriptors.put(key, desc);
                        last = desc;
                    }
                    ++n4;
                }
                if (last != null) {
                    this.setActiveLaunchDescriptor(last);
                }
            }
            launchManager.addLaunchListener(new ILaunchListener(){

                public void launchRemoved(ILaunch launch) {
                }

                public void launchAdded(ILaunch launch) {
                    if (!LaunchBarManager.this.getPreferenceStore().getBoolean(LaunchBarManager.PREF_TRACK_LAUNCHES, true)) {
                        return;
                    }
                    ILaunchConfiguration lc = launch.getLaunchConfiguration();
                    String mode = launch.getLaunchMode();
                    ILaunchTarget target = null;
                    if (launch instanceof ITargetedLaunch) {
                        target = ((ITargetedLaunch)launch).getLaunchTarget();
                    }
                    try {
                        LaunchBarManager.this.setActive(lc, mode, target);
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                    }
                }

                public void launchChanged(ILaunch launch) {
                    ILaunchConfiguration lc = launch.getLaunchConfiguration();
                    ILaunchTarget target = null;
                    if (launch instanceof ITargetedLaunch) {
                        target = ((ITargetedLaunch)launch).getLaunchTarget();
                    }
                    if (target == null) {
                        return;
                    }
                    if (LaunchBarManager.this.launchDescriptorMatches(LaunchBarManager.this.activeLaunchDesc, lc, target)) {
                        try {
                            LaunchBarManager.this.setActiveLaunchTarget(target);
                        }
                        catch (CoreException e) {
                            Activator.log(e);
                        }
                    }
                }
            });
        }
        finally {
            this.initialized = true;
        }
        this.fireActiveLaunchDescriptorChanged();
        this.fireActiveLaunchTargetChanged();
        this.fireActiveLaunchModeChanged();
        this.fireLaunchTargetsChanged();
    }

    private void loadExtensions() throws CoreException {
        String elementName;
        IConfigurationElement element;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension extension;
        IExtension[] extensions;
        IExtensionPoint point = this.getExtensionPoint();
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n3 = extensions.length;
        int n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                element = iConfigurationElementArray[n];
                try {
                    elementName = element.getName();
                    if (elementName.equals("descriptorType")) {
                        LaunchDescriptorTypeInfo typeInfo = new LaunchDescriptorTypeInfo(element);
                        this.descriptorTypes.put(typeInfo.getId(), typeInfo);
                        if (this.configProviders.get(typeInfo.getId()) == null) {
                            this.configProviders.put(typeInfo.getId(), new ArrayList());
                        }
                    } else if (elementName.equals("configProvider")) {
                        LaunchConfigProviderInfo info = new LaunchConfigProviderInfo(element);
                        List<LaunchConfigProviderInfo> providers = this.configProviders.get(info.getDescriptorTypeId());
                        if (providers == null) {
                            providers = new ArrayList<LaunchConfigProviderInfo>();
                            this.configProviders.put(info.getDescriptorTypeId(), providers);
                        }
                        providers.add(info);
                    }
                }
                catch (Exception e) {
                    Activator.log(e);
                }
                ++n;
            }
            ++n4;
        }
        this.orderedDescriptorTypes = new ArrayList<LaunchDescriptorTypeInfo>(this.descriptorTypes.values());
        Collections.sort(this.orderedDescriptorTypes, (o1, o2) -> {
            int p2;
            int p1 = o1.getPriority();
            if (p1 < (p2 = o2.getPriority())) {
                return 1;
            }
            if (p1 > p2) {
                return -1;
            }
            return 0;
        });
        for (List<LaunchConfigProviderInfo> providers : this.configProviders.values()) {
            Collections.sort(providers, (o1, o2) -> {
                int p2;
                int p1 = o1.getPriority();
                if (p1 < (p2 = o2.getPriority())) {
                    return 1;
                }
                if (p1 > p2) {
                    return -1;
                }
                return 0;
            });
        }
        iExtensionArray = extensions;
        n3 = extensions.length;
        int n5 = 0;
        while (n5 < n3) {
            extension = iExtensionArray[n5];
            iConfigurationElementArray = extension.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                element = iConfigurationElementArray[n];
                try {
                    elementName = element.getName();
                    if (elementName.equals("objectProvider")) {
                        ILaunchObjectProvider objectProvider = (ILaunchObjectProvider)element.createExecutableExtension("class");
                        this.objectProviders.add(objectProvider);
                        objectProvider.init(this);
                    }
                }
                catch (Exception e) {
                    Activator.log(e);
                }
                ++n;
            }
            ++n5;
        }
    }

    private String toString(Pair<String, String> key) {
        return String.valueOf(key.getFirst()) + ":" + key.getSecond();
    }

    private Pair<String, String> toId(String key) {
        int i = key.indexOf(58);
        if (i < 0) {
            return null;
        }
        return new Pair<String, String>(key.substring(0, i), key.substring(i + 1));
    }

    @Override
    public String getDescriptorTypeId(ILaunchDescriptorType type) {
        return this.descriptorTypeInfo.get(type).getId();
    }

    private Pair<String, String> getDescriptorId(ILaunchDescriptor descriptor) {
        return new Pair<String, String>(this.getDescriptorTypeId(descriptor.getType()), descriptor.getName());
    }

    private Pair<String, String> getTargetId(ILaunchTarget target) {
        return new Pair<String, String>(target.getTypeId(), target.getId());
    }

    private void addDescriptor(Object launchObject, ILaunchDescriptor descriptor) throws CoreException {
        this.descriptors.put(this.getDescriptorId(descriptor), descriptor);
        this.objectDescriptorMap.put(launchObject, descriptor);
        this.setActiveLaunchDescriptor(descriptor);
    }

    @Override
    public ILaunchConfigurationType getLaunchConfigurationType(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        if (descriptor == null) {
            return null;
        }
        if (descriptor instanceof DefaultLaunchDescriptor) {
            ILaunchConfiguration config = (ILaunchConfiguration)descriptor.getAdapter(ILaunchConfiguration.class);
            return config.getType();
        }
        for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(this.getDescriptorTypeId(descriptor.getType()))) {
            ILaunchConfigurationType type;
            ILaunchConfigurationProvider provider;
            if (!providerInfo.enabled(descriptor) || !providerInfo.enabled(target) || (provider = providerInfo.getProvider()) == null || !provider.supports(descriptor, target) || (type = provider.getLaunchConfigurationType(descriptor, target)) == null) continue;
            return type;
        }
        return null;
    }

    @Override
    public ILaunchDescriptor launchObjectAdded(Object launchObject) {
        Activator.trace("launch object added " + launchObject);
        ILaunchDescriptor desc = this.objectDescriptorMap.get(launchObject);
        if (desc != null) {
            return desc;
        }
        for (LaunchDescriptorTypeInfo descriptorInfo : this.orderedDescriptorTypes) {
            try {
                if (!descriptorInfo.enabled(launchObject)) continue;
                ILaunchDescriptorType type = descriptorInfo.getType();
                this.descriptorTypeInfo.put(type, descriptorInfo);
                desc = type.getDescriptor(launchObject);
                if (desc == null) continue;
                this.addDescriptor(launchObject, desc);
                return desc;
            }
            catch (Throwable e) {
                Activator.log(e);
            }
        }
        return null;
    }

    @Override
    public void launchObjectRemoved(Object launchObject) throws CoreException {
        Activator.trace("launch object removed " + launchObject);
        ILaunchDescriptor descriptor = this.objectDescriptorMap.remove(launchObject);
        if (descriptor != null) {
            this.descriptors.remove(this.getDescriptorId(descriptor));
            if (descriptor.equals(this.activeLaunchDesc)) {
                this.setActiveLaunchDescriptor(this.getLastUsedDescriptor());
            }
            for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(this.getDescriptorTypeId(descriptor.getType()))) {
                if (!providerInfo.enabled(descriptor)) continue;
                providerInfo.getProvider().launchDescriptorRemoved(descriptor);
            }
        }
    }

    @Override
    public void launchObjectChanged(Object launchObject) throws CoreException {
        ILaunchDescriptor origDesc = this.objectDescriptorMap.get(launchObject);
        if (origDesc == null) {
            this.launchObjectAdded(launchObject);
            return;
        }
        ILaunchDescriptorType origDescType = origDesc.getType();
        try {
            ILaunchDescriptor newDesc = origDescType.getDescriptor(launchObject);
            if (newDesc == null) {
                this.objectDescriptorMap.remove(launchObject);
                this.launchObjectAdded(launchObject);
            } else if (!newDesc.equals(origDesc)) {
                this.objectDescriptorMap.put(launchObject, newDesc);
            }
        }
        catch (Throwable e) {
            Activator.log(e);
        }
    }

    private ILaunchDescriptor getLastUsedDescriptor() {
        if (this.descriptors.size() == 0) {
            return null;
        }
        ILaunchDescriptor[] descs = this.descriptors.values().toArray(new ILaunchDescriptor[this.descriptors.size()]);
        return descs[descs.length - 1];
    }

    @Override
    public ILaunchDescriptor[] getLaunchDescriptors() {
        ArrayList<ILaunchDescriptor> values = new ArrayList<ILaunchDescriptor>(this.descriptors.values());
        Collections.reverse(values);
        return values.toArray(new ILaunchDescriptor[values.size()]);
    }

    @Override
    public ILaunchDescriptor getActiveLaunchDescriptor() {
        return this.activeLaunchDesc;
    }

    private void setActive(ILaunchConfiguration config, String mode, ILaunchTarget target) throws CoreException {
        ILaunchMode[] supportedModes;
        boolean changeTarget;
        ILaunchDescriptor descriptor = this.getLaunchDescriptor(config, target);
        if (descriptor == null) {
            return;
        }
        boolean changeDesc = this.activeLaunchDesc != descriptor;
        boolean bl = changeTarget = target != null && this.activeLaunchTarget != target;
        if (changeDesc) {
            this.doSetActiveLaunchDescriptor(descriptor);
            this.storeActiveDescriptor(this.activeLaunchDesc);
        }
        if (changeTarget) {
            this.activeLaunchTarget = target;
            this.storeLaunchTarget(this.activeLaunchDesc, target);
        }
        ILaunchMode[] iLaunchModeArray = supportedModes = this.getLaunchModes();
        int n = supportedModes.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchMode launchMode = iLaunchModeArray[n2];
            if (launchMode.getIdentifier().equals(mode)) {
                this.setActiveLaunchMode(launchMode);
                break;
            }
            ++n2;
        }
        if (changeDesc) {
            this.fireActiveLaunchDescriptorChanged();
        }
        if (changeTarget) {
            this.fireActiveLaunchTargetChanged();
        }
    }

    @Override
    public void setActiveLaunchDescriptor(ILaunchDescriptor descriptor) throws CoreException {
        Activator.trace("set active descriptor " + descriptor);
        if (this.activeLaunchDesc == descriptor) {
            this.syncActiveTarget();
            this.syncActiveMode();
            Activator.trace("resync for " + descriptor);
            return;
        }
        if (descriptor != null && !this.descriptors.containsValue(descriptor)) {
            throw new IllegalStateException(Messages.LaunchBarManager_1);
        }
        if (descriptor == null) {
            descriptor = this.getLastUsedDescriptor();
        }
        this.doSetActiveLaunchDescriptor(descriptor);
        this.storeActiveDescriptor(this.activeLaunchDesc);
        this.fireActiveLaunchDescriptorChanged();
        this.syncActiveTarget();
        this.syncActiveMode();
    }

    private void doSetActiveLaunchDescriptor(ILaunchDescriptor descriptor) {
        this.activeLaunchDesc = descriptor;
        if (descriptor != null) {
            Pair<String, String> id = this.getDescriptorId(descriptor);
            this.descriptors.remove(id);
            this.descriptors.put(id, descriptor);
        }
    }

    private void storeActiveDescriptor(ILaunchDescriptor descriptor) {
        Activator.trace("new active config is stored " + descriptor);
        StringBuffer buff = new StringBuffer();
        for (Pair<String, String> key : this.descriptors.keySet()) {
            if (buff.length() > 0) {
                buff.append(',');
            }
            buff.append(this.toString(key));
        }
        this.setPreference((Preferences)this.getPreferenceStore(), PREF_CONFIG_DESC_ORDER, buff.toString());
    }

    private void syncActiveTarget() throws CoreException {
        if (this.activeLaunchDesc == null) {
            this.setActiveLaunchTarget(null);
            return;
        }
        String activeTargetId = this.getPerDescriptorStore().get(PREF_ACTIVE_LAUNCH_TARGET, null);
        if (activeTargetId != null) {
            Pair<String, String> id = this.toId(activeTargetId);
            ILaunchTarget storedTarget = this.launchTargetManager.getLaunchTarget(id.getFirst(), id.getSecond());
            if (storedTarget != null && this.supportsTarget(this.activeLaunchDesc, storedTarget)) {
                this.setActiveLaunchTarget(storedTarget);
                return;
            }
        } else if (this.activeLaunchTarget != null && this.activeLaunchTarget != ILaunchTarget.NULL_TARGET && this.supportsTarget(this.activeLaunchDesc, this.activeLaunchTarget)) {
            this.setActiveLaunchTarget(this.activeLaunchTarget);
            return;
        }
        this.setActiveLaunchTarget(this.getDefaultLaunchTarget(this.activeLaunchDesc));
    }

    private void syncActiveMode() throws CoreException {
        if (this.activeLaunchDesc == null) {
            this.setActiveLaunchMode(null);
            return;
        }
        ILaunchMode foundMode = null;
        String storedModeId = this.getPerDescriptorStore().get(PREF_ACTIVE_LAUNCH_MODE, null);
        String lastActiveModeId = this.activeLaunchMode == null ? null : this.activeLaunchMode.getIdentifier();
        ILaunchMode[] supportedModes = this.getLaunchModes();
        if (supportedModes.length > 0) {
            String[] modeNames = new String[]{storedModeId, lastActiveModeId, "run", "debug", supportedModes[0].getIdentifier()};
            int i = 0;
            while (i < modeNames.length) {
                foundMode = this.getLaunchManager().getLaunchMode(modeNames[i]);
                if (this.supportsMode(foundMode)) break;
                ++i;
            }
        }
        this.setActiveLaunchMode(foundMode);
    }

    private boolean supportsMode(ILaunchMode mode) throws CoreException {
        if (mode == null) {
            return false;
        }
        ILaunchMode[] supportedModes = this.getLaunchModes();
        int j = 0;
        while (j < supportedModes.length) {
            ILaunchMode lm = supportedModes[j];
            if (lm.equals(mode)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private void setPreference(Preferences store, String prefId, String value) {
        if (value != null) {
            store.put(prefId, value);
        } else {
            store.remove(prefId);
        }
        try {
            store.flush();
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
    }

    private Preferences getPerDescriptorStore() {
        return this.getPerDescriptorStore(this.activeLaunchDesc);
    }

    private Preferences getPerDescriptorStore(ILaunchDescriptor launchDesc) {
        String string;
        if (launchDesc == null) {
            return this.getPreferenceStore();
        }
        try {
            string = this.toString(this.getDescriptorId(launchDesc));
        }
        catch (Exception e) {
            Activator.log(e);
            string = launchDesc.getName();
        }
        return this.getPreferenceStore().node(string);
    }

    IEclipsePreferences getPreferenceStore() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.launchbar.core");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(FireAction action) {
        ArrayList<ILaunchBarListener> l;
        List<ILaunchBarListener> list = this.listeners;
        synchronized (list) {
            l = new ArrayList<ILaunchBarListener>(this.listeners);
        }
        for (ILaunchBarListener listener : l) {
            action.run(listener);
        }
    }

    private void fireActiveLaunchDescriptorChanged() {
        if (!this.initialized) {
            return;
        }
        this.fireEvent(listener -> {
            try {
                listener.activeLaunchDescriptorChanged(this.activeLaunchDesc);
            }
            catch (Exception e) {
                Activator.log(e);
            }
        });
    }

    @Override
    public ILaunchMode[] getLaunchModes() throws CoreException {
        ILaunchMode[] modes;
        ILaunchConfigurationType configType = this.getLaunchConfigurationType(this.activeLaunchDesc, this.activeLaunchTarget);
        if (configType == null) {
            return new ILaunchMode[0];
        }
        ArrayList<ILaunchMode> modeList = new ArrayList<ILaunchMode>();
        ILaunchMode[] iLaunchModeArray = modes = this.getLaunchManager().getLaunchModes();
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchMode mode = iLaunchModeArray[n2];
            if (configType.supportsMode(mode.getIdentifier())) {
                modeList.add(mode);
            }
            ++n2;
        }
        return modeList.toArray(new ILaunchMode[modeList.size()]);
    }

    @Override
    public ILaunchMode getActiveLaunchMode() {
        return this.activeLaunchMode;
    }

    public void setLaunchMode(ILaunchDescriptor desc, ILaunchMode mode) throws CoreException {
        if (desc == this.activeLaunchDesc) {
            this.setActiveLaunchMode(mode);
        } else {
            this.storeLaunchMode(desc, mode);
        }
    }

    @Override
    public void setActiveLaunchMode(ILaunchMode mode) throws CoreException {
        if (this.activeLaunchMode == mode) {
            this.fireActiveLaunchModeChanged();
            return;
        }
        if (this.activeLaunchDesc != null && mode != null && !this.supportsMode(mode)) {
            throw new IllegalStateException(Messages.LaunchBarManager_2);
        }
        this.activeLaunchMode = mode;
        this.storeLaunchMode(this.activeLaunchDesc, mode);
        this.fireActiveLaunchModeChanged();
    }

    private void fireActiveLaunchModeChanged() {
        if (!this.initialized) {
            return;
        }
        this.fireEvent(listener -> {
            try {
                listener.activeLaunchModeChanged(this.activeLaunchMode);
            }
            catch (Exception e) {
                Activator.log(e);
            }
        });
    }

    private void storeLaunchMode(ILaunchDescriptor desc, ILaunchMode mode) {
        if (mode != null) {
            this.setPreference(this.getPerDescriptorStore(desc), PREF_ACTIVE_LAUNCH_MODE, mode.getIdentifier());
        }
    }

    @Override
    public ILaunchTarget[] getLaunchTargets(ILaunchDescriptor descriptor) {
        if (descriptor == null) {
            return this.launchTargetManager.getLaunchTargets();
        }
        ArrayList<ILaunchTarget> targets = new ArrayList<ILaunchTarget>();
        ILaunchTarget[] iLaunchTargetArray = this.launchTargetManager.getLaunchTargets();
        int n = iLaunchTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchTarget target = iLaunchTargetArray[n2];
            if (this.supportsTarget(descriptor, target)) {
                targets.add(target);
            }
            ++n2;
        }
        if (this.supportsNullTarget(descriptor)) {
            targets.add(ILaunchTarget.NULL_TARGET);
        }
        return targets.toArray(new ILaunchTarget[targets.size()]);
    }

    boolean supportsTarget(ILaunchDescriptor descriptor, ILaunchTarget target) {
        String descriptorTypeId = this.getDescriptorTypeId(descriptor.getType());
        for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(descriptorTypeId)) {
            try {
                if (!providerInfo.enabled(descriptor) || !providerInfo.enabled(target) || !providerInfo.getProvider().supports(descriptor, target)) continue;
                return true;
            }
            catch (Throwable e) {
                Activator.log(e);
            }
        }
        return false;
    }

    boolean supportsNullTarget(ILaunchDescriptor descriptor) {
        String descriptorTypeId = this.getDescriptorTypeId(descriptor.getType());
        for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(descriptorTypeId)) {
            if (!providerInfo.enabled(descriptor) || !providerInfo.supportsNullTarget()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ILaunchTarget getActiveLaunchTarget() {
        return this.activeLaunchTarget;
    }

    public void setLaunchTarget(ILaunchDescriptor desc, ILaunchTarget target) throws CoreException {
        if (desc == this.activeLaunchDesc) {
            this.setActiveLaunchTarget(target);
        } else {
            this.storeLaunchTarget(desc, target);
        }
    }

    @Override
    public void setActiveLaunchTarget(ILaunchTarget target) throws CoreException {
        if (target == null) {
            target = ILaunchTarget.NULL_TARGET;
        }
        if (this.activeLaunchTarget == target) {
            return;
        }
        this.activeLaunchTarget = target;
        this.storeLaunchTarget(this.activeLaunchDesc, target);
        this.syncActiveMode();
        this.fireActiveLaunchTargetChanged();
    }

    private void storeLaunchTarget(ILaunchDescriptor desc, ILaunchTarget target) {
        if (target == null) {
            return;
        }
        this.setPreference(this.getPerDescriptorStore(desc), PREF_ACTIVE_LAUNCH_TARGET, this.toString(this.getTargetId(target)));
    }

    private void fireActiveLaunchTargetChanged() {
        if (!this.initialized) {
            return;
        }
        this.fireEvent(listener -> {
            try {
                listener.activeLaunchTargetChanged(this.activeLaunchTarget);
            }
            catch (Exception e) {
                Activator.log(e);
            }
        });
    }

    private ILaunchTarget getDefaultLaunchTarget(ILaunchDescriptor descriptor) {
        ILaunchTarget[] targets = this.getLaunchTargets(descriptor);
        return targets.length == 0 ? ILaunchTarget.NULL_TARGET : targets[targets.length - 1];
    }

    @Override
    public ILaunchConfiguration getActiveLaunchConfiguration() throws CoreException {
        ILaunchConfiguration configuration = this.getLaunchConfiguration(this.activeLaunchDesc, this.activeLaunchTarget);
        if (configuration != null) {
            this.launchTargetManager.setDefaultLaunchTarget(configuration, this.activeLaunchTarget);
        }
        return configuration;
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        if (descriptor == null) {
            return null;
        }
        if (descriptor instanceof DefaultLaunchDescriptor) {
            return (ILaunchConfiguration)descriptor.getAdapter(ILaunchConfiguration.class);
        }
        String descTypeId = this.getDescriptorTypeId(descriptor.getType());
        for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(descTypeId)) {
            try {
                ILaunchConfiguration config;
                ILaunchConfigurationProvider provider;
                if (!providerInfo.enabled(descriptor) || !providerInfo.enabled(target) || !(provider = providerInfo.getProvider()).supports(descriptor, target) || (config = provider.getLaunchConfiguration(descriptor, target)) == null) continue;
                return config;
            }
            catch (Throwable e) {
                Activator.log(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ILaunchBarListener listener) {
        if (listener == null) {
            return;
        }
        List<ILaunchBarListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ILaunchBarListener listener) {
        if (listener == null) {
            return;
        }
        ILaunchBarListener iLaunchBarListener = listener;
        synchronized (iLaunchBarListener) {
            this.listeners.remove(listener);
        }
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        for (LaunchDescriptorTypeInfo descTypeInfo : this.orderedDescriptorTypes) {
            for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(descTypeInfo.getId())) {
                try {
                    if (!providerInfo.enabled(configuration) || !providerInfo.getProvider().launchConfigurationAdded(configuration)) continue;
                    return;
                }
                catch (Throwable e) {
                    Activator.log(e);
                }
            }
        }
        this.launchObjectAdded(configuration);
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        try {
            this.launchObjectRemoved(configuration);
        }
        catch (Throwable e) {
            Activator.log(e);
        }
        for (LaunchDescriptorTypeInfo descTypeInfo : this.orderedDescriptorTypes) {
            for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(descTypeInfo.getId())) {
                try {
                    if (!providerInfo.enabled(configuration) || !providerInfo.getProvider().launchConfigurationRemoved(configuration)) continue;
                    return;
                }
                catch (Throwable e) {
                    Activator.log(e);
                }
            }
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        if (configuration.isWorkingCopy()) {
            return;
        }
        for (LaunchDescriptorTypeInfo descTypeInfo : this.orderedDescriptorTypes) {
            for (LaunchConfigProviderInfo providerInfo : this.configProviders.get(descTypeInfo.getId())) {
                try {
                    if (!providerInfo.enabled(configuration) || !providerInfo.getProvider().launchConfigurationChanged(configuration)) continue;
                    return;
                }
                catch (Throwable e) {
                    Activator.log(e);
                }
            }
        }
    }

    public void dispose() {
        ILaunchManager launchManager = this.getLaunchManager();
        launchManager.removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        for (ILaunchObjectProvider o : this.objectProviders) {
            try {
                o.dispose();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    private void fireLaunchTargetsChanged() {
        if (!this.initialized) {
            return;
        }
        this.fireEvent(listener -> {
            try {
                listener.launchTargetsChanged();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        });
    }

    @Override
    public void launchTargetAdded(ILaunchTarget target) {
        if (!this.initialized) {
            return;
        }
        this.fireLaunchTargetsChanged();
        if (this.activeLaunchDesc != null && this.supportsTarget(this.activeLaunchDesc, target)) {
            try {
                this.setActiveLaunchTarget(target);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }

    @Override
    public void launchTargetRemoved(ILaunchTarget target) {
        if (!this.initialized) {
            return;
        }
        this.fireLaunchTargetsChanged();
        if (this.activeLaunchTarget == target) {
            try {
                this.setActiveLaunchTarget(this.getDefaultLaunchTarget(this.activeLaunchDesc));
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }

    private ILaunchDescriptor getLaunchDescriptor(ILaunchConfiguration configuration, ILaunchTarget target) {
        if (this.launchDescriptorMatches(this.activeLaunchDesc, configuration, target)) {
            return this.activeLaunchDesc;
        }
        ILaunchDescriptor[] iLaunchDescriptorArray = this.getLaunchDescriptors();
        int n = iLaunchDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchDescriptor desc = iLaunchDescriptorArray[n2];
            if (this.launchDescriptorMatches(desc, configuration, target)) {
                return desc;
            }
            ++n2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean launchDescriptorMatches(ILaunchDescriptor desc, ILaunchConfiguration configuration, ILaunchTarget target) {
        if (desc == null) return false;
        if (configuration == null) {
            return false;
        }
        try {
            LaunchConfigProviderInfo providerInfo;
            String descriptorTypeId = this.getDescriptorTypeId(desc.getType());
            Iterator<LaunchConfigProviderInfo> iterator = this.configProviders.get(descriptorTypeId).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(providerInfo = iterator.next()).enabled(desc) || target != null && !providerInfo.enabled(target) || !providerInfo.getProvider().launchDescriptorMatches(desc, configuration, target));
            return true;
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return false;
    }

    private static interface FireAction {
        public void run(ILaunchBarListener var1);
    }
}

