/**
 * Copyright (c) 2016 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;

public interface IReportProcessor {

    /**
     * Called once per status. Determines whether this processor will be activated or not for the given status. Should return true only if
     * the processor will be able to process the status report.
     */
    boolean canContribute(IStatus status, IEclipseContext context);

    /**
     * Called once per status. Determines whether this processor wants to contribute to the given status. This will be presented as 'need
     * information' to the user in the same way, as if a server requested the activation of this processor.
     */
    boolean wantsToContribute(IStatus status, IEclipseContext context);

    /**
     * Repeatedly called, likely in a background process. Processor is responsible for caching its values in the context.
     */
    void process(IReport report, IStatus status, IEclipseContext context);

}
