/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.diffdata.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.diffdata.DiffdataPackage;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMapping;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.diffdata.impl.EIdentifiedImpl;
import org.eclipse.emf.diffmerge.impl.helpers.BidirectionalComparisonCopier;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FHashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class EMappingImpl
extends EIdentifiedImpl
implements EMapping {
    protected EList<EMatch> modifiableContents;
    protected EList<IMatch> referenceCompletedMatches;
    protected EList<IMatch> targetCompletedMatches;
    private final BidirectionalComparisonCopier _copier = new BidirectionalComparisonCopier();
    private final ScopeCrossReferencer _targetCrossReferencer = new ScopeCrossReferencer(Role.TARGET);
    private final ScopeCrossReferencer _referenceCrossReferencer = new ScopeCrossReferencer(Role.REFERENCE);
    private MatchCrossReferenceAdapter _matchAdapter = new MatchCrossReferenceAdapter();

    protected EMappingImpl() {
        this.eAdapters().add((Object)this._matchAdapter);
    }

    @Override
    protected EClass eStaticClass() {
        return DiffdataPackage.Literals.EMAPPING;
    }

    @Override
    public EList<EMatch> getModifiableContents() {
        if (this.modifiableContents == null) {
            this.modifiableContents = new EObjectContainmentEList(EMatch.class, (InternalEObject)this, 1);
        }
        return this.modifiableContents;
    }

    @Override
    public EList<IMatch> getReferenceCompletedMatches() {
        if (this.referenceCompletedMatches == null) {
            this.referenceCompletedMatches = new EObjectEList(IMatch.class, (InternalEObject)this, 2);
        }
        return this.referenceCompletedMatches;
    }

    @Override
    public EList<IMatch> getTargetCompletedMatches() {
        if (this.targetCompletedMatches == null) {
            this.targetCompletedMatches = new EObjectEList(IMatch.class, (InternalEObject)this, 3);
        }
        return this.targetCompletedMatches;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getModifiableContents()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getModifiableContents();
            }
            case 2: {
                return this.getReferenceCompletedMatches();
            }
            case 3: {
                return this.getTargetCompletedMatches();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getReferenceCompletedMatches().clear();
                this.getReferenceCompletedMatches().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getTargetCompletedMatches().clear();
                this.getTargetCompletedMatches().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getReferenceCompletedMatches().clear();
                return;
            }
            case 3: {
                this.getTargetCompletedMatches().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.modifiableContents != null && !this.modifiableContents.isEmpty();
            }
            case 2: {
                return this.referenceCompletedMatches != null && !this.referenceCompletedMatches.isEmpty();
            }
            case 3: {
                return this.targetCompletedMatches != null && !this.targetCompletedMatches.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void clear() {
        this.getModifiableContents().clear();
        this.getTargetCompletedMatches().clear();
        this.getReferenceCompletedMatches().clear();
        this._targetCrossReferencer.clear();
        this._referenceCrossReferencer.clear();
        this.eAdapters().remove((Object)this._matchAdapter);
        this._matchAdapter = new MatchCrossReferenceAdapter();
        this.eAdapters().add((Object)this._matchAdapter);
    }

    @Override
    public EObject completeMatch(IMatch partialMatch_p) {
        return this._copier.completeMatch(this, partialMatch_p);
    }

    @Override
    public void completeReferences(Role role_p) {
        this._copier.completeReferences(this, role_p);
    }

    @Override
    public boolean covers(EObject element_p, Role role_p) {
        return this.getMatchFor(element_p, role_p) != null;
    }

    @Override
    public void crossReference(Role role_p) {
        ScopeCrossReferencer referencer = null;
        if (role_p == Role.TARGET) {
            referencer = this._targetCrossReferencer;
        } else if (role_p == Role.REFERENCE) {
            referencer = this._referenceCrossReferencer;
        }
        if (referencer != null) {
            referencer.crossReference();
        }
    }

    @Override
    public Collection<IMatch> getCompletedMatches(Role destinationRole_p) {
        return Collections.unmodifiableCollection(this.getModifiableCompletedMatches(destinationRole_p));
    }

    @Override
    public EComparison getComparison() {
        EComparison result = null;
        EObject container = this.eContainer();
        if (container instanceof EComparison) {
            result = (EComparison)container;
        }
        return result;
    }

    @Override
    public Collection<IMatch> getContents() {
        return Collections.unmodifiableCollection(this.getModifiableContents());
    }

    @Override
    public Collection<EStructuralFeature.Setting> getCrossReferences(EObject element_p, Role role_p) {
        Collection<Object> result = null;
        ScopeCrossReferencer referencer = null;
        if (role_p == Role.TARGET) {
            referencer = this._targetCrossReferencer;
        } else if (role_p == Role.REFERENCE) {
            referencer = this._referenceCrossReferencer;
        }
        if (referencer != null) {
            result = (Collection)referencer.get(element_p);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public IMatch getMatchFor(EObject element_p, Role role_p) {
        EMatch result = null;
        if (role_p != null) {
            EReference matchReference;
            switch (role_p) {
                case ANCESTOR: {
                    matchReference = DiffdataPackage.eINSTANCE.getEMatch_Ancestor();
                    break;
                }
                case REFERENCE: {
                    matchReference = DiffdataPackage.eINSTANCE.getEMatch_Reference();
                    break;
                }
                default: {
                    matchReference = DiffdataPackage.eINSTANCE.getEMatch_Target();
                }
            }
            if (element_p != null) {
                Collection settings = this._matchAdapter.getNonNavigableInverseReferences(element_p);
                for (EStructuralFeature.Setting setting : settings) {
                    if (setting.getEStructuralFeature() != matchReference) continue;
                    result = (EMatch)setting.getEObject();
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public Collection<IMatch> getModifiableCompletedMatches(Role destinationRole_p) {
        return Role.TARGET == destinationRole_p ? this.getTargetCompletedMatches() : this.getReferenceCompletedMatches();
    }

    @Override
    public int getNbFullMatches() {
        int result = 0;
        for (IMatch match : this.getContents()) {
            if (match.isPartial()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int getNbPartialMatches(Role covered_p) {
        int result = 0;
        for (IMatch match : this.getContents()) {
            if (!match.isPartial() || covered_p != null && !match.coversRole(covered_p)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public Role getOrderingRole() {
        return Role.TARGET;
    }

    @Override
    public boolean isCompleteFor(IModelScope scope_p, Role role_p) {
        TreeIterator<EObject> it = scope_p.getAllContents();
        while (it.hasNext()) {
            EObject currentInScope = (EObject)it.next();
            if (this.covers(currentInScope, role_p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.getModifiableContents().isEmpty();
    }

    @Override
    public IMatch.Editable map(EObject element_p, Role role_p) {
        assert (element_p != null && role_p != null);
        IMatch previous = this.getMatchFor(element_p, role_p);
        if (previous != null) {
            this.getModifiableContents().remove((Object)previous);
        }
        EMatch result = (EMatch)this.getComparison().newMatch((EObject)(Role.TARGET == role_p ? element_p : null), (EObject)(Role.REFERENCE == role_p ? element_p : null), (EObject)(Role.ANCESTOR == role_p ? element_p : null));
        this.getModifiableContents().add((Object)result);
        return result;
    }

    @Override
    public boolean mapIncrementally(EObject element1_p, Role role1_p, EObject element2_p, Role role2_p) {
        IMatch found;
        assert (role1_p != null && role2_p != null && role1_p != role2_p);
        IMatch newMatch = null;
        boolean result = false;
        HashMap<Role, EObject> elements = new HashMap<Role, EObject>(3);
        elements.put(role1_p, element1_p);
        elements.put(role2_p, element2_p);
        Role role3 = Role.otherThan(role1_p, role2_p);
        EObject element3 = null;
        if (element1_p != null && (newMatch = this.getMatchFor(element1_p, role1_p)) != null) {
            element3 = newMatch.get(role3);
            EObject foundElement2 = newMatch.get(role2_p);
            boolean bl = result = foundElement2 != null && foundElement2 != element2_p;
        }
        if (element2_p != null && (found = this.getMatchFor(element2_p, role2_p)) != null) {
            EObject foundElement1 = found.get(role1_p);
            result = result || foundElement1 != null && foundElement1 != element1_p;
            EObject inRole3 = found.get(role3);
            if (inRole3 != null) {
                element3 = inRole3;
            }
            if (newMatch != null && newMatch != found) {
                this.getModifiableContents().remove((Object)found);
            } else {
                newMatch = found;
            }
        }
        elements.put(role3, element3);
        if (newMatch == null) {
            newMatch = this.getComparison().newMatch((EObject)elements.get((Object)Role.TARGET), (EObject)elements.get((Object)Role.REFERENCE), (EObject)elements.get((Object)Role.ANCESTOR));
            this.getModifiableContents().add((Object)((EMatch)newMatch));
        } else {
            ((IMatch.Editable)newMatch).reset((EObject)elements.get((Object)Role.TARGET), (EObject)elements.get((Object)Role.REFERENCE), (EObject)elements.get((Object)Role.ANCESTOR));
        }
        return result;
    }

    @Override
    public boolean maps(EObject target_p, EObject reference_p) {
        return this.maps(target_p, Role.TARGET, reference_p, Role.REFERENCE);
    }

    @Override
    public boolean maps(EObject target_p, EObject reference_p, EObject ancestor_p) {
        return this.maps(ancestor_p, Role.ANCESTOR, target_p, Role.TARGET) && this.maps(ancestor_p, Role.ANCESTOR, reference_p, Role.REFERENCE) && this.maps(target_p, Role.TARGET, reference_p, Role.REFERENCE);
    }

    @Override
    public boolean maps(EObject element1_p, Role role1_p, EObject element2_p, Role role2_p) {
        boolean result = false;
        if (element1_p != null) {
            IMatch fromElement1 = this.getMatchFor(element1_p, role1_p);
            result = fromElement1 != null && fromElement1.get(role2_p) == element2_p;
        } else if (element2_p != null) {
            IMatch fromElement2 = this.getMatchFor(element2_p, role2_p);
            result = fromElement2 != null && fromElement2.get(role1_p) == element1_p;
        }
        return result;
    }

    @Override
    public int size() {
        return this.getContents().size();
    }

    @Override
    public int size(Role role_p) {
        int result = 0;
        for (EMatch match : this.getModifiableContents()) {
            if (match.get(role_p) == null) continue;
            ++result;
        }
        return result;
    }

    @Override
    public EMap<EObject, EObject> toMap(Role keyRole_p, Role valueRole_p) {
        FHashMap result = new FHashMap();
        for (IMatch match : this.getContents()) {
            EObject key = match.get(keyRole_p);
            if (key == null) continue;
            result.put((Object)key, (Object)match.get(valueRole_p));
        }
        return ECollections.unmodifiableEMap((EMap)result);
    }

    protected static class MatchCrossReferenceAdapter
    extends ECrossReferenceAdapter {
        protected MatchCrossReferenceAdapter() {
        }

        protected boolean isIncluded(EReference reference_p) {
            return reference_p == DiffdataPackage.eINSTANCE.getEMatch_Ancestor() || reference_p == DiffdataPackage.eINSTANCE.getEMatch_Reference() || reference_p == DiffdataPackage.eINSTANCE.getEMatch_Target();
        }
    }

    protected class ScopeCrossReferencer
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = 1L;
        protected final Role _role;

        public ScopeCrossReferencer(Role role_p) {
            super(Collections.emptyList());
            this._role = role_p;
        }

        public void crossReference() {
            super.crossReference();
        }

        protected boolean crossReference(EObject element_p, EReference reference_p, EObject crossReferenced_p) {
            boolean result = false;
            IMatch referencingMatch = EMappingImpl.this.getMatchFor(element_p, this._role);
            IMatch referencedMatch = EMappingImpl.this.getMatchFor(crossReferenced_p, this._role);
            if (referencingMatch != null && referencedMatch != null) {
                result = referencingMatch.isPartial() && referencedMatch.isPartial();
            }
            return result;
        }

        protected EContentsEList.FeatureIterator<EObject> getCrossReferences(EObject eObject) {
            return new ECrossReferenceEList.FeatureIteratorImpl<EObject>(eObject){

                protected boolean isIncluded(EStructuralFeature feature_p) {
                    return super.isIncludedEntry(feature_p) && ScopeCrossReferencer.this.isIncluded((EReference)feature_p);
                }

                protected boolean resolve() {
                    return ScopeCrossReferencer.this.resolve();
                }
            };
        }

        public Role getRole() {
            return this._role;
        }

        protected boolean isIncluded(EReference reference_p) {
            return reference_p.isChangeable() && !reference_p.isDerived();
        }

        protected Collection<EStructuralFeature.Setting> newCollection() {
            return new FArrayList();
        }

        protected TreeIterator<Notifier> newContentsIterator() {
            return EMappingImpl.this.getComparison().getScope(this._role).getAllContents();
        }

        protected boolean resolve() {
            return false;
        }
    }
}

