/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference.evaluators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ruby.ast.RubyAssignment;
import org.eclipse.dltk.ruby.internal.parsers.jruby.ASTUtils;
import org.eclipse.dltk.ruby.typeinference.RubyFieldReference;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ruby.typeinference.VariableTypeGoal;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.FieldReferencesGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.goals.ItemReference;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class RubyVariableTypeEvaluator
extends GoalEvaluator {
    private List<IGoal> possibilities = new ArrayList<IGoal>();
    private List results = new ArrayList();
    private boolean init = false;

    public RubyVariableTypeEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        this.init = true;
        VariableTypeGoal goal = (VariableTypeGoal)this.goal;
        String name = goal.getName();
        String parent = goal.getParentKey();
        return new IGoal[]{new FieldReferencesGoal(goal.getContext(), name, parent)};
    }

    public Object produceResult() {
        IEvaluatedType type = RubyTypeInferencingUtils.combineTypes(this.results);
        return type;
    }

    private BasicContext buildContext(RubyFieldReference ref) {
        IModelElement element = DLTKCore.create((IResource)ref.getPosition().getResource());
        if (element instanceof ISourceModule) {
            ISourceModule sourceModule = (ISourceModule)element;
            ModuleDeclaration module = ASTUtils.getAST(sourceModule);
            return new BasicContext(sourceModule, module);
        }
        return (BasicContext)this.goal.getContext();
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (this.init) {
            this.init = false;
            if (result instanceof ItemReference[]) {
                ItemReference[] references = (ItemReference[])result;
                int i = 0;
                while (i < references.length) {
                    RubyFieldReference ref;
                    if (references[i] instanceof RubyFieldReference && (ref = (RubyFieldReference)references[i]).getNode() instanceof RubyAssignment) {
                        RubyAssignment assignment = (RubyAssignment)ref.getNode();
                        ExpressionTypeGoal s = new ExpressionTypeGoal((IContext)this.buildContext(ref), assignment.getRight());
                        this.possibilities.add((IGoal)s);
                    }
                    ++i;
                }
            }
            return this.possibilities.toArray(new IGoal[this.possibilities.size()]);
        }
        if (result != null) {
            this.results.add(result);
        }
        return null;
    }
}

