/*
 * Decompiled with CFR 0.152.
 */
package com.naef.jnlua;

import com.naef.jnlua.JavaFunction;
import com.naef.jnlua.JavaReflector;
import com.naef.jnlua.LuaRuntimeException;
import com.naef.jnlua.LuaState;
import com.naef.jnlua.LuaType;
import com.naef.jnlua.NamedJavaFunction;
import com.naef.jnlua.TypedJavaObject;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;

public class JavaModule {
    private static final JavaModule INSTANCE = new JavaModule();
    private static final Map<String, Class<?>> PRIMITIVE_TYPES = new HashMap();
    private static final NamedJavaFunction[] EMPTY_MODULE;
    private final NamedJavaFunction[] functions = new NamedJavaFunction[]{new Require(), new New(), new InstanceOf(), new Cast(), new Proxy(), new Pairs(), new IPairs(), new ToTable(), new Elements(), new Fields(), new Methods(), new Properties()};

    static {
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
        PRIMITIVE_TYPES.put("void", Void.TYPE);
        EMPTY_MODULE = new NamedJavaFunction[0];
    }

    public static JavaModule getInstance() {
        return INSTANCE;
    }

    private JavaModule() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(LuaState luaState) {
        LuaState luaState2 = luaState;
        synchronized (luaState2) {
            luaState.register("java", this.functions);
            luaState.pop(1);
        }
    }

    public TypedJavaObject toTable(Map<?, ?> map) {
        return ToTable.toTable(map);
    }

    public TypedJavaObject toTable(List<?> list) {
        return ToTable.toTable(list);
    }

    private static Class<?> loadType(LuaState luaState, String typeName) {
        Class<?> clazz = PRIMITIVE_TYPES.get(typeName);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = luaState.getClassLoader().loadClass(typeName);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Cast
    implements NamedJavaFunction {
        private Cast() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Class clazz;
            if (luaState.isJavaObject(2, Class.class)) {
                clazz = luaState.checkJavaObject(2, Class.class);
            } else {
                String className = luaState.checkString(2);
                clazz = JavaModule.loadType(luaState, className);
            }
            final Object object = luaState.checkJavaObject(1, clazz);
            luaState.pushJavaObject(new TypedJavaObject(){

                @Override
                public Object getObject() {
                    return object;
                }

                @Override
                public Class<?> getType() {
                    return clazz;
                }

                @Override
                public boolean isStrong() {
                    return false;
                }
            });
            return 1;
        }

        @Override
        public String getName() {
            return "cast";
        }
    }

    private static class Elements
    implements NamedJavaFunction {
        private Elements() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Iterable iterable = luaState.checkJavaObject(1, Iterable.class);
            luaState.pushJavaObject(new ElementIterator(iterable.iterator()));
            luaState.pushJavaObject(iterable);
            luaState.pushNil();
            return 3;
        }

        @Override
        public String getName() {
            return "elements";
        }

        private static class ElementIterator
        implements JavaFunction {
            private Iterator<?> iterator;

            public ElementIterator(Iterator<?> iterator) {
                this.iterator = iterator;
            }

            @Override
            public int invoke(LuaState luaState) {
                if (this.iterator.hasNext()) {
                    luaState.pushJavaObject(this.iterator.next());
                } else {
                    luaState.pushNil();
                }
                return 1;
            }
        }
    }

    private static class Fields
    implements NamedJavaFunction {
        private Fields() {
        }

        @Override
        public int invoke(LuaState luaState) {
            luaState.checkArg(1, luaState.isJavaObjectRaw(1), String.format("expected Java object, got %s", luaState.typeName(1)));
            JavaFunction metamethod = luaState.getMetamethod(luaState.toJavaObjectRaw(1), JavaReflector.Metamethod.JAVAFIELDS);
            return metamethod.invoke(luaState);
        }

        @Override
        public String getName() {
            return "fields";
        }
    }

    private static class IPairs
    implements NamedJavaFunction {
        private final JavaFunction listNext = new ListNext();
        private final JavaFunction arrayNext = new ArrayNext();

        private IPairs() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object;
            if (luaState.isJavaObject(1, List.class)) {
                object = luaState.toJavaObject(1, List.class);
                luaState.pushJavaFunction(this.listNext);
            } else {
                object = luaState.checkJavaObject(1, Object.class);
                luaState.checkArg(1, object.getClass().isArray(), String.format("expected list or array, got %s", luaState.typeName(1)));
                luaState.pushJavaFunction(this.arrayNext);
            }
            luaState.pushJavaObject(object);
            luaState.pushInteger(0);
            return 3;
        }

        @Override
        public String getName() {
            return "ipairs";
        }

        private static class ArrayNext
        implements JavaFunction {
            private ArrayNext() {
            }

            @Override
            public int invoke(LuaState luaState) {
                Object array = luaState.checkJavaObject(1, Object.class);
                int length = Array.getLength(array);
                int index = luaState.checkInteger(2);
                if (++index >= 1 && index <= length) {
                    luaState.pushInteger(index);
                    luaState.pushJavaObject(Array.get(array, index - 1));
                    return 2;
                }
                luaState.pushNil();
                return 1;
            }
        }

        private static class ListNext
        implements JavaFunction {
            private ListNext() {
            }

            @Override
            public int invoke(LuaState luaState) {
                List list = luaState.checkJavaObject(1, List.class);
                int size = list.size();
                int index = luaState.checkInteger(2);
                if (++index >= 1 && index <= size) {
                    luaState.pushInteger(index);
                    luaState.pushJavaObject(list.get(index - 1));
                    return 2;
                }
                luaState.pushNil();
                return 1;
            }
        }
    }

    private static class InstanceOf
    implements NamedJavaFunction {
        private InstanceOf() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Class clazz;
            Object object = luaState.checkJavaObject(1, Object.class);
            if (luaState.isJavaObject(2, Class.class)) {
                clazz = luaState.checkJavaObject(2, Class.class);
            } else {
                String className = luaState.checkString(2);
                clazz = JavaModule.loadType(luaState, className);
            }
            luaState.pushBoolean(clazz.isInstance(object));
            return 1;
        }

        @Override
        public String getName() {
            return "instanceof";
        }
    }

    private static class Methods
    implements NamedJavaFunction {
        private Methods() {
        }

        @Override
        public int invoke(LuaState luaState) {
            luaState.checkArg(1, luaState.isJavaObjectRaw(1), String.format("expected Java object, got %s", luaState.typeName(1)));
            JavaFunction metamethod = luaState.getMetamethod(luaState.toJavaObjectRaw(1), JavaReflector.Metamethod.JAVAMETHODS);
            return metamethod.invoke(luaState);
        }

        @Override
        public String getName() {
            return "methods";
        }
    }

    private static class New
    implements NamedJavaFunction {
        private New() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object;
            Class clazz;
            if (luaState.isJavaObject(1, Class.class)) {
                clazz = luaState.checkJavaObject(1, Class.class);
            } else {
                String className = luaState.checkString(1);
                clazz = JavaModule.loadType(luaState, className);
            }
            int dimensionCount = luaState.getTop() - 1;
            switch (dimensionCount) {
                case 0: {
                    try {
                        object = clazz.newInstance();
                        break;
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                case 1: {
                    object = Array.newInstance(clazz, luaState.checkInteger(2));
                    break;
                }
                default: {
                    int[] dimensions = new int[dimensionCount];
                    int i = 0;
                    while (i < dimensionCount) {
                        dimensions[i] = luaState.checkInteger(i + 2);
                        ++i;
                    }
                    object = Array.newInstance(clazz, dimensions);
                }
            }
            luaState.pushJavaObject(object);
            return 1;
        }

        @Override
        public String getName() {
            return "new";
        }
    }

    private static class Pairs
    implements NamedJavaFunction {
        private final JavaFunction navigableMapNext = new NavigableMapNext();

        private Pairs() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Map map = luaState.checkJavaObject(1, Map.class);
            luaState.checkArg(1, map != null, String.format("expected map, got %s", luaState.typeName(1)));
            if (map instanceof NavigableMap) {
                luaState.pushJavaFunction(this.navigableMapNext);
            } else {
                luaState.pushJavaFunction(new MapNext(map.entrySet().iterator()));
            }
            luaState.pushJavaObject(map);
            luaState.pushNil();
            return 3;
        }

        @Override
        public String getName() {
            return "pairs";
        }

        private static class MapNext
        implements JavaFunction {
            private Iterator<Map.Entry<Object, Object>> iterator;

            public MapNext(Iterator<Map.Entry<Object, Object>> iterator) {
                this.iterator = iterator;
            }

            @Override
            public int invoke(LuaState luaState) {
                if (this.iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = this.iterator.next();
                    luaState.pushJavaObject(entry.getKey());
                    luaState.pushJavaObject(entry.getValue());
                    return 2;
                }
                luaState.pushNil();
                return 1;
            }
        }

        private static class NavigableMapNext
        implements JavaFunction {
            private NavigableMapNext() {
            }

            @Override
            public int invoke(LuaState luaState) {
                NavigableMap navigableMap = luaState.checkJavaObject(1, NavigableMap.class);
                Object key = luaState.checkJavaObject(2, Object.class);
                Map.Entry entry = key != null ? navigableMap.higherEntry(key) : navigableMap.firstEntry();
                if (entry != null) {
                    luaState.pushJavaObject(entry.getKey());
                    luaState.pushJavaObject(entry.getValue());
                    return 2;
                }
                luaState.pushNil();
                return 1;
            }
        }
    }

    private static class Properties
    implements NamedJavaFunction {
        private Properties() {
        }

        @Override
        public int invoke(LuaState luaState) {
            luaState.checkArg(1, luaState.isJavaObjectRaw(1), String.format("expected Java object, got %s", luaState.typeName(1)));
            JavaFunction metamethod = luaState.getMetamethod(luaState.toJavaObjectRaw(1), JavaReflector.Metamethod.JAVAPROPERTIES);
            return metamethod.invoke(luaState);
        }

        @Override
        public String getName() {
            return "properties";
        }
    }

    private static class Proxy
    implements NamedJavaFunction {
        private Proxy() {
        }

        @Override
        public int invoke(LuaState luaState) {
            luaState.checkType(1, LuaType.TABLE);
            int interfaceCount = luaState.getTop() - 1;
            luaState.checkArg(2, interfaceCount > 0, "no interface specified");
            Class[] interfaces = new Class[interfaceCount];
            int i = 0;
            while (i < interfaceCount) {
                if (luaState.isJavaObject(i + 2, Class.class)) {
                    interfaces[i] = luaState.checkJavaObject(i + 2, Class.class);
                } else {
                    String interfaceName = luaState.checkString(i + 2);
                    interfaces[i] = JavaModule.loadType(luaState, interfaceName);
                }
                ++i;
            }
            luaState.pushJavaObjectRaw(luaState.getProxy(1, interfaces));
            return 1;
        }

        @Override
        public String getName() {
            return "proxy";
        }
    }

    private static class Require
    implements NamedJavaFunction {
        private Require() {
        }

        @Override
        public int invoke(LuaState luaState) {
            String className = luaState.checkString(1);
            boolean doImport = luaState.checkBoolean(2, false);
            Class clazz = JavaModule.loadType(luaState, className);
            luaState.pushJavaObject(clazz);
            if (doImport) {
                className = clazz.getName();
                int lastDotIndex = className.lastIndexOf(46);
                if (lastDotIndex >= 0) {
                    String packageName = className.substring(0, lastDotIndex);
                    className = className.substring(lastDotIndex + 1);
                    luaState.register(packageName, EMPTY_MODULE);
                    luaState.pushJavaObject(clazz);
                    luaState.setField(-2, className);
                    luaState.pop(1);
                } else {
                    luaState.pushJavaObject(clazz);
                    luaState.setGlobal(className);
                }
            }
            luaState.pushBoolean(doImport);
            return 2;
        }

        @Override
        public String getName() {
            return "require";
        }
    }

    private static class ToTable
    implements NamedJavaFunction {
        private ToTable() {
        }

        public static TypedJavaObject toTable(Map<?, ?> map) {
            return new LuaMap(map);
        }

        public static TypedJavaObject toTable(List<?> list) {
            return new LuaList(list);
        }

        @Override
        public int invoke(LuaState luaState) {
            if (luaState.isJavaObject(1, Map.class)) {
                Map map = luaState.toJavaObject(1, Map.class);
                luaState.pushJavaObject(new LuaMap(map));
            } else if (luaState.isJavaObject(1, List.class)) {
                List list = luaState.toJavaObject(1, List.class);
                luaState.pushJavaObject(new LuaList(list));
            } else {
                luaState.checkArg(1, false, String.format("expected map or list, got %s", luaState.typeName(1)));
            }
            return 1;
        }

        @Override
        public String getName() {
            return "totable";
        }

        private static class LuaList
        implements JavaReflector,
        TypedJavaObject {
            private static final JavaFunction INDEX = new Index();
            private static final JavaFunction NEW_INDEX = new NewIndex();
            private static final JavaFunction LENGTH = new Length();
            private List<Object> list;

            public LuaList(List<Object> list) {
                this.list = list;
            }

            public List<Object> getList() {
                return this.list;
            }

            @Override
            public JavaFunction getMetamethod(JavaReflector.Metamethod metamethod) {
                switch (metamethod) {
                    case INDEX: {
                        return INDEX;
                    }
                    case NEWINDEX: {
                        return NEW_INDEX;
                    }
                    case LEN: {
                        return LENGTH;
                    }
                }
                return null;
            }

            @Override
            public Object getObject() {
                return this.list;
            }

            @Override
            public Class<?> getType() {
                return List.class;
            }

            @Override
            public boolean isStrong() {
                return true;
            }

            private static class Index
            implements JavaFunction {
                private Index() {
                }

                @Override
                public int invoke(LuaState luaState) {
                    LuaList luaList = (LuaList)luaState.toJavaObjectRaw(1);
                    if (!luaState.isNumber(2)) {
                        throw new LuaRuntimeException(String.format("attempt to read list with %s accessor", luaState.typeName(2)));
                    }
                    int index = luaState.toInteger(2);
                    luaState.pushJavaObject(luaList.getList().get(index - 1));
                    return 1;
                }
            }

            private static class Length
            implements JavaFunction {
                private Length() {
                }

                @Override
                public int invoke(LuaState luaState) {
                    LuaList luaList = (LuaList)luaState.toJavaObjectRaw(1);
                    luaState.pushInteger(luaList.getList().size());
                    return 1;
                }
            }

            private static class NewIndex
            implements JavaFunction {
                private NewIndex() {
                }

                @Override
                public int invoke(LuaState luaState) {
                    LuaList luaList = (LuaList)luaState.toJavaObjectRaw(1);
                    if (!luaState.isNumber(2)) {
                        throw new LuaRuntimeException(String.format("attempt to write list with %s accessor", luaState.typeName(2)));
                    }
                    int index = luaState.toInteger(2);
                    Object value = luaState.toJavaObject(3, Object.class);
                    if (value != null) {
                        int size = luaList.getList().size();
                        if (index - 1 != size) {
                            luaList.getList().set(index - 1, value);
                        } else {
                            luaList.getList().add(value);
                        }
                    } else {
                        luaList.getList().remove(index - 1);
                    }
                    return 0;
                }
            }
        }

        private static class LuaMap
        implements JavaReflector,
        TypedJavaObject {
            private static final JavaFunction INDEX = new Index();
            private static final JavaFunction NEW_INDEX = new NewIndex();
            private Map<Object, Object> map;

            public LuaMap(Map<Object, Object> map) {
                this.map = map;
            }

            public Map<Object, Object> getMap() {
                return this.map;
            }

            @Override
            public JavaFunction getMetamethod(JavaReflector.Metamethod metamethod) {
                switch (metamethod) {
                    case INDEX: {
                        return INDEX;
                    }
                    case NEWINDEX: {
                        return NEW_INDEX;
                    }
                }
                return null;
            }

            @Override
            public Object getObject() {
                return this.map;
            }

            @Override
            public Class<?> getType() {
                return Map.class;
            }

            @Override
            public boolean isStrong() {
                return true;
            }

            private static class Index
            implements JavaFunction {
                private Index() {
                }

                @Override
                public int invoke(LuaState luaState) {
                    LuaMap luaMap = (LuaMap)luaState.toJavaObjectRaw(1);
                    Object key = luaState.toJavaObject(2, Object.class);
                    if (key == null) {
                        throw new LuaRuntimeException(String.format("attempt to read map with %s accessor", luaState.typeName(2)));
                    }
                    luaState.pushJavaObject(luaMap.getMap().get(key));
                    return 1;
                }
            }

            private static class NewIndex
            implements JavaFunction {
                private NewIndex() {
                }

                @Override
                public int invoke(LuaState luaState) {
                    LuaMap luaMap = (LuaMap)luaState.toJavaObjectRaw(1);
                    Object key = luaState.toJavaObject(2, Object.class);
                    if (key == null) {
                        throw new LuaRuntimeException(String.format("attempt to write map with %s accessor", luaState.typeName(2)));
                    }
                    Object value = luaState.toJavaObject(3, Object.class);
                    if (value != null) {
                        luaMap.getMap().put(key, value);
                    } else {
                        luaMap.getMap().remove(key);
                    }
                    return 0;
                }
            }
        }
    }
}

