/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.session;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.session.CDOSession;

public class CDORetryExceptionHandler
implements CDOSession.ExceptionHandler {
    public static final int RETRY_FOREVER = -1;
    private int retries;

    public CDORetryExceptionHandler(int retries) {
        this.retries = retries;
    }

    public CDORetryExceptionHandler() {
        this(-1);
    }

    public int getRetries() {
        return this.retries;
    }

    public boolean isRetryingForever() {
        return this.retries < 0;
    }

    public void handleException(CDOSession session, int attempt, Exception exception) throws Exception {
        int max;
        int n = max = this.isRetryingForever() ? Integer.MAX_VALUE : this.retries;
        if (attempt > max) {
            throw exception;
        }
    }

    public String toString() {
        String arg = this.isRetryingForever() ? "forever" : Integer.valueOf(this.retries);
        return MessageFormat.format("CDORetryExceptionHandler[retries={0}]", arg);
    }
}

