export declare enum MessageFormat {
    file = "file",
    bundle = "bundle",
    both = "both",
}
export interface Options {
    locale?: string;
    cacheLanguageResolution?: boolean;
    messageFormat?: MessageFormat;
}
export interface LocalizeInfo {
    key: string;
    comment: string[];
}
export interface LocalizeFunc {
    (info: LocalizeInfo, message: string, ...args: any[]): string;
    (key: string, message: string, ...args: any[]): string;
}
export interface LoadFunc {
    (file?: string): LocalizeFunc;
}
export declare type KeyInfo = string | LocalizeInfo;
export declare function loadMessageBundle(file?: string): LocalizeFunc;
export declare function config(opts?: Options): LoadFunc;
