/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.tests.initialize;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.pmf.pim.transformation.CodeGenContext;
import org.eclipse.pmf.pim.transformation.ResourceResolver;
import org.eclipse.pmf.pim.transformation.TransformationFactory;
import org.eclipse.pmf.pim.transformation.TransformationPackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CodeGenContextTest {
    private CodeGenContext codegenContext;
    private ResourceResolver resolver1;
    private ResourceResolver resolver2;
    private ResourceResolver resolver3;

    @Before
    public void setUp() throws Exception {
        this.codegenContext = TransformationFactory.eINSTANCE.createCodeGenContext();
        this.codegenContext.getCommandMap().put((Object)"cg.cmd", (Object)"cg.cmd.type");
        this.codegenContext.getDataConverterMap().put((Object)"cg.dataconvert", (Object)"cg.dataconvert.type");
        this.codegenContext.getSystemActionMap().put((Object)"cg.action", (Object)"cg.action.type");
        this.codegenContext.getValidatorMap().put((Object)"cg.validator", (Object)"cg.validator.type");
        this.codegenContext.getViewProfileMap().put((Object)"cg.profile", (Object)"cg.profile.type");
        this.resolver1 = TransformationFactory.eINSTANCE.createResourceResolver();
        this.resolver1.getCommandMap().put((Object)"r1.cmd", (Object)"r1.cmd.type");
        this.resolver1.getDataConverterMap().put((Object)"r1.dataconvert", (Object)"r1.dataconvert.type");
        this.resolver1.getSystemActionMap().put((Object)"r1.action", (Object)"r1.action.type");
        this.resolver1.getValidatorMap().put((Object)"r1.validator", (Object)"r1.validator.type");
        this.resolver1.getViewProfileMap().put((Object)"r1.profile", (Object)"r1.profile.type");
        this.resolver2 = TransformationFactory.eINSTANCE.createResourceResolver();
        this.resolver2.getCommandMap().put((Object)"r2.cmd", (Object)"r2.cmd.type");
        this.resolver2.getDataConverterMap().put((Object)"r2.dataconvert", (Object)"r2.dataconvert.type");
        this.resolver2.getSystemActionMap().put((Object)"r2.action", (Object)"r2.action.type");
        this.resolver2.getValidatorMap().put((Object)"r2.validator", (Object)"r2.validator.type");
        this.resolver2.getViewProfileMap().put((Object)"r2.profile", (Object)"r2.profile.type");
        this.resolver3 = TransformationFactory.eINSTANCE.createResourceResolver();
        this.resolver3.getCommandMap().put((Object)"r3.cmd", (Object)"r3.cmd.type");
        this.resolver3.getDataConverterMap().put((Object)"r3.dataconvert", (Object)"r3.dataconvert.type");
        this.resolver3.getSystemActionMap().put((Object)"r3.action", (Object)"r3.action.type");
        this.resolver3.getValidatorMap().put((Object)"r3.validator", (Object)"r3.validator.type");
        this.resolver3.getViewProfileMap().put((Object)"r3.profile", (Object)"r3.profile.type");
    }

    @Test
    public void testResolverSelfDynamicAdd() {
        this.codegenContext.getResourceResolvers().add((Object)this.resolver1);
        this.doValidateApplication(this.resolver1, true);
        this.codegenContext.getCommandMap().put((Object)"cmd1", (Object)"cmd.type");
        this.doValidateApplication((ResourceResolver)this.codegenContext, true);
        this.codegenContext.getDataConverterMap().put((Object)"datacvt1", (Object)"datacvt.type");
        this.doValidateApplication((ResourceResolver)this.codegenContext, true);
        this.codegenContext.getSystemActionMap().put((Object)"sysaction", (Object)"sysaction.type");
        this.doValidateApplication((ResourceResolver)this.codegenContext, true);
        this.codegenContext.getValidatorMap().put((Object)"validator", (Object)"validator.type");
        this.doValidateApplication((ResourceResolver)this.codegenContext, true);
        this.codegenContext.getViewProfileMap().put((Object)"viewprofile", (Object)"viewprofile.type");
        this.doValidateApplication((ResourceResolver)this.codegenContext, true);
    }

    @Test
    public void testResolverSelfDynamicRemove() {
        String prefix = "selfDynamicRemove";
        this.codegenContext.getResourceResolvers().add((Object)this.resolver1);
        this.doValidateApplication(this.resolver1, true);
        this.codegenContext.getCommandMap().put((Object)(String.valueOf(prefix) + "cmd"), (Object)(String.valueOf(prefix) + "cmd.type"));
        this.doValidateApplication((ResourceResolver)this.codegenContext, true);
        this.codegenContext.getCommandMap().removeKey((Object)(String.valueOf(prefix) + "cmd"));
        Assert.assertTrue((String)"Converter removed from codegenContext", (!this.codegenContext.getAllCommandMap().containsKey((Object)(String.valueOf(prefix) + "cmd")) ? 1 : 0) != 0);
        this.codegenContext.getDataConverterMap().put((Object)(String.valueOf(prefix) + "dataconverter"), (Object)(String.valueOf(prefix) + "dataconverter.type"));
        this.doValidateApplication((ResourceResolver)this.codegenContext, true);
        this.codegenContext.getDataConverterMap().removeKey((Object)(String.valueOf(prefix) + "dataconverter"));
        Assert.assertTrue((String)"Converter removed from codegenContext", (!this.codegenContext.getAllDataConverterMap().containsKey((Object)(String.valueOf(prefix) + "dataconverter")) ? 1 : 0) != 0);
        this.codegenContext.getSystemActionMap().put((Object)(String.valueOf(prefix) + "sysaction"), (Object)(String.valueOf(prefix) + "sysaction.type"));
        this.doValidateApplication((ResourceResolver)this.codegenContext, true);
        this.codegenContext.getSystemActionMap().removeKey((Object)(String.valueOf(prefix) + "sysaction"));
        Assert.assertTrue((String)"SystemAction removed from codegenContext", (!this.codegenContext.getAllSystemActionMap().containsKey((Object)(String.valueOf(prefix) + "sysaction")) ? 1 : 0) != 0);
        this.codegenContext.getValidatorMap().put((Object)(String.valueOf(prefix) + "validator"), (Object)(String.valueOf(prefix) + "validator.type"));
        this.doValidateApplication((ResourceResolver)this.codegenContext, true);
        this.codegenContext.getValidatorMap().removeKey((Object)(String.valueOf(prefix) + "validator"));
        Assert.assertTrue((String)"Validator removed from codegenContext", (!this.codegenContext.getAllValidatorMap().containsKey((Object)(String.valueOf(prefix) + "validator")) ? 1 : 0) != 0);
        this.codegenContext.getViewProfileMap().put((Object)(String.valueOf(prefix) + "profile"), (Object)(String.valueOf(prefix) + "profile.type"));
        this.doValidateApplication((ResourceResolver)this.codegenContext, true);
        this.codegenContext.getViewProfileMap().removeKey((Object)(String.valueOf(prefix) + "profile"));
        Assert.assertTrue((String)"ViewProfile removed from codegenContext", (!this.codegenContext.getAllViewProfileMap().containsKey((Object)(String.valueOf(prefix) + "profile")) ? 1 : 0) != 0);
    }

    @Test
    public void testAddResolver() {
        this.doValidateApplication(this.resolver1, false);
        this.codegenContext.getResourceResolvers().add((Object)this.resolver1);
        this.doValidateApplication(this.resolver1, true);
        this.doValidateApplication(this.resolver2, false);
        this.codegenContext.getResourceResolvers().add((Object)this.resolver2);
        this.doValidateApplication(this.resolver1, true);
        this.doValidateApplication(this.resolver2, true);
        this.doValidateApplication(this.resolver3, false);
        this.codegenContext.getResourceResolvers().add((Object)this.resolver3);
        this.doValidateApplication(this.resolver1, true);
        this.doValidateApplication(this.resolver2, true);
        this.doValidateApplication(this.resolver3, true);
    }

    private void doValidateApplication(ResourceResolver resolver, boolean contains) {
        Assert.assertNotNull((String)"codegenContext", (Object)this.codegenContext);
        Assert.assertNotNull((String)"resolver", (Object)resolver);
        EMap commands = resolver.getCommandMap();
        EMap converters = resolver.getDataConverterMap();
        EMap systemActions = resolver.getSystemActionMap();
        EMap validators = resolver.getValidatorMap();
        EMap viewProfiles = resolver.getViewProfileMap();
        if (contains) {
            for (String cmd : commands.keySet()) {
                if (this.codegenContext.getAllCommandMap().containsKey((Object)cmd)) continue;
                Assert.fail((String)"Command of ResourceResover should be added from CodeGenContext");
            }
            for (String cvt : converters.keySet()) {
                if (this.codegenContext.getAllDataConverterMap().containsKey((Object)cvt)) continue;
                Assert.fail((String)"DataConverter of ResourceResover should be added from CodeGenContext");
            }
            for (String obj : systemActions.keySet()) {
                if (this.codegenContext.getAllSystemActionMap().containsKey((Object)obj)) continue;
                Assert.fail((String)"SystemAction of ResourceResover should be added from CodeGenContext");
            }
            for (String obj : validators.keySet()) {
                if (this.codegenContext.getAllValidatorMap().containsKey((Object)obj)) continue;
                Assert.fail((String)"Validator of ResourceResover should be added from CodeGenContext");
            }
            for (String obj : viewProfiles.keySet()) {
                if (this.codegenContext.getAllViewProfileMap().containsKey((Object)obj)) continue;
                Assert.fail((String)"ViewProfile of ResourceResover should be added from CodeGenContext");
            }
        } else {
            for (String cmd : commands.keySet()) {
                if (!this.codegenContext.getAllCommandMap().containsKey((Object)cmd)) continue;
                Assert.fail((String)"Command of ResourceResover should be removed from CodeGenContext");
            }
            for (String cvt : converters.keySet()) {
                if (!this.codegenContext.getAllDataConverterMap().containsKey((Object)cvt)) continue;
                Assert.fail((String)"DataConverter of ResourceResover should be removed from CodeGenContext");
            }
            for (String obj : systemActions.keySet()) {
                if (!this.codegenContext.getAllSystemActionMap().containsKey((Object)obj)) continue;
                Assert.fail((String)"SystemAction of ResourceResover should be removed from CodeGenContext");
            }
            for (String obj : validators.keySet()) {
                if (!this.codegenContext.getAllValidatorMap().containsKey((Object)obj)) continue;
                Assert.fail((String)"Validator of ResourceResover should be removed from CodeGenContext");
            }
            for (String obj : viewProfiles.keySet()) {
                if (!this.codegenContext.getAllViewProfileMap().containsKey((Object)obj)) continue;
                Assert.fail((String)"ViewProfile of ResourceResover should be removed from CodeGenContext");
            }
        }
    }

    @Test
    public void test_eSetLibraries() {
        ArrayList<ResourceResolver> resolvers = new ArrayList<ResourceResolver>();
        resolvers.add(this.resolver1);
        resolvers.add(this.resolver2);
        resolvers.add(this.resolver3);
        this.codegenContext.eSet((EStructuralFeature)TransformationPackage.eINSTANCE.getCodeGenContext_ResourceResolvers(), resolvers);
        this.doValidateApplication(this.resolver1, true);
        this.doValidateApplication(this.resolver2, true);
        this.doValidateApplication(this.resolver3, true);
        this.codegenContext.eSet((EStructuralFeature)TransformationPackage.eINSTANCE.getCodeGenContext_ResourceResolvers(), new ArrayList());
        this.doValidateApplication(this.resolver1, false);
        this.doValidateApplication(this.resolver2, false);
        this.doValidateApplication(this.resolver3, false);
    }

    @Test
    public void testRemoveResolver() {
        this.codegenContext.getResourceResolvers().add((Object)this.resolver1);
        this.doValidateApplication(this.resolver1, true);
        this.codegenContext.getResourceResolvers().remove((Object)this.resolver1);
        this.doValidateApplication(this.resolver1, false);
        this.codegenContext.getResourceResolvers().add((Object)this.resolver2);
        this.doValidateApplication(this.resolver2, true);
        this.codegenContext.getResourceResolvers().remove((Object)this.resolver2);
        this.doValidateApplication(this.resolver2, false);
        this.codegenContext.getResourceResolvers().add((Object)this.resolver3);
        this.doValidateApplication(this.resolver3, true);
        this.codegenContext.getResourceResolvers().remove((Object)this.resolver3);
        this.doValidateApplication(this.resolver3, false);
    }

    @Test
    public void testResolverDynamicAdd() {
        this.codegenContext.getResourceResolvers().add((Object)this.resolver1);
        this.doValidateApplication(this.resolver1, true);
        this.resolver1.getCommandMap().put((Object)"cmd1", (Object)"cmd.type");
        this.doValidateApplication(this.resolver1, true);
        this.resolver1.getDataConverterMap().put((Object)"datacvt1", (Object)"datacvt.type");
        this.doValidateApplication(this.resolver1, true);
        this.resolver1.getSystemActionMap().put((Object)"sysaction", (Object)"sysaction.type");
        this.doValidateApplication(this.resolver1, true);
        this.resolver1.getValidatorMap().put((Object)"validator", (Object)"validator.type");
        this.doValidateApplication(this.resolver1, true);
        this.resolver1.getViewProfileMap().put((Object)"viewprofile", (Object)"viewprofile.type");
        this.doValidateApplication(this.resolver1, true);
    }

    @Test
    public void testResolverDynamicRemove() {
        String prefix = "dynamicRemove";
        this.codegenContext.getResourceResolvers().add((Object)this.resolver1);
        this.doValidateApplication(this.resolver1, true);
        this.resolver1.getCommandMap().put((Object)(String.valueOf(prefix) + "cmd"), (Object)(String.valueOf(prefix) + "cmd.type"));
        this.doValidateApplication(this.resolver1, true);
        this.resolver1.getCommandMap().removeKey((Object)(String.valueOf(prefix) + "cmd"));
        Assert.assertTrue((String)"Converter removed from codegenContext", (!this.codegenContext.getAllCommandMap().containsKey((Object)(String.valueOf(prefix) + "cmd")) ? 1 : 0) != 0);
        this.resolver1.getDataConverterMap().put((Object)(String.valueOf(prefix) + "dataconverter"), (Object)(String.valueOf(prefix) + "dataconverter.type"));
        this.doValidateApplication(this.resolver1, true);
        this.resolver1.getDataConverterMap().removeKey((Object)(String.valueOf(prefix) + "dataconverter"));
        Assert.assertTrue((String)"Converter removed from codegenContext", (!this.codegenContext.getAllDataConverterMap().containsKey((Object)(String.valueOf(prefix) + "dataconverter")) ? 1 : 0) != 0);
        this.resolver1.getSystemActionMap().put((Object)(String.valueOf(prefix) + "sysaction"), (Object)(String.valueOf(prefix) + "sysaction.type"));
        this.doValidateApplication(this.resolver1, true);
        this.resolver1.getSystemActionMap().removeKey((Object)(String.valueOf(prefix) + "sysaction"));
        Assert.assertTrue((String)"SystemAction removed from codegenContext", (!this.codegenContext.getAllSystemActionMap().containsKey((Object)(String.valueOf(prefix) + "sysaction")) ? 1 : 0) != 0);
        this.resolver1.getValidatorMap().put((Object)(String.valueOf(prefix) + "validator"), (Object)(String.valueOf(prefix) + "validator.type"));
        this.doValidateApplication(this.resolver1, true);
        this.resolver1.getValidatorMap().removeKey((Object)(String.valueOf(prefix) + "validator"));
        Assert.assertTrue((String)"Validator removed from codegenContext", (!this.codegenContext.getAllValidatorMap().containsKey((Object)(String.valueOf(prefix) + "validator")) ? 1 : 0) != 0);
        this.resolver1.getViewProfileMap().put((Object)(String.valueOf(prefix) + "profile"), (Object)(String.valueOf(prefix) + "profile.type"));
        this.doValidateApplication(this.resolver1, true);
        this.resolver1.getViewProfileMap().removeKey((Object)(String.valueOf(prefix) + "profile"));
        Assert.assertTrue((String)"ViewProfile removed from codegenContext", (!this.codegenContext.getAllViewProfileMap().containsKey((Object)(String.valueOf(prefix) + "profile")) ? 1 : 0) != 0);
    }

    @Test
    public void testResolverForbiddenAdd() {
        String prefix = "forbiddenAdd";
        try {
            this.codegenContext.getAllCommandMap().put((Object)(String.valueOf(prefix) + "cmd"), (Object)(String.valueOf(prefix) + "cmd.type"));
            Assert.fail((String)"Possible to add in AllCommands");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.codegenContext.getAllDataConverterMap().put((Object)(String.valueOf(prefix) + "data.converter"), (Object)(String.valueOf(prefix) + "data.converter.type"));
            Assert.fail((String)"Possible to add in AllDataConverters");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.codegenContext.getAllSystemActionMap().put((Object)(String.valueOf(prefix) + "action"), (Object)(String.valueOf(prefix) + "action.type"));
            Assert.fail((String)"Possible to add in AllSystemActions");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.codegenContext.getAllValidatorMap().put((Object)(String.valueOf(prefix) + "validator"), (Object)(String.valueOf(prefix) + "validator.type"));
            Assert.fail((String)"Possible to add in AllValidators");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.codegenContext.getAllViewProfileMap().put((Object)(String.valueOf(prefix) + "profile"), (Object)(String.valueOf(prefix) + "profile.type"));
            Assert.fail((String)"Possible to add in AllViewProfiles");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testResolverForbiddenRemove() {
        String prefix = "forbiddenAdd";
        try {
            this.codegenContext.getCommandMap().put((Object)(String.valueOf(prefix) + "cmd"), (Object)(String.valueOf(prefix) + "cmd.type"));
            this.codegenContext.getAllCommandMap().removeKey((Object)(String.valueOf(prefix) + "cmd"));
            Assert.fail((String)"Possible to remove in AllCommands");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.codegenContext.getDataConverterMap().put((Object)(String.valueOf(prefix) + "data.converter"), (Object)(String.valueOf(prefix) + "data.converter.type"));
            this.codegenContext.getAllDataConverterMap().removeKey((Object)(String.valueOf(prefix) + "data.converter"));
            Assert.fail((String)"Possible to remove in AllDataConverters");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.codegenContext.getSystemActionMap().put((Object)(String.valueOf(prefix) + "action"), (Object)(String.valueOf(prefix) + "action.type"));
            this.codegenContext.getAllSystemActionMap().removeKey((Object)(String.valueOf(prefix) + "action"));
            Assert.fail((String)"Possible to remove in AllSystemActions");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.codegenContext.getValidatorMap().put((Object)(String.valueOf(prefix) + "validator"), (Object)(String.valueOf(prefix) + "validator.type"));
            this.codegenContext.getAllValidatorMap().removeKey((Object)(String.valueOf(prefix) + "validator"));
            Assert.fail((String)"Possible to remove in AllValidators");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.codegenContext.getViewProfileMap().put((Object)(String.valueOf(prefix) + "profile"), (Object)(String.valueOf(prefix) + "profile.type"));
            this.codegenContext.getAllViewProfileMap().removeKey((Object)(String.valueOf(prefix) + "profile"));
            Assert.fail((String)"Possible to remove in AllViewProfiles");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testResolverForbiddenClear() {
        String prefix = "forbiddenAdd";
        try {
            this.codegenContext.getCommandMap().put((Object)(String.valueOf(prefix) + "cmd"), (Object)(String.valueOf(prefix) + "cmd.type"));
            this.codegenContext.getAllCommandMap().clear();
            Assert.fail((String)"Possible to remove in AllCommands");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.codegenContext.getDataConverterMap().put((Object)(String.valueOf(prefix) + "data.converter"), (Object)(String.valueOf(prefix) + "data.converter.type"));
            this.codegenContext.getAllDataConverterMap().clear();
            Assert.fail((String)"Possible to remove in AllDataConverters");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.codegenContext.getSystemActionMap().put((Object)(String.valueOf(prefix) + "action"), (Object)(String.valueOf(prefix) + "action.type"));
            this.codegenContext.getAllSystemActionMap().clear();
            Assert.fail((String)"Possible to remove in AllSystemActions");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.codegenContext.getValidatorMap().put((Object)(String.valueOf(prefix) + "validator"), (Object)(String.valueOf(prefix) + "validator.type"));
            this.codegenContext.getAllValidatorMap().clear();
            Assert.fail((String)"Possible to remove in AllValidators");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.codegenContext.getViewProfileMap().put((Object)(String.valueOf(prefix) + "profile"), (Object)(String.valueOf(prefix) + "profile.type"));
            this.codegenContext.getAllViewProfileMap().clear();
            Assert.fail((String)"Possible to remove in AllViewProfiles");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

