/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.support.lua51.internal.interpreter;

import com.naef.jnlua.LuaState;
import com.naef.jnlua.NamedJavaFunction;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;

public final class TransportLayerModule {
    private TransportLayerModule() {
    }

    public static final void registerModelFactory(LuaState l) {
        NamedJavaFunction[] namedJavaFunctions = TransportLayerModule.createFunctions();
        l.register("debugger.transport.javasocket", namedJavaFunctions);
        l.pop(1);
    }

    private static NamedJavaFunction[] createFunctions() {
        ArrayList<NamedJavaFunction> javaFunctions = new ArrayList<NamedJavaFunction>();
        javaFunctions.add(TransportLayerModule.create());
        javaFunctions.add(TransportLayerModule.sleep());
        javaFunctions.add(TransportLayerModule.rawb64());
        javaFunctions.add(TransportLayerModule.b64());
        javaFunctions.add(TransportLayerModule.unb64());
        return javaFunctions.toArray(new NamedJavaFunction[javaFunctions.size()]);
    }

    private static NamedJavaFunction create() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                SocketWrapper socketWrapper = new SocketWrapper();
                l.pushJavaObject((Object)socketWrapper);
                return 1;
            }

            public String getName() {
                return "create";
            }
        };
    }

    private static NamedJavaFunction sleep() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                double timeInSeconds = l.checkInteger(1);
                int timeInMillis = (int)(timeInSeconds * 1000.0);
                try {
                    Thread.sleep(timeInMillis);
                }
                catch (InterruptedException e) {
                    l.pushNil();
                    l.pushString(e.getMessage());
                    return 2;
                }
                return 0;
            }

            public String getName() {
                return "sleep";
            }
        };
    }

    private static NamedJavaFunction rawb64() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                String string = l.checkString(1);
                byte[] resultb64 = Base64.encodeBase64((byte[])string.getBytes());
                String b64String = new String(resultb64);
                l.pushString(b64String);
                return 1;
            }

            public String getName() {
                return "rawb64";
            }
        };
    }

    private static NamedJavaFunction b64() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                String string = l.checkString(1);
                byte[] b64Result = Base64.encodeBase64Chunked((byte[])string.getBytes());
                String b64String = new String(b64Result);
                l.pushString(b64String);
                return 1;
            }

            public String getName() {
                return "b64";
            }
        };
    }

    private static NamedJavaFunction unb64() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                String b64String = l.checkString(1);
                byte[] result = Base64.decodeBase64((byte[])b64String.getBytes());
                String string = new String(result);
                l.pushString(string);
                return 1;
            }

            public String getName() {
                return "unb64";
            }
        };
    }

    public static class SocketWrapper {
        private final Socket socket = new Socket();

        public void connect(String host, int port) throws IOException {
            this.socket.connect(new InetSocketAddress(host, port));
        }

        public Object receive() throws IOException {
            byte readByte = (byte)this.socket.getInputStream().read();
            if (readByte == 0) {
                return "";
            }
            if (readByte == -1) {
                return null;
            }
            return new String(new byte[]{readByte});
        }

        public void send(String data) throws IOException {
            if (data.isEmpty()) {
                this.socket.getOutputStream().write(0);
            } else {
                this.socket.getOutputStream().write(data.getBytes());
            }
        }

        public void close() throws IOException {
            this.socket.close();
        }

        public void settimeout(Integer sec) throws SocketException {
            if (sec == null) {
                this.socket.setSoTimeout(0);
            } else if (sec == 0) {
                this.socket.setSoTimeout(1);
            } else {
                this.socket.setSoTimeout(sec * 1000);
            }
        }
    }
}

