/*******************************************************************************
 * Copyright (c) 2004, 2010 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.client.ui.rcp.handlers.open;

import java.util.Iterator;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.constants.ContextHelpIds;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.TestCaseTreeDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.SWT;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;


/**
 * @author BREDEX GmbH
 * @created Sep 15, 2010
 */
public class OpenTestCase extends AbstractOpenHandler {
    /**
     * {@inheritDoc}
     */
    public Object executeImpl(ExecutionEvent event) {
        ISelectionListener listener = new ISelectionListener() {
            public void selectionChanged(IWorkbenchPart part,
                    ISelection selection) {
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                Iterator iter = ((IStructuredSelection)selection).iterator();
                while (iter.hasNext()) {
                    ISpecTestCasePO specTcToOpen = (ISpecTestCasePO)iter.next();
                    openEditorForSpecTC(specTcToOpen);
                }
            }
        };

        TestCaseTreeDialog dialog = new TestCaseTreeDialog(
                getActiveShell(),
                Messages.OpenTestCaseTableDialogTitle,
                Messages.OpenTestCaseTableDialogMessage,
                null,
                Messages.OpenTestCaseTableDialogShellTitle,
                SWT.MULTI, IconConstants.OPEN_TC_DIALOG_IMAGE,
                Messages.OpenTestCaseTableDialogAddButtonText);
        dialog.setReuseds(false);
        dialog.addSelectionListener(listener);
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog(dialog);
        Plugin.getHelpSystem().setHelp(dialog.getShell(),
                ContextHelpIds.OPEN_EXISTING_TESTCASE);
        dialog.open();
        dialog.removeSelectionListener(listener);
        return null;
    }
}
