/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.filters;

import javax.inject.Inject;
import javax.inject.Named;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.ReviewDialog;
import org.eclipse.jdt.annotation.Nullable;

import com.google.common.base.Predicate;

// Note: Users should make sure that this filter is the last one b/c it determines acceptance only based on the queue size and review dialog state
public class QueueSizeLimitFilter implements Predicate<IStatus> {

    private ILogEventsQueue queue;
    private int max;
    private boolean reviewIsInProgress;

    @Inject
    public QueueSizeLimitFilter(ILogEventsQueue queue, int max) {
        this.queue = queue;
        this.max = max;
    }

    @Override
    public boolean apply(@Nullable IStatus input) {
        EList<ILogEventGroup> groups = queue.getGroups();
        boolean sizeLimitIsReached = groups.size() >= max;
        if (sizeLimitIsReached) {
            if (reviewIsInProgress) {
                // then do not accept this event
                return false;
            } else {
                // just add the new one and remove the old one.
                groups.remove(0);
                return true;
            }
        } else {
            return true;
        }
    }

    @Inject
    protected void setReviewInProgress(@Named(ReviewDialog.CTX_STATE_REVIEW_IN_PROGRESS) boolean newState) {
        reviewIsInProgress = newState;
    }
}
