/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets.styles;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class EEFFont {
    private static final String KEY_PREFIX = String.valueOf(EEFFont.class.getCanonicalName()) + ".";
    private Font font;

    public EEFFont(String name, int height, int style) {
        this.font = this.getFont(name, height, style);
    }

    private Font getFont(String name, int height, int style) {
        int fontHeight;
        FontData defaultFontData = JFaceResources.getFontRegistry().defaultFont().getFontData()[0];
        String fontName = name;
        if (fontName == null) {
            fontName = defaultFontData.getName();
        }
        if ((fontHeight = height) == 0) {
            fontHeight = defaultFontData.getHeight();
        }
        String key = this.getFontKey(fontName, fontHeight, style);
        if (JFaceResources.getFontRegistry().hasValueFor(key)) {
            return JFaceResources.getFontRegistry().get(key);
        }
        JFaceResources.getFontRegistry().put(key, new FontData[]{new FontData(fontName, fontHeight, style)});
        return this.getFont(key);
    }

    private Font getFont(String key) {
        return JFaceResources.getFontRegistry().get(key);
    }

    private String getFontKey(String name, int height, int style) {
        return String.valueOf(KEY_PREFIX) + "_FONT_" + name + "_" + height + "_" + style;
    }

    public Font getFont() {
        return this.font;
    }
}

