/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.debug;

import org.eclipse.cft.server.core.AbstractDebugProvider;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.application.ModuleChangeEvent;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.debug.ConnectToDebuggerListener;
import org.eclipse.cft.server.core.internal.debug.DebugProviderRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;

public abstract class ApplicationDebugLauncher {
    public static final ApplicationDebugLauncher NO_DEBUG = new ApplicationDebugLauncher(){

        @Override
        public void launch(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int appInstance, int remoteDebugPort) throws CoreException {
            throw CloudErrorUtil.toCoreException("Debug not supported for " + cloudServer.getServer().getId());
        }
    };

    public abstract void launch(CloudFoundryApplicationModule var1, CloudFoundryServer var2, int var3, int var4) throws CoreException;

    public static void terminateLaunch(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int appInstance) throws CoreException {
        AbstractDebugProvider provider = DebugProviderRegistry.getProvider(appModule, cloudServer);
        if (provider != null) {
            String appLaunchId = provider.getApplicationDebugLaunchId(appModule.getLocalModule(), cloudServer.getServer(), appInstance);
            ApplicationDebugLauncher.terminateLaunch(appLaunchId);
        }
    }

    public boolean supportsDebug(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        AbstractDebugProvider provider = DebugProviderRegistry.getProvider(appModule, cloudServer);
        return provider != null && provider.isDebugSupported(appModule.getLocalModule(), cloudServer.getServer());
    }

    public boolean isConnectedToDebugger(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int appInstance) {
        AbstractDebugProvider provider = DebugProviderRegistry.getProvider(appModule, cloudServer);
        if (provider != null) {
            try {
                String id = provider.getApplicationDebugLaunchId(appModule.getLocalModule(), cloudServer.getServer(), appInstance);
                return ApplicationDebugLauncher.getActiveLaunch(id) != null;
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logWarning(e.getMessage());
            }
        }
        return false;
    }

    public static void terminateLaunch(String launchId) {
        ILaunch launch = ApplicationDebugLauncher.getLaunch(launchId);
        CloudFoundryServer cloudServer = null;
        CloudFoundryApplicationModule appModule = null;
        CoreException error = null;
        appModule = null;
        if (launch != null) {
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            if (config != null) {
                try {
                    String appName;
                    String serverId = config.getAttribute("cloudDebugServer", null);
                    cloudServer = CloudServerUtil.getCloudServer(serverId);
                    if (cloudServer != null && (appName = config.getAttribute("cloudDebugAppName", null)) != null) {
                        appModule = cloudServer.getExistingCloudModule(appName);
                    }
                }
                catch (CoreException e) {
                    error = e;
                }
            }
            if (!launch.isTerminated()) {
                try {
                    launch.terminate();
                }
                catch (DebugException e) {
                    CloudFoundryPlugin.logError("Failed to terminate debug connection for : " + launchId, e);
                }
            }
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            if (cloudServer == null || appModule == null) {
                String errorMessage = "Unable to resolve cloud server or application when notifying of debug termination - " + launchId;
                CloudFoundryPlugin.logError(errorMessage, error);
            } else {
                ApplicationDebugLauncher.fireDebugChanged(cloudServer, appModule, Status.OK_STATUS);
            }
        }
    }

    public static void addDebuggerConnectionListener(String connectionId, ILaunch launch) {
        IDebugTarget source = launch.getDebugTarget();
        ConnectToDebuggerListener debugListener = new ConnectToDebuggerListener(connectionId, source);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)debugListener);
    }

    public static ILaunch getActiveLaunch(String launchId) {
        ILaunch launch = ApplicationDebugLauncher.getLaunch(launchId);
        return launch != null && !launch.isTerminated() ? launch : null;
    }

    public static ILaunch getLaunch(String launchId) {
        ILaunch[] launches;
        if (launchId == null) {
            return null;
        }
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            try {
                if (config != null && launchId.equals(config.getAttribute("cloudDebugAppLaunchId", null))) {
                    return launch;
                }
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logWarning(e.getMessage());
            }
            ++n2;
        }
        return null;
    }

    public static final void fireDebugChanged(CloudFoundryServer cloudServer, CloudFoundryApplicationModule appModule, IStatus status) {
        ServerEventHandler.getDefault().fireServerEvent(new ModuleChangeEvent(cloudServer, 500, appModule.getLocalModule(), status));
    }
}

