/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import java.util.Objects;

public final class CodeReplacement {
    private final int startPosition;
    private final int length;
    private final String newContent;
    private final String sortKey;

    public CodeReplacement(int startPosition, int length, String newContent) {
        this(startPosition, length, newContent, "");
    }

    CodeReplacement(int startPosition, int length, String newContent, String sortKey) {
        this.startPosition = startPosition;
        this.length = length;
        this.newContent = newContent;
        this.sortKey = sortKey;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getLength() {
        return this.length;
    }

    public String getNewContent() {
        return this.newContent;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public String toString() {
        return String.format("Start position: %d\nLength: %d\nNew Content: \"%s\"", this.startPosition, this.length, this.newContent);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeReplacement)) {
            return false;
        }
        CodeReplacement other = (CodeReplacement)o;
        return this.startPosition == other.startPosition && this.length == other.length && this.newContent.equals(other.newContent);
    }

    public int hashCode() {
        return Objects.hash(this.startPosition, this.length, this.newContent);
    }
}

