/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.editor;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.internal.core.databinding.ui.editor.ICompleteListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiContentProviderComposite
extends Composite
implements ICompleteListener {
    private final IPageListener m_listener;
    private final List<IUiContentProvider> m_providers;

    public UiContentProviderComposite(IPageListener listener, List<IUiContentProvider> providers, Composite parent, int style) {
        super(parent, style);
        this.m_listener = listener;
        this.m_providers = providers;
        int columns = 0;
        for (IUiContentProvider provider : this.m_providers) {
            columns = Math.max(columns, provider.getNumberOfControls());
        }
        GridLayoutFactory.create((Composite)this).columns(columns);
        for (IUiContentProvider provider : this.m_providers) {
            provider.setCompleteListener(this);
            provider.createContent(this, columns);
        }
    }

    @Override
    public void calculateFinish() {
        for (IUiContentProvider provider : this.m_providers) {
            String errorMessage = provider.getErrorMessage();
            if (errorMessage == null) continue;
            this.m_listener.setErrorMessage(errorMessage);
            this.m_listener.setPageComplete(false);
            return;
        }
        this.m_listener.setErrorMessage(null);
        this.m_listener.setPageComplete(true);
    }

    public void performInitialize() throws Exception {
        for (IUiContentProvider provider : this.m_providers) {
            provider.updateFromObject();
        }
        this.calculateFinish();
    }

    public void performFinish() throws Exception {
        for (IUiContentProvider provider : this.m_providers) {
            provider.saveToObject();
        }
    }
}

