/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.viatra.query.patternlanguage.emf.ui.EMFPatternLanguageUIPlugin;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.emf.helper.ViatraQueryRuntimeHelper;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
class QueryResultTreeLabelProvider extends ColumnLabelProvider {
  private final ImageRegistry imageRegistry = EMFPatternLanguageUIPlugin.getInstance().getImageRegistry();
  
  private AdapterFactoryLabelProvider adapterFactoryLabelProvider;
  
  private final static String QUERY_EXPLORER_ANNOTATION = "QueryExplorer";
  
  private final static String LABEL_ANNOTATION = "Label";
  
  public QueryResultTreeLabelProvider() {
    final AdapterFactory adapterFactory = QueryResultViewUtil.getGenericAdapterFactory();
    AdapterFactoryLabelProvider _adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(adapterFactory);
    this.adapterFactoryLabelProvider = _adapterFactoryLabelProvider;
  }
  
  @Override
  public Image getImage(final Object element) {
    return this.getImageInternal(element);
  }
  
  protected Image _getImageInternal(final QueryResultTreeInput element) {
    return this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_ROOT);
  }
  
  protected Image _getImageInternal(final QueryResultTreeMatcher<?> element) {
    Image _xifexpression = null;
    Exception _exception = element.getException();
    boolean _tripleNotEquals = (_exception != null);
    if (_tripleNotEquals) {
      _xifexpression = this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_ERROR);
    } else {
      _xifexpression = this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_MATCHER);
    }
    return _xifexpression;
  }
  
  protected Image _getImageInternal(final IPatternMatch element) {
    return this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_MATCH);
  }
  
  protected Image _getImageInternal(final Object element) {
    return this.adapterFactoryLabelProvider.getImage(element);
  }
  
  @Override
  public String getText(final Object element) {
    return this.getTextInternal(element);
  }
  
  protected String _getTextInternal(final QueryResultTreeInput element) {
    return element.getEngine().toString();
  }
  
  protected String _getTextInternal(final QueryResultTreeMatcher<?> element) {
    Exception _exception = element.getException();
    boolean _tripleNotEquals = (_exception != null);
    if (_tripleNotEquals) {
      StringConcatenation _builder = new StringConcatenation();
      IQuerySpecificationRegistryEntry _entry = element.getEntry();
      String _fullyQualifiedName = null;
      if (_entry!=null) {
        _fullyQualifiedName=_entry.getFullyQualifiedName();
      }
      _builder.append(_fullyQualifiedName);
      _builder.append(" - ");
      String _message = element.getException().getMessage();
      _builder.append(_message);
      return _builder.toString();
    }
    final ViatraQueryMatcher<? extends IPatternMatch> matcher = element.getMatcher();
    final int count = element.getMatchCount();
    String _switchResult = null;
    switch (count) {
      case 0:
        _switchResult = "No matches";
        break;
      case 1:
        _switchResult = "1 match";
        break;
      default:
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(count);
        _builder_1.append(" matches");
        _switchResult = _builder_1.toString();
        break;
    }
    final String countMsg = _switchResult;
    String _xifexpression = null;
    boolean _isFiltered = element.isFiltered();
    if (_isFiltered) {
      _xifexpression = " (Filtered)";
    } else {
      _xifexpression = "";
    }
    final String filterMsg = _xifexpression;
    StringConcatenation _builder_1 = new StringConcatenation();
    String _fullyQualifiedName_1 = matcher.getSpecification().getFullyQualifiedName();
    _builder_1.append(_fullyQualifiedName_1);
    _builder_1.append(" - ");
    _builder_1.append(countMsg);
    _builder_1.append(filterMsg);
    return _builder_1.toString();
  }
  
  protected String _getTextInternal(final IPatternMatch element) {
    final String message = this.getMessage(element);
    if ((message != null)) {
      final Function<Object, String> _function = (Object it) -> {
        return this.adapterFactoryLabelProvider.getText(it);
      };
      return ViatraQueryRuntimeHelper.getMessage(element, message, _function);
    }
    return element.prettyPrint();
  }
  
  protected String _getTextInternal(final Object element) {
    return this.adapterFactoryLabelProvider.getText(element);
  }
  
  public String getMessage(final IPatternMatch match) {
    final Function<PAnnotation, Optional<String>> _function = (PAnnotation it) -> {
      return it.<String>getFirstValue("message", String.class);
    };
    final Function<PAnnotation, Optional<String>> _function_1 = (PAnnotation it) -> {
      return it.<String>getFirstValue("message", String.class);
    };
    Optional<String> _flatMap = match.specification().getFirstAnnotationByName(QueryResultTreeLabelProvider.QUERY_EXPLORER_ANNOTATION).<String>flatMap(_function_1);
    String _xifexpression = null;
    boolean _isEmpty = match.parameterNames().isEmpty();
    if (_isEmpty) {
      _xifexpression = "(Match)";
    } else {
      StringConcatenation _builder = new StringConcatenation();
      {
        List<String> _parameterNames = match.parameterNames();
        boolean _hasElements = false;
        for(final String param : _parameterNames) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate(", ", "");
          }
          _builder.append(param);
          _builder.append("=$");
          _builder.append(param);
          _builder.append("$");
        }
      }
      _xifexpression = _builder.toString();
    }
    return match.specification().getFirstAnnotationByName(QueryResultTreeLabelProvider.LABEL_ANNOTATION).<String>flatMap(_function).orElse(
      _flatMap.orElse(_xifexpression));
  }
  
  public Image getImageInternal(final Object element) {
    if (element instanceof IPatternMatch) {
      return _getImageInternal((IPatternMatch)element);
    } else if (element instanceof QueryResultTreeInput) {
      return _getImageInternal((QueryResultTreeInput)element);
    } else if (element instanceof QueryResultTreeMatcher) {
      return _getImageInternal((QueryResultTreeMatcher<?>)element);
    } else if (element != null) {
      return _getImageInternal(element);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(element).toString());
    }
  }
  
  public String getTextInternal(final Object element) {
    if (element instanceof IPatternMatch) {
      return _getTextInternal((IPatternMatch)element);
    } else if (element instanceof QueryResultTreeInput) {
      return _getTextInternal((QueryResultTreeInput)element);
    } else if (element instanceof QueryResultTreeMatcher) {
      return _getTextInternal((QueryResultTreeMatcher<?>)element);
    } else if (element != null) {
      return _getTextInternal(element);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(element).toString());
    }
  }
}
